//
//	Workaround for win95/NT show() blocking bug, and non-modal dialogs
//

package  cryptix.gui;

import java.awt.*;

class WarningDialog extends Dialog implements Runnable
{
	Thread dialogThread;
    Button ok = new Button("OK");

	public WarningDialog(Frame parent, String err)
	{
		super(parent, "Appname: Warning", true);	// For testing on FreeBSD

		// Doesn't work
		// setResizable(false);

        setLayout(new BorderLayout());

        Panel buttonPanel = new Panel();
        buttonPanel.setLayout(new FlowLayout());
        buttonPanel.add(ok);

        add("Center", new Label("Warning: "+err));
        add("South", buttonPanel);

		pack();
		move(100, 100);
	}

	public void show()
	{
		// Create a new thread to do the show
		dialogThread = new Thread(this, "WarningDialog");
		dialogThread.start();
	}

	public void run()
	{
		super.show();
		dialogThread.suspend();	// Block until woken up
	}

    public boolean action(Event event, Object arg)
    {
		hide();
		dialogThread.resume();	// Wake up waiting thread
		return true;
    }

    public static void main( String argv[] )
    {
	    MainFrame top = new MainFrame("WarningDialog (mainframe)");

	    WarningDialog test = new WarningDialog(top, "Testing testing ...");
		test.show();

//		System.exit(-1);
    }
}
