/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.CallFrame;
import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclString;
import tcl.lang.Util;

class UplevelCmd
implements Command {
    public void cmdProc(Interp interp, TclObject[] argv) throws TclException {
        int startIdx;
        if (argv.length < 2) {
            throw new TclNumArgsException(interp, 1, argv, "?level? command ?arg ...?");
        }
        CallFrame frame = interp.varFrame.getFrame(argv[1].toString());
        if (frame != null) {
            if (argv.length < 3) {
                throw new TclNumArgsException(interp, 1, argv, "?level? command ?arg ...?");
            }
            startIdx = 2;
        } else {
            startIdx = 1;
            frame = interp.varFrame.callerVar;
        }
        TclObject cmd = startIdx == argv.length - 1 ? argv[startIdx] : TclString.newInstance((String)Util.concat(startIdx, argv.length - 1, argv));
        cmd.preserve();
        CallFrame savedVarFrame = interp.varFrame;
        interp.varFrame = frame;
        try {
            try {
                interp.eval(cmd, 0);
            }
            catch (TclException e) {
                if (e.getCompletionCode() == 1) {
                    interp.addErrorInfo("\n    (\"uplevel\" body line " + interp.errorLine + ")");
                }
                throw e;
            }
            Object var8_8 = null;
            interp.varFrame = savedVarFrame;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            interp.varFrame = savedVarFrame;
            cmd.release();
            throw throwable;
        }
        cmd.release();
    }

    UplevelCmd() {
    }
}

