/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.io.IOException;
import tcl.lang.Channel;
import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclIO;
import tcl.lang.TclInteger;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;

class ReadCmd
implements Command {
    public void cmdProc(Interp interp, TclObject[] argv) throws TclException {
        Channel chan;
        int i = 1;
        int numBytes = 0;
        boolean readAll = true;
        boolean noNewline = false;
        if (argv.length != 2 && argv.length != 3) {
            this.errorWrongNumArgs(interp, argv[0].toString());
        }
        if (argv[i].toString().equals("-nonewline")) {
            noNewline = true;
            ++i;
        }
        if (i == argv.length) {
            this.errorWrongNumArgs(interp, argv[0].toString());
        }
        if ((chan = TclIO.getChannel(interp, argv[i].toString())) == null) {
            throw new TclException(interp, "can not find channel named \"" + argv[i].toString() + "\"");
        }
        if ((chan.getMode() & 1) == 0) {
            throw new TclException(interp, "channel \"" + chan.getChanName() + "\" wasn't opened for reading");
        }
        if (++i < argv.length) {
            String arg = argv[i].toString();
            if (Character.isDigit(arg.charAt(0))) {
                numBytes = TclInteger.get((Interp)interp, (TclObject)argv[i]);
                readAll = false;
            } else if (arg.equals("nonewline")) {
                noNewline = true;
            } else {
                throw new TclException(interp, "bad argument \"" + arg + "\": should be \"nonewline\"");
            }
        }
        try {
            String inStr;
            if (readAll) {
                inStr = chan.read(interp, 1, 0);
                if (noNewline && inStr.length() != 0 && inStr.charAt(inStr.length() - 1) == '\n') {
                    interp.setResult(inStr.substring(0, inStr.length() - 2));
                    return;
                }
            } else {
                inStr = chan.read(interp, 3, numBytes);
            }
            interp.setResult(inStr);
        }
        catch (IOException e) {
            throw new TclRuntimeError("ReadCmd.cmdProc() Error: IOException when reading " + chan.getChanName());
        }
    }

    private void errorWrongNumArgs(Interp interp, String cmd) throws TclException {
        throw new TclException(interp, "wrong # args: should be \"read channelId ?numBytes?\" or \"read ?-nonewline? channelId\"");
    }

    ReadCmd() {
    }
}

