/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.Channel;
import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclIO;
import tcl.lang.TclIndex;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;

class FconfigureCmd
implements Command {
    private static final String[] validCmds = new String[]{"-blocking", "-buffering", "-buffersize", "-eofchar", "-translation"};
    static final int OPT_BLOCKING = 0;
    static final int OPT_BUFFERING = 1;
    static final int OPT_BUFFERSIZE = 2;
    static final int OPT_EOFCHAR = 3;
    static final int OPT_TRANSLATION = 4;

    public void cmdProc(Interp interp, TclObject[] argv) throws TclException {
        if (argv.length < 2 || argv.length % 2 == 1 && argv.length != 3) {
            throw new TclNumArgsException(interp, 1, argv, "channelId ?optionName? ?value? ?optionName value?...");
        }
        Channel chan = TclIO.getChannel(interp, argv[1].toString());
        if (chan == null) {
            throw new TclException(interp, "can not find channel named \"" + argv[1].toString() + "\"");
        }
        if (argv.length == 2) {
            // empty if block
        }
        if (argv.length == 3) {
            int index = TclIndex.get((Interp)interp, (TclObject)argv[2], (String[])validCmds, (String)"option", (int)0);
            switch (index) {
                case 0: {
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    break;
                }
                default: {
                    throw new TclRuntimeError("Fconfigure.cmdProc() error: incorrect index returned from TclIndex.get()");
                }
            }
        }
        int i = 3;
        while (i < argv.length) {
            int index = TclIndex.get((Interp)interp, (TclObject)argv[i - 1], (String[])validCmds, (String)"option", (int)0);
            switch (index) {
                case 0: {
                    break;
                }
                case 1: {
                    String arg = argv[i].toString();
                    if (arg.equals("full") || arg.equals("line") || arg.equals("none")) break;
                    throw new TclException(interp, "bad value for -buffering: must be one of full, line, or none");
                }
                case 2: {
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    String arg = argv[i].toString();
                    if (arg.equals("auto") || arg.equals("binary") || arg.equals("cr") || arg.equals("crlf") || arg.equals("lf")) break;
                    throw new TclException(interp, "bad value for -translation: must be one of auto, binary, cr, lf, crlf, or platform");
                }
                default: {
                    throw new TclRuntimeError("Fconfigure.cmdProc() error: incorrect index returned from TclIndex.get()");
                }
            }
            i += 2;
        }
        throw new TclException(interp, "fconfigure command not implemented yet");
    }

    FconfigureCmd() {
    }
}

