 /*
  * Khoros: $Id: run_persp.c,v 1.1 1991/05/10 15:59:03 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: run_persp.c,v 1.1 1991/05/10 15:59:03 khoros Exp $";
#endif

 /*
  * $Log: run_persp.c,v $
 * Revision 1.1  1991/05/10  15:59:03  khoros
 * Initial revision
 *
  */ 

/*
 *---------------------------------------------------------------------
 *            Copyright 1990 University of New Mexico
 * 
 * Permission to copy and modify this software and its documen- 
 * tation only for internal use in your organization is hereby 
 * granted, provided that this notice is retained thereon and 
 * on all copies.  UNM makes no representations as too the sui- 
 * tability and operability of this software for any purpose. 
 * It is provided 'as is' without express or implied warranty. 
 *  
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, 
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT- 
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL, 
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT- 
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER 
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS 
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER- 
 * FORMANCE OF THIS SOFTWARE. 
 *  
 * No other rights, including for example, the right to redis- 
 * tribute this software and its documentation or the right to 
 * prepare derivative works, are granted unless specifically 
 * provided in a separate license agreement. 
 * 
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"
#include "viewimage.h"


/********************************************************
*
*  Routine Name:  run_persp_subform
*
*       Purpose:  drives the subform 'persp_subform'
*
*         Input:  form - pointer to the form tree 
*		  persp_subform_info  - information structure for subform 'persp_subform'
*        Output:  action of the application program
*
*     Called By:  run_view()
*
*   Automatically Generated By:  conductor -i viewimage.form -l 3 -b
*
********************************************************/


run_persp_subform(form, persp_subform_info)

xvf_form *form;
view_persp_subform *persp_subform_info;
{

	_xvf_get_persp_subform(form, persp_subform_info);

	/*
	 * action came from the 'persp' pane
	 */
	if (persp_subform_info->persp_selected)
	    run_persp(form, persp_subform_info->persp);

}   /* end run_persp_subform */


/********************************************************
*
*  Routine Name:  run_persp
*
*       Purpose:  drives the pane 'persp'
*
*         Input:  form - pointer to the form tree 
*		  persp_info  - information structure for pane 'persp'
*        Output:  action of the application program
*
*     Called By:  run_persp_subform()
*
*   Automatically Generated By:  conductor -i viewimage.form -l 3 -b
*
********************************************************/

#define FRONT	1
#define BACK	2
#define LEFT	3
#define RIGHT	4
#define TOP	5
#define BOTTOM	6
#define RESET	7

run_persp(form, persp_info)

xvf_form *form;
persp_subform_persp *persp_info;
{
	_xvf_get_persp(form, persp_info);

	if (persp_info->views_selected)
	{
	   switch(persp_info->views_val)
	   {
	      case FRONT:
	           persp->alpha_val = 90.0;
	           persp->theta_val = 0.0;
		   break;

	      case BACK:
	           persp->alpha_val = 270.0;
	           persp->theta_val = 0.0;
		   break;

	      case LEFT:
	           persp->alpha_val = 90.0;
	           persp->theta_val = 270.0;
		   break;

	      case RIGHT:
	           persp->alpha_val = 90.0;
	           persp->theta_val = 90.0;
		   break;

	      case TOP:
	           persp->alpha_val = 0.0;
	           persp->theta_val = 0.0;
		   break;

	      case BOTTOM:
	           persp->alpha_val = 180.0;
	           persp->theta_val = 0.0;
		   break;

	      case RESET:
		   persp->eye_dist  = 8.0;
	           update_float_scroll(persp->eye, persp->eye_dist, 10.0);

	           persp->alpha_val = 63.7;
	           persp->theta_val = 31.8;
		   break;

	   }
	   update_float_scroll(persp->alpha, persp->alpha_val, 360.0);
	   update_float_scroll(persp->theta, persp->theta_val, 360.0);
	   update_persp();
	}
}




/************************************************************
*
*  MODULE NAME: update_persp
*
*      PURPOSE: Updates the perspective according to the
*		global "persp" structure.  Which contains the
*		current alpha, theta, and eye distance values.
*
*        INPUT: none
*
*       OUTPUT: none
*
*   WRITTEN BY: Mark Young
*
*
*************************************************************/

update_persp()
{
	int	i;
	Arg	args[MaxArgs];

	i = 0;
	set_floatarg(args, i, XtNeye,   &persp->eye_dist);	   i++;
	set_floatarg(args, i, XtNalpha, &persp->alpha_val);	   i++;
	set_floatarg(args, i, XtNtheta, &persp->theta_val);	   i++;
	XtSetValues(plot->workspace, args, i);
}



/************************************************************
*
*  MODULE NAME: update_persp_cont
*
*      PURPOSE: Updates the perspective scrollbars, from the
*		perspective workspace the user moves the slider
*		on the eye, alpha, or theta scroll bar
*		(called when the slider is used continuously)
*
*        INPUT: widget     -  the widget for the event
*               clientData -  not used
*               event      -  the event
*
*       OUTPUT: none
*
*   WRITTEN BY: Mark Young
*
*
*************************************************************/


void  update_persp_cont(widget, clientData, callData)

Widget	widget;
caddr_t	clientData, callData;
{
	float	*number = (float *) callData;
        PerspStructure *persp = (PerspStructure *) clientData;

	ScrollStruct   *eye   = persp->eye;
	ScrollStruct   *alpha = persp->alpha;
	ScrollStruct   *theta = persp->theta;


	if (eye->scrollbar == widget)
	{
	   persp->eye_dist = (*number) * 10.0;
	   update_float_scroll(eye, persp->eye_dist, 10.0);
	}
	else if (alpha->scrollbar == widget)
	{
	   persp->alpha_val = (*number) * 360.0;
	   update_float_scroll(alpha, persp->alpha_val, 360.0);
	}
	else if (theta->scrollbar == widget)
	{
	   persp->theta_val = (*number) * 360.0;
	   update_float_scroll(theta, persp->theta_val, 360.0);
	}
	update_persp();
}



/************************************************************
*
*  MODULE NAME: update_persp_incr
*
*      PURPOSE: Updates the perspective scrollbars, from the
*		perspective workspace the user moves the slider
*		on the eye, alpha, or theta scroll bar
*		(called when the slider is used incrementally)
*
*        INPUT: widget     -  the widget for the event
*               clientData -  not used
*               event      -  the event
*
*       OUTPUT: none
*
*   WRITTEN BY: Mark Young
*
*
*************************************************************/


void  update_persp_incr(widget, clientData, callData)

Widget	widget;
caddr_t	clientData, callData;
{
	int	movement = (int) callData, index;
	PerspStructure *persp = (PerspStructure *) clientData;

	ScrollStruct   *eye   = persp->eye;
	ScrollStruct   *alpha = persp->alpha;
	ScrollStruct   *theta = persp->theta;


	if (eye->scrollbar == widget)
	{
   	   if (movement > 0)
   	   {
      	       persp->eye_dist -= 1.0; 
               if (persp->eye_dist < 0.0)
	          persp->eye_dist = 0.0;
   	   }
   	   else if (movement < 0)
   	   {
      	       persp->eye_dist += 1.0;
      	       if (persp->eye_dist > 10.0)
	          persp->eye_dist = 10.0;
   	   }
	   update_float_scroll(eye, persp->eye_dist, 10.0);
	}
	else if (alpha->scrollbar == widget)
	{
   	   if (movement > 0)
   	   {
      	       persp->alpha_val -= 10.0; 
               if (persp->alpha_val < 0.0)
	          persp->alpha_val = 0.0;
   	   }
   	   else if (movement < 0)
   	   {
      	       persp->alpha_val += 10.0;
      	       if (persp->alpha_val > 360.0)
	          persp->alpha_val = 360.0;
   	   }
	   update_float_scroll(alpha, persp->alpha_val, 360.0);
	}
	else if (theta->scrollbar == widget)
	{
   	   if (movement > 0)
   	   {
      	       persp->theta_val -= 10.0; 
               if (persp->theta_val < 0.0)
	          persp->theta_val = 0.0;
   	   }
   	   else if (movement < 0)
   	   {
      	       persp->theta_val += 10.0;
      	       if (persp->theta_val > 360.0)
	          persp->theta_val = 360.0;
   	   }
	   update_float_scroll(theta, persp->theta_val, 360.0);
	}
	update_persp();
}
