 /*
  * Khoros: $Id: concert.c,v 1.1 1991/05/10 15:58:22 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: concert.c,v 1.1 1991/05/10 15:58:22 khoros Exp $";
#endif

 /*
  * $Log: concert.c,v $
 * Revision 1.1  1991/05/10  15:58:22  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: concert.c
 >>>>
 >>>>      Program Name: concert
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Instruction & collaboration program
 >>>>	
 >>>>	
 >>>>            Author: Mark Young & Danielle Argiro
 >>>>
 >>>> Date Last Updated: Tue Apr  2 15:04:00 1991
 >>>>
 >>>>          Routines: main- the main program for concert
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "concert.h"


/****************************************************************
 *
 * Routine Name:  main program for concert
 *
 *       Input:  
 *         -command  name of Khoros program to be executed 
 *         -d2  second display  
 *
 *
 *         [-master] Master/Slave mode (true) or Equal-Participant Mode (false)
 *         [-d3] third display 
 *         [-d4] fourth display 
 *         [-d5] fifth display 
 *         [-d6] sixth display 
 *         [-d7] seventh display 
 *         [-d8] eighth display 
 *         [-d9] ninth display 
 *         [-d10] tenth display 
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
/* -main_before_lib_call_end */

/* -main_library_call */
        if (!(lconcert(concert->command, concert->master, concert->d2,
                       concert->d3, concert->d4, concert->d5, concert->d6,
                       concert->d7, concert->d8, concert->d9, concert->d10)))
        {
           exit(1);
        }
/* -main_library_call_end */

/* -main_after_lib_call */
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for concert 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "concert :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tInstruction & collaboration program\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-command  name of Khoros program to be executed  (string)\n");
	fprintf(stderr,"\t-d2  second display   (string)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-master]  Master/Slave mode (true) or Equal-Participant Mode (false) (boolean) [false]\n");
	fprintf(stderr,"\t[-d3]  third display  (string) [null]\n");
	fprintf(stderr,"\t[-d4]  fourth display  (string) [null]\n");
	fprintf(stderr,"\t[-d5]  fifth display  (string) [null]\n");
	fprintf(stderr,"\t[-d6]  sixth display  (string) [null]\n");
	fprintf(stderr,"\t[-d7]  seventh display  (string) [null]\n");
	fprintf(stderr,"\t[-d8]  eighth display  (string) [null]\n");
	fprintf(stderr,"\t[-d9]  ninth display  (string) [null]\n");
	fprintf(stderr,"\t[-d10]  tenth display  (string) [null]\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for concert\n");
	fprintf(stderr, "\t[-U] Gives the usage for concert\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called concert.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses concert.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for concert
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*command_pstr = 
	"\nEnter: (command) name of Khoros program to be executed \n        {string}: "; 
char	*command_def = NULL;
char	*d2_pstr = 
	"\nEnter: (d2) second display  \n        {string}: "; 
char	*d2_def = NULL;
char	*master_pstr = 
	"\nEnter: (master) Master/Slave mode (true) or Equal-Participant Mode (false) \n        {boolean, (y/n)  [no] }: "; 
char	*d3_pstr = 
	"\nEnter: (d3) third display  \n        {string}: "; 
char	*d3_def = NULL;
char	*d4_pstr = 
	"\nEnter: (d4) fourth display  \n        {string}: "; 
char	*d4_def = NULL;
char	*d5_pstr = 
	"\nEnter: (d5) fifth display  \n        {string}: "; 
char	*d5_def = NULL;
char	*d6_pstr = 
	"\nEnter: (d6) sixth display  \n        {string}: "; 
char	*d6_def = NULL;
char	*d7_pstr = 
	"\nEnter: (d7) seventh display  \n        {string}: "; 
char	*d7_def = NULL;
char	*d8_pstr = 
	"\nEnter: (d8) eighth display  \n        {string}: "; 
char	*d8_def = NULL;
char	*d9_pstr = 
	"\nEnter: (d9) ninth display  \n        {string}: "; 
char	*d9_def = NULL;
char	*d10_pstr = 
	"\nEnter: (d10) tenth display  \n        {string}: "; 
char	*d10_def = NULL;
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "concert", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "concert.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "concert: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "concert.ans");
		}

	     }

	}

	/*
	 * allocate the concert structure
	 */
	concert = (concert_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (concert_struct));

	/*
	 * get required arguments for concert
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(concert->command_flag = vget_string(fid, prompt_flag,
			"-command", command_pstr, &(concert->command),
			command_def)))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(concert->command_flag))
		{
		    fprintf(stderr, "\t\tcommand is required, please re-enter: \n");
		    concert->command_flag = vget_string(fid, prompt_flag,
		    "-command", command_pstr, &(concert->command),
		    command_def);

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-command' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(concert->d2_flag = vget_string(fid, prompt_flag,
			"-d2", d2_pstr, &(concert->d2),
			d2_def)))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(concert->d2_flag))
		{
		    fprintf(stderr, "\t\td2 is required, please re-enter: \n");
		    concert->d2_flag = vget_string(fid, prompt_flag,
		    "-d2", d2_pstr, &(concert->d2),
		    d2_def);

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-d2' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for concert
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	concert->master_flag = vget_logic(fid, prompt_flag,
	"-master", master_pstr, &(concert->master), 0);

	concert->d3_flag = vget_string(fid, prompt_flag,
	"-d3", d3_pstr, &(concert->d3),
	d3_def);

	if (prompt_flag == FALSE)
	{
	    if ((concert->d3_flag == 1)&&(concert->d3 == NULL))
    	{
		fprintf(stderr, "concert:\n");
		fprintf(stderr, "you must specify a name following '-d3'\n");
		gw_usage();
		exit(1);
		}
	}
	concert->d4_flag = vget_string(fid, prompt_flag,
	"-d4", d4_pstr, &(concert->d4),
	d4_def);

	if (prompt_flag == FALSE)
	{
	    if ((concert->d4_flag == 1)&&(concert->d4 == NULL))
    	{
		fprintf(stderr, "concert:\n");
		fprintf(stderr, "you must specify a name following '-d4'\n");
		gw_usage();
		exit(1);
		}
	}
	concert->d5_flag = vget_string(fid, prompt_flag,
	"-d5", d5_pstr, &(concert->d5),
	d5_def);

	if (prompt_flag == FALSE)
	{
	    if ((concert->d5_flag == 1)&&(concert->d5 == NULL))
    	{
		fprintf(stderr, "concert:\n");
		fprintf(stderr, "you must specify a name following '-d5'\n");
		gw_usage();
		exit(1);
		}
	}
	concert->d6_flag = vget_string(fid, prompt_flag,
	"-d6", d6_pstr, &(concert->d6),
	d6_def);

	if (prompt_flag == FALSE)
	{
	    if ((concert->d6_flag == 1)&&(concert->d6 == NULL))
    	{
		fprintf(stderr, "concert:\n");
		fprintf(stderr, "you must specify a name following '-d6'\n");
		gw_usage();
		exit(1);
		}
	}
	concert->d7_flag = vget_string(fid, prompt_flag,
	"-d7", d7_pstr, &(concert->d7),
	d7_def);

	if (prompt_flag == FALSE)
	{
	    if ((concert->d7_flag == 1)&&(concert->d7 == NULL))
    	{
		fprintf(stderr, "concert:\n");
		fprintf(stderr, "you must specify a name following '-d7'\n");
		gw_usage();
		exit(1);
		}
	}
	concert->d8_flag = vget_string(fid, prompt_flag,
	"-d8", d8_pstr, &(concert->d8),
	d8_def);

	if (prompt_flag == FALSE)
	{
	    if ((concert->d8_flag == 1)&&(concert->d8 == NULL))
    	{
		fprintf(stderr, "concert:\n");
		fprintf(stderr, "you must specify a name following '-d8'\n");
		gw_usage();
		exit(1);
		}
	}
	concert->d9_flag = vget_string(fid, prompt_flag,
	"-d9", d9_pstr, &(concert->d9),
	d9_def);

	if (prompt_flag == FALSE)
	{
	    if ((concert->d9_flag == 1)&&(concert->d9 == NULL))
    	{
		fprintf(stderr, "concert:\n");
		fprintf(stderr, "you must specify a name following '-d9'\n");
		gw_usage();
		exit(1);
		}
	}
	concert->d10_flag = vget_string(fid, prompt_flag,
	"-d10", d10_pstr, &(concert->d10),
	d10_def);

	if (prompt_flag == FALSE)
	{
	    if ((concert->d10_flag == 1)&&(concert->d10 == NULL))
    	{
		fprintf(stderr, "concert:\n");
		fprintf(stderr, "you must specify a name following '-d10'\n");
		gw_usage();
		exit(1);
		}
	}

}



