 /*
  * Khoros: $Id: active.c,v 1.1 1991/05/10 15:58:12 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: active.c,v 1.1 1991/05/10 15:58:12 khoros Exp $";
#endif

 /*
  * $Log: active.c,v $
 * Revision 1.1  1991/05/10  15:58:12  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.
 * 
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *----------------------------------------------------------------------
 */

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */
#include "composer.h"


/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: active.c
 >>>>
 >>>>      Program Name: composer
 >>>> 
 >>>> Date Last Updated: Wed Jul 11 16:29:24 MDT 1990
 >>>>
 >>>>          Routines: active()  deactivates portions of user interface
 >>>>           	 init_pane_edit()  deactivates portions of user 
 >>>>                                      interface
 >>>>			 ok_pane_edit()    activates what init_pane_edit
 >>>>                                      deactivates
 >>>>
 >>>>		 Author:  John Rasure
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/

/********************************************************
*
*  Routine Name:  active()
*       Purpose:  deactivates portions of the user intrface that are not
*                 appropriate for a specific user interface line
*         Input:  formptr and info contain form data structure and UI tree
*		  formptr - pointer to the xvform structure
*		  info - pointer for the structure for the edit_pane.
*		  type - index that specifies specific UI line
*        Output:  the pane has user interface items deactivated
*
*     Called By:  process_line()
*
********************************************************/


void
active(formptr, info, type)
xvf_form 	*formptr;
pane_edit_pane  *info;
int		type;
{
    char  	temp[MaxLength];

    switch (type) {
        case InputFile :
        case OutputFile :
        case StringOpt :

            xvf_change_input(formptr, info->var_name_index, 
              xvf_activation_chng, "1", 0);
        
            xvf_change_input(formptr, info->name_index, 
              xvf_activation_chng, "0", 0);
        
	    if (type == InputFile) {
                xvf_change_input(formptr, info->button_label_index, 
                  xvf_title_chng, "Input File Label        ", 0);

                xvf_change_input(formptr, info->default_string_index, 
                  xvf_title_chng, "Default Input File      ", 0);
	    }
	    else if (type == OutputFile) {
                xvf_change_input(formptr, info->button_label_index, 
                  xvf_title_chng, "Output File Label       ", 0);

                xvf_change_input(formptr, info->default_string_index, 
                  xvf_title_chng, "Default Output File     ", 0);
	    }
	    else if (type == StringOpt) {
                xvf_change_input(formptr, info->button_label_index, 
                  xvf_title_chng, "String Label           ", 0);

                xvf_change_input(formptr, info->default_string_index, 
                  xvf_title_chng, "Default String         ", 0);
	    }

            xvf_change_input(formptr, info->button_label_index, 
              xvf_activation_chng, "1", 0);

            xvf_change_input(formptr, info->usage_string_index, 
              xvf_activation_chng, "1", 0);
        
            xvf_change_input(formptr, info->default_string_index, 
                 xvf_activation_chng, "1", 0);

            xvf_change_input(formptr, info->active_index, 
              xvf_activation_chng, "1", 0);
        
            xvf_change_input(formptr, info->live_index, 
              xvf_activation_chng, "1", 0);
        
            xvf_change_input(formptr, info->optional_index, 
              xvf_title_chng, "Item is    ", 0);
        
            xvf_change_input(formptr, info->optional_index, 
              xvf_activation_chng, "1", 0);
        
	    xvf_change_input(formptr, info->opt_selected_index, 
               xvf_activation_chng, "1", 0);
        
            xvf_change_input(formptr, info->gs_width_index,
              xvf_activation_chng, "1", 0);
        
            xvf_change_input(formptr, info->gs_height_index,
              xvf_activation_chng, "1", 0);
        
            xvf_change_input(formptr, info->gs_xoff_index,
              xvf_activation_chng, "1", 0);
        
            xvf_change_input(formptr, info->gs_yoff_index,
              xvf_activation_chng, "1", 0);
        
            xvf_change_input(formptr, info->ps_xoff_index,
              xvf_activation_chng, "1", 0);
        
            xvf_change_input(formptr, info->ps_yoff_index,
              xvf_activation_chng, "1", 0);

            xvf_change_input(formptr, info->toggle_range_index,
              xvf_activation_chng, "0", 0);

            xvf_change_input(formptr, info->default_float_index,
              xvf_title_chng, "Default Value", 0);

            xvf_change_input(formptr, info->default_float_index,
              xvf_activation_chng, "0", 0);

            xvf_change_input(formptr, info->lower_range_index,
              xvf_activation_chng, "0", 0);

            xvf_change_input(formptr, info->upper_range_index,
              xvf_activation_chng, "0", 0);

            xvf_change_input(formptr, info->zero_label_index,
              xvf_activation_chng, "0", 0);

            xvf_change_input(formptr, info->one_label_index,
              xvf_activation_chng, "0", 0);

            xvf_change_input(formptr, info->default_logical_index,
              xvf_activation_chng, "0", 0);

            break;

        case FloatOpt :
        case IntegerOpt :
            xvf_change_input(formptr, info->var_name_index, 
              xvf_activation_chng, "1", 0);
        
            xvf_change_input(formptr, info->name_index, 
              xvf_activation_chng, "0", 0);
        
            xvf_change_input(formptr, info->button_label_index, 
              xvf_activation_chng, "1", 0);

            xvf_change_input(formptr, info->usage_string_index, 
              xvf_activation_chng, "1", 0);

            xvf_change_input(formptr, info->default_string_index, 
              xvf_activation_chng, "0", 0);

	    if (type == FloatOpt) {
                xvf_change_input(formptr, info->button_label_index, 
                  xvf_title_chng, "Float  Label            ", 0);
	    }
	    else if (type == IntegerOpt) {
                xvf_change_input(formptr, info->button_label_index, 
                  xvf_title_chng, "Integer Label          ", 0);
	    }

            xvf_change_input(formptr, info->default_string_index, 
              xvf_title_chng, "not used                 ", 0);
        
            xvf_change_input(formptr, info->active_index, 
              xvf_activation_chng, "1", 0);
        
            xvf_change_input(formptr, info->live_index, 
              xvf_activation_chng, "1", 0);
        
            xvf_change_input(formptr, info->optional_index, 
              xvf_title_chng, "Item is    ", 0);
        
            xvf_change_input(formptr, info->optional_index, 
              xvf_activation_chng, "1", 0);
        
            xvf_change_input(formptr, info->opt_selected_index, 
              xvf_activation_chng, "1", 0);
        
            xvf_change_input(formptr, info->gs_width_index,
              xvf_activation_chng, "1", 0);
        
            xvf_change_input(formptr, info->gs_height_index,
              xvf_activation_chng, "1", 0);
        
            xvf_change_input(formptr, info->gs_xoff_index,
              xvf_activation_chng, "1", 0);
        
            xvf_change_input(formptr, info->gs_yoff_index,
              xvf_activation_chng, "1", 0);
        
            xvf_change_input(formptr, info->ps_xoff_index,
              xvf_activation_chng, "1", 0);
        
            xvf_change_input(formptr, info->ps_yoff_index,
              xvf_activation_chng, "1", 0);

            xvf_change_input(formptr, info->toggle_range_index,
              xvf_activation_chng, "1", 0);

            xvf_change_input(formptr, info->default_float_index,
              xvf_activation_chng, "1", 0);

	    if (type == FloatOpt) {
                xvf_change_input(formptr, info->default_float_index,
                  xvf_title_chng, "Default Float", 0);

	    }
	    else if (type == IntegerOpt) {
                xvf_change_input(formptr, info->default_float_index,
                  xvf_title_chng, "Default Integer", 0);
	    }
            xvf_change_input(formptr, info->lower_range_index,
              xvf_activation_chng, "1", 0);

            xvf_change_input(formptr, info->upper_range_index,
              xvf_activation_chng, "1", 0);

            xvf_change_input(formptr, info->zero_label_index,
              xvf_activation_chng, "0", 0);

            xvf_change_input(formptr, info->one_label_index,
              xvf_activation_chng, "0", 0);

            xvf_change_input(formptr, info->default_logical_index,
              xvf_activation_chng, "0", 0);
            break;

        case LogicOpt :
            xvf_change_input(formptr, info->var_name_index, 
              xvf_activation_chng, "1", 0);
        
            xvf_change_input(formptr, info->name_index, 
              xvf_activation_chng, "0", 0);
        
            xvf_change_input(formptr, info->button_label_index, 
              xvf_activation_chng, "1", 0);

            xvf_change_input(formptr, info->usage_string_index, 
              xvf_activation_chng, "1", 0);

            xvf_change_input(formptr, info->default_string_index, 
              xvf_activation_chng, "0", 0);

            xvf_change_input(formptr, info->default_string_index, 
              xvf_title_chng, "not used                 ", 0);
        
            xvf_change_input(formptr, info->button_label_index, 
              xvf_title_chng, "Logical  Label          ", 0);
        
            xvf_change_input(formptr, info->active_index, 
              xvf_activation_chng, "1", 0);
        
            xvf_change_input(formptr, info->live_index, 
              xvf_activation_chng, "1", 0);
        
            xvf_change_input(formptr, info->optional_index, 
              xvf_title_chng, "Item is    ", 0);
        
            xvf_change_input(formptr, info->optional_index, 
              xvf_activation_chng, "1", 0);
        
            xvf_change_input(formptr, info->opt_selected_index, 
              xvf_activation_chng, "1", 0);
        
            xvf_change_input(formptr, info->gs_width_index,
              xvf_activation_chng, "1", 0);
        
            xvf_change_input(formptr, info->gs_height_index,
              xvf_activation_chng, "1", 0);
        
            xvf_change_input(formptr, info->gs_xoff_index,
              xvf_activation_chng, "1", 0);
        
            xvf_change_input(formptr, info->gs_yoff_index,
              xvf_activation_chng, "1", 0);
        
            xvf_change_input(formptr, info->ps_xoff_index,
              xvf_activation_chng, "1", 0);
        
            xvf_change_input(formptr, info->ps_yoff_index,
              xvf_activation_chng, "1", 0);

            xvf_change_input(formptr, info->toggle_range_index,
              xvf_activation_chng, "0", 0);

            xvf_change_input(formptr, info->default_float_index,
              xvf_title_chng, "Default Value", 0);

            xvf_change_input(formptr, info->default_float_index,
              xvf_activation_chng, "0", 0);

            xvf_change_input(formptr, info->lower_range_index,
              xvf_activation_chng, "0", 0);

            xvf_change_input(formptr, info->upper_range_index,
              xvf_activation_chng, "0", 0);

            xvf_change_input(formptr, info->zero_label_index,
              xvf_activation_chng, "1", 0);

            xvf_change_input(formptr, info->one_label_index,
              xvf_activation_chng, "1", 0);

            xvf_change_input(formptr, info->default_logical_index,
              xvf_activation_chng, "1", 0);
            break;

        case MutExcl :
            xvf_change_input(formptr, info->var_name_index, 
              xvf_activation_chng, "0", 0);
        
            xvf_change_input(formptr, info->name_index, 
              xvf_activation_chng, "0", 0);
        
            xvf_change_input(formptr, info->button_label_index, 
              xvf_activation_chng, "0", 0);

            xvf_change_input(formptr, info->usage_string_index, 
              xvf_activation_chng, "0", 0);

            xvf_change_input(formptr, info->default_string_index, 
              xvf_activation_chng, "0", 0);

            xvf_change_input(formptr, info->default_string_index, 
              xvf_title_chng, "not used                 ", 0);
        
            xvf_change_input(formptr, info->button_label_index, 
              xvf_title_chng, "not used          ", 0);
        
            xvf_change_input(formptr, info->active_index, 
              xvf_activation_chng, "0", 0);
        
            xvf_change_input(formptr, info->live_index, 
              xvf_activation_chng, "0", 0);
        
            xvf_change_input(formptr, info->optional_index, 
              xvf_activation_chng, "1", 0);
        
            xvf_change_input(formptr, info->optional_index, 
              xvf_title_chng, "ME Group is", 0);
        
            xvf_change_input(formptr, info->opt_selected_index, 
              xvf_activation_chng, "0", 0);
        
            xvf_change_input(formptr, info->gs_width_index,
              xvf_activation_chng, "0", 0);
        
            xvf_change_input(formptr, info->gs_height_index,
              xvf_activation_chng, "0", 0);
        
            xvf_change_input(formptr, info->gs_xoff_index,
              xvf_activation_chng, "0", 0);
        
            xvf_change_input(formptr, info->gs_yoff_index,
              xvf_activation_chng, "0", 0);
        
            xvf_change_input(formptr, info->ps_xoff_index,
              xvf_activation_chng, "0", 0);
        
            xvf_change_input(formptr, info->ps_yoff_index,
              xvf_activation_chng, "0", 0);

            xvf_change_input(formptr, info->toggle_range_index,
              xvf_activation_chng, "0", 0);

            xvf_change_input(formptr, info->default_float_index,
              xvf_title_chng, "Default Value", 0);

            xvf_change_input(formptr, info->default_float_index,
              xvf_activation_chng, "0", 0);

            xvf_change_input(formptr, info->lower_range_index,
              xvf_activation_chng, "0", 0);

            xvf_change_input(formptr, info->upper_range_index,
              xvf_activation_chng, "0", 0);

            xvf_change_input(formptr, info->zero_label_index,
              xvf_activation_chng, "0", 0);

            xvf_change_input(formptr, info->one_label_index,
              xvf_activation_chng, "0", 0);

            xvf_change_input(formptr, info->default_logical_index,
              xvf_activation_chng, "0", 0);
            break;

        case Toggle :
            xvf_change_input(formptr, info->var_name_index, 
              xvf_activation_chng, "1", 0);
        
            xvf_change_input(formptr, info->name_index, 
              xvf_activation_chng, "0", 0);
        
            xvf_change_input(formptr, info->button_label_index, 
              xvf_activation_chng, "1", 0);

            xvf_change_input(formptr, info->usage_string_index, 
              xvf_activation_chng, "1", 0);

            xvf_change_input(formptr, info->default_string_index, 
              xvf_activation_chng, "0", 0);

            xvf_change_input(formptr, info->default_string_index, 
              xvf_title_chng, "not used                 ", 0);
        
            xvf_change_input(formptr, info->button_label_index, 
              xvf_title_chng, "Toggle Label        ", 0);
        
            xvf_change_input(formptr, info->active_index, 
              xvf_activation_chng, "1", 0);
        
            xvf_change_input(formptr, info->live_index, 
              xvf_activation_chng, "1", 0);
        
            xvf_change_input(formptr, info->optional_index, 
              xvf_activation_chng, "1", 0);
        
            xvf_change_input(formptr, info->optional_index, 
              xvf_title_chng, "T  Group is", 0);
        
            xvf_change_input(formptr, info->opt_selected_index, 
              xvf_activation_chng, "1", 0);
        
            xvf_change_input(formptr, info->gs_width_index,
              xvf_activation_chng, "1", 0);
        
            xvf_change_input(formptr, info->gs_height_index,
              xvf_activation_chng, "1", 0);
        
            xvf_change_input(formptr, info->gs_xoff_index,
              xvf_activation_chng, "1", 0);
        
            xvf_change_input(formptr, info->gs_yoff_index,
              xvf_activation_chng, "1", 0);
        
            xvf_change_input(formptr, info->ps_xoff_index,
              xvf_activation_chng, "1", 0);
        
            xvf_change_input(formptr, info->ps_yoff_index,
              xvf_activation_chng, "1", 0);

            xvf_change_input(formptr, info->toggle_range_index,
              xvf_activation_chng, "0", 0);

            xvf_change_input(formptr, info->default_float_index,
              xvf_activation_chng, "0", 0);

            xvf_change_input(formptr, info->default_float_index,
              xvf_title_chng, "Default Value", 0);

            xvf_change_input(formptr, info->lower_range_index,
              xvf_activation_chng, "0", 0);

            xvf_change_input(formptr, info->upper_range_index,
              xvf_activation_chng, "0", 0);

            xvf_change_input(formptr, info->zero_label_index,
              xvf_activation_chng, "0", 0);

            xvf_change_input(formptr, info->one_label_index,
              xvf_activation_chng, "0", 0);

            xvf_change_input(formptr, info->default_logical_index,
              xvf_activation_chng, "0", 0);
            break;

        case Blank :
            xvf_change_input(formptr, info->var_name_index, 
              xvf_activation_chng, "0", 0);
        
            xvf_change_input(formptr, info->name_index, 
              xvf_activation_chng, "0", 0);
        
            xvf_change_input(formptr, info->button_label_index, 
              xvf_activation_chng, "1", 0);

            xvf_change_input(formptr, info->usage_string_index, 
              xvf_activation_chng, "0", 0);

            xvf_change_input(formptr, info->default_string_index, 
              xvf_activation_chng, "0", 0);

            xvf_change_input(formptr, info->default_string_index, 
              xvf_title_chng, "not used                 ", 0);
        
            xvf_change_input(formptr, info->button_label_index, 
              xvf_title_chng, "Comment String      ", 0);
        
            xvf_change_input(formptr, info->active_index, 
              xvf_activation_chng, "0", 0);
        
            xvf_change_input(formptr, info->live_index, 
              xvf_activation_chng, "0", 0);
        
            xvf_change_input(formptr, info->optional_index, 
              xvf_activation_chng, "0", 0);
        
            xvf_change_input(formptr, info->optional_index, 
              xvf_title_chng, "Item is   ", 0);
        
            xvf_change_input(formptr, info->opt_selected_index, 
              xvf_activation_chng, "0", 0);
        
            xvf_change_input(formptr, info->gs_width_index,
              xvf_activation_chng, "0", 0);
        
            xvf_change_input(formptr, info->gs_height_index,
              xvf_activation_chng, "0", 0);
        
            xvf_change_input(formptr, info->gs_xoff_index,
              xvf_activation_chng, "0", 0);
        
            xvf_change_input(formptr, info->gs_yoff_index,
              xvf_activation_chng, "0", 0);
        
            xvf_change_input(formptr, info->ps_xoff_index,
              xvf_activation_chng, "1", 0);
        
            xvf_change_input(formptr, info->ps_yoff_index,
              xvf_activation_chng, "1", 0);

            xvf_change_input(formptr, info->toggle_range_index,
              xvf_activation_chng, "0", 0);

            xvf_change_input(formptr, info->default_float_index,
              xvf_title_chng, "Default Value", 0);

            xvf_change_input(formptr, info->default_float_index,
              xvf_activation_chng, "0", 0);

            xvf_change_input(formptr, info->lower_range_index,
              xvf_activation_chng, "0", 0);

            xvf_change_input(formptr, info->upper_range_index,
              xvf_activation_chng, "0", 0);

            xvf_change_input(formptr, info->zero_label_index,
              xvf_activation_chng, "0", 0);

            xvf_change_input(formptr, info->one_label_index,
              xvf_activation_chng, "0", 0);

            xvf_change_input(formptr, info->default_logical_index,
              xvf_activation_chng, "0", 0);
            break;

        case StartPane :
            xvf_change_input(formptr, info->var_name_index, 
              xvf_activation_chng, "0", 0);
        
            xvf_change_input(formptr, info->name_index, 
              xvf_activation_chng, "1", 0);
        
            xvf_change_input(formptr, info->button_label_index, 
              xvf_activation_chng, "1", 0);

            xvf_change_input(formptr, info->usage_string_index, 
              xvf_activation_chng, "0", 0);

            xvf_change_input(formptr, info->default_string_index, 
              xvf_activation_chng, "0", 0);

            xvf_change_input(formptr, info->default_string_index, 
              xvf_title_chng, "not used           ", 0);
        
            xvf_change_input(formptr, info->button_label_index, 
              xvf_title_chng, "Pane Description    ", 0);
        
            xvf_change_input(formptr, info->active_index, 
              xvf_activation_chng, "1", 0);
        
            xvf_change_input(formptr, info->live_index, 
              xvf_activation_chng, "0", 0);
        
            xvf_change_input(formptr, info->optional_index, 
              xvf_activation_chng, "0", 0);
        
            xvf_change_input(formptr, info->optional_index, 
              xvf_title_chng, "Item is   ", 0);
        
            xvf_change_input(formptr, info->opt_selected_index, 
              xvf_activation_chng, "0", 0);
        
            xvf_change_input(formptr, info->gs_width_index,
              xvf_activation_chng, "1", 0);
        
            xvf_change_input(formptr, info->gs_height_index,
              xvf_activation_chng, "1", 0);
        
            xvf_change_input(formptr, info->gs_xoff_index,
              xvf_activation_chng, "1", 0);
        
            xvf_change_input(formptr, info->gs_yoff_index,
              xvf_activation_chng, "1", 0);
        
            xvf_change_input(formptr, info->ps_xoff_index,
              xvf_activation_chng, "1", 0);
        
            xvf_change_input(formptr, info->ps_yoff_index,
              xvf_activation_chng, "1", 0);

            xvf_change_input(formptr, info->toggle_range_index,
              xvf_activation_chng, "0", 0);

            xvf_change_input(formptr, info->default_float_index,
              xvf_title_chng, "Default Value", 0);

            xvf_change_input(formptr, info->default_float_index,
              xvf_activation_chng, "0", 0);

            xvf_change_input(formptr, info->lower_range_index,
              xvf_activation_chng, "0", 0);

            xvf_change_input(formptr, info->upper_range_index,
              xvf_activation_chng, "0", 0);

            xvf_change_input(formptr, info->zero_label_index,
              xvf_activation_chng, "0", 0);

            xvf_change_input(formptr, info->one_label_index,
              xvf_activation_chng, "0", 0);

            xvf_change_input(formptr, info->default_logical_index,
              xvf_activation_chng, "0", 0);
            break;

        case HelpSel :
            xvf_change_input(formptr, info->var_name_index, 
              xvf_activation_chng, "0", 0);
        
            xvf_change_input(formptr, info->name_index, 
              xvf_activation_chng, "0", 0);
        
            xvf_change_input(formptr, info->button_label_index, 
              xvf_activation_chng, "1", 0);

            xvf_change_input(formptr, info->usage_string_index, 
              xvf_activation_chng, "1", 0);

            xvf_change_input(formptr, info->default_string_index, 
              xvf_activation_chng, "1", 0);

            xvf_change_input(formptr, info->default_string_index, 
              xvf_title_chng, "Help File Name     ", 0);
        
            xvf_change_input(formptr, info->button_label_index, 
              xvf_title_chng, "Help Button Label   ", 0);
        
            xvf_change_input(formptr, info->active_index, 
              xvf_activation_chng, "1", 0);
        
            xvf_change_input(formptr, info->live_index, 
              xvf_activation_chng, "0", 0);
        
            xvf_change_input(formptr, info->optional_index, 
              xvf_activation_chng, "0", 0);
        
            xvf_change_input(formptr, info->optional_index, 
              xvf_title_chng, "Item is   ", 0);
        
            xvf_change_input(formptr, info->opt_selected_index, 
              xvf_activation_chng, "0", 0);
        
            xvf_change_input(formptr, info->gs_width_index,
              xvf_activation_chng, "1", 0);
        
            xvf_change_input(formptr, info->gs_height_index,
              xvf_activation_chng, "1", 0);
        
            xvf_change_input(formptr, info->gs_xoff_index,
              xvf_activation_chng, "1", 0);
        
            xvf_change_input(formptr, info->gs_yoff_index,
              xvf_activation_chng, "1", 0);
        
            xvf_change_input(formptr, info->ps_xoff_index,
              xvf_activation_chng, "0", 0);
        
            xvf_change_input(formptr, info->ps_yoff_index,
              xvf_activation_chng, "0", 0);

            xvf_change_input(formptr, info->toggle_range_index,
              xvf_activation_chng, "0", 0);

            xvf_change_input(formptr, info->default_float_index,
              xvf_title_chng, "Default Value", 0);

            xvf_change_input(formptr, info->default_float_index,
              xvf_activation_chng, "0", 0);

            xvf_change_input(formptr, info->lower_range_index,
              xvf_activation_chng, "0", 0);

            xvf_change_input(formptr, info->upper_range_index,
              xvf_activation_chng, "0", 0);

            xvf_change_input(formptr, info->zero_label_index,
              xvf_activation_chng, "0", 0);

            xvf_change_input(formptr, info->one_label_index,
              xvf_activation_chng, "0", 0);

            xvf_change_input(formptr, info->default_logical_index,
              xvf_activation_chng, "0", 0);
            break;

        case QuitForm :
            xvf_change_input(formptr, info->var_name_index, 
              xvf_activation_chng, "0", 0);
        
            xvf_change_input(formptr, info->name_index, 
              xvf_activation_chng, "0", 0);
        
            xvf_change_input(formptr, info->button_label_index, 
              xvf_activation_chng, "1", 0);

            xvf_change_input(formptr, info->usage_string_index, 
              xvf_activation_chng, "0", 0);

            xvf_change_input(formptr, info->default_string_index, 
              xvf_activation_chng, "0", 0);

            xvf_change_input(formptr, info->default_string_index, 
              xvf_title_chng, "not used           ", 0);
        
            xvf_change_input(formptr, info->button_label_index, 
              xvf_title_chng, "Quit Button Label   ", 0);
        
            xvf_change_input(formptr, info->active_index, 
              xvf_activation_chng, "1", 0);
        
            xvf_change_input(formptr, info->live_index, 
              xvf_activation_chng, "0", 0);
        
            xvf_change_input(formptr, info->optional_index, 
              xvf_activation_chng, "0", 0);
        
            xvf_change_input(formptr, info->optional_index, 
              xvf_title_chng, "Item is   ", 0);
        
            xvf_change_input(formptr, info->opt_selected_index, 
              xvf_activation_chng, "0", 0);
        
            xvf_change_input(formptr, info->gs_width_index,
              xvf_activation_chng, "1", 0);
        
            xvf_change_input(formptr, info->gs_height_index,
              xvf_activation_chng, "1", 0);
        
            xvf_change_input(formptr, info->gs_xoff_index,
              xvf_activation_chng, "1", 0);
        
            xvf_change_input(formptr, info->gs_yoff_index,
              xvf_activation_chng, "1", 0);
        
            xvf_change_input(formptr, info->ps_xoff_index,
              xvf_activation_chng, "0", 0);
        
            xvf_change_input(formptr, info->ps_yoff_index,
              xvf_activation_chng, "0", 0);

            xvf_change_input(formptr, info->toggle_range_index,
              xvf_activation_chng, "0", 0);

            xvf_change_input(formptr, info->default_float_index,
              xvf_title_chng, "Default Value", 0);

            xvf_change_input(formptr, info->default_float_index,
              xvf_activation_chng, "0", 0);

            xvf_change_input(formptr, info->lower_range_index,
              xvf_activation_chng, "0", 0);

            xvf_change_input(formptr, info->upper_range_index,
              xvf_activation_chng, "0", 0);

            xvf_change_input(formptr, info->zero_label_index,
              xvf_activation_chng, "0", 0);

            xvf_change_input(formptr, info->one_label_index,
              xvf_activation_chng, "0", 0);

            xvf_change_input(formptr, info->default_logical_index,
              xvf_activation_chng, "0", 0);
            break;

        case Routine :
            xvf_change_input(formptr, info->var_name_index, 
              xvf_activation_chng, "0", 0);
        
            xvf_change_input(formptr, info->name_index, 
              xvf_activation_chng, "0", 0);
        
            xvf_change_input(formptr, info->button_label_index, 
              xvf_activation_chng, "1", 0);

            xvf_change_input(formptr, info->usage_string_index, 
              xvf_activation_chng, "1", 0);

            xvf_change_input(formptr, info->default_string_index, 
              xvf_activation_chng, "1", 0);

            xvf_change_input(formptr, info->default_string_index, 
              xvf_title_chng, "Name of Executable  ", 0);
        
            xvf_change_input(formptr, info->button_label_index, 
              xvf_title_chng, "Routine Button Label", 0);
        
            xvf_change_input(formptr, info->active_index, 
              xvf_activation_chng, "1", 0);
        
            xvf_change_input(formptr, info->live_index, 
              xvf_activation_chng, "0", 0);
        
            xvf_change_input(formptr, info->optional_index, 
              xvf_activation_chng, "0", 0);
        
            xvf_change_input(formptr, info->optional_index, 
              xvf_title_chng, "Item is   ", 0);
        
            xvf_change_input(formptr, info->opt_selected_index, 
              xvf_activation_chng, "0", 0);
        
            xvf_change_input(formptr, info->gs_width_index,
              xvf_activation_chng, "1", 0);
        
            xvf_change_input(formptr, info->gs_height_index,
              xvf_activation_chng, "1", 0);
        
            xvf_change_input(formptr, info->gs_xoff_index,
              xvf_activation_chng, "1", 0);
        
            xvf_change_input(formptr, info->gs_yoff_index,
              xvf_activation_chng, "1", 0);
        
            xvf_change_input(formptr, info->ps_xoff_index,
              xvf_activation_chng, "0", 0);
        
            xvf_change_input(formptr, info->ps_yoff_index,
              xvf_activation_chng, "0", 0);

            xvf_change_input(formptr, info->toggle_range_index,
              xvf_activation_chng, "0", 0);

            xvf_change_input(formptr, info->default_float_index,
              xvf_title_chng, "Default Value", 0);

            xvf_change_input(formptr, info->default_float_index,
              xvf_activation_chng, "0", 0);

            xvf_change_input(formptr, info->lower_range_index,
              xvf_activation_chng, "0", 0);

            xvf_change_input(formptr, info->upper_range_index,
              xvf_activation_chng, "0", 0);

            xvf_change_input(formptr, info->zero_label_index,
              xvf_activation_chng, "0", 0);

            xvf_change_input(formptr, info->one_label_index,
              xvf_activation_chng, "0", 0);

            xvf_change_input(formptr, info->default_logical_index,
              xvf_activation_chng, "0", 0);
            break;

        case PaneAction :
            xvf_change_input(formptr, info->var_name_index, 
              xvf_activation_chng, "1", 0);
        
            xvf_change_input(formptr, info->name_index, 
              xvf_activation_chng, "0", 0);
        
            xvf_change_input(formptr, info->button_label_index, 
              xvf_activation_chng, "1", 0);

            xvf_change_input(formptr, info->usage_string_index, 
              xvf_activation_chng, "1", 0);

            xvf_change_input(formptr, info->default_string_index, 
              xvf_activation_chng, "0", 0);

            xvf_change_input(formptr, info->default_string_index, 
              xvf_title_chng, "not used            ", 0);
        
            xvf_change_input(formptr, info->button_label_index, 
              xvf_title_chng, "Action  Button Label", 0);
        
            xvf_change_input(formptr, info->active_index, 
              xvf_activation_chng, "1", 0);
        
            xvf_change_input(formptr, info->live_index, 
              xvf_activation_chng, "0", 0);
        
            xvf_change_input(formptr, info->optional_index, 
              xvf_activation_chng, "0", 0);
        
            xvf_change_input(formptr, info->optional_index, 
              xvf_title_chng, "Item is   ", 0);
        
            xvf_change_input(formptr, info->opt_selected_index, 
              xvf_activation_chng, "0", 0);
        
            xvf_change_input(formptr, info->gs_width_index,
              xvf_activation_chng, "1", 0);
        
            xvf_change_input(formptr, info->gs_height_index,
              xvf_activation_chng, "1", 0);
        
            xvf_change_input(formptr, info->gs_xoff_index,
              xvf_activation_chng, "1", 0);
        
            xvf_change_input(formptr, info->gs_yoff_index,
              xvf_activation_chng, "1", 0);
        
            xvf_change_input(formptr, info->ps_xoff_index,
              xvf_activation_chng, "0", 0);
        
            xvf_change_input(formptr, info->ps_yoff_index,
              xvf_activation_chng, "0", 0);

            xvf_change_input(formptr, info->toggle_range_index,
              xvf_activation_chng, "0", 0);

            xvf_change_input(formptr, info->default_float_index,
              xvf_title_chng, "Default Value", 0);

            xvf_change_input(formptr, info->default_float_index,
              xvf_activation_chng, "0", 0);

            xvf_change_input(formptr, info->lower_range_index,
              xvf_activation_chng, "0", 0);

            xvf_change_input(formptr, info->upper_range_index,
              xvf_activation_chng, "0", 0);

            xvf_change_input(formptr, info->zero_label_index,
              xvf_activation_chng, "0", 0);

            xvf_change_input(formptr, info->one_label_index,
              xvf_activation_chng, "0", 0);

            xvf_change_input(formptr, info->default_logical_index,
              xvf_activation_chng, "0", 0);
            break;

        default :
            (void) sprintf(temp, "Unknow user interface specification line type.");
            xvf_error_wait(temp, "COMPOSER WARNING!", "OK");
            break;
    }
}




/********************************************************
*
*  Routine Name:  init_pane_edit()
*       Purpose:  deactivates portions of the user intrface that are not
*                 appropriate to begin editing a new pane
*         Input:  formptr and info contain form data structure and UI tree
*		  formptr - pointer to the xvform structure
*		  info - pointer for the structure for the edit_pane.
*        Output:  the pane has user interface items deactivated
*
*     Called By:  lcomposer.c
*
********************************************************/


void
init_pane_edit(formptr, info)
xvf_form 	*formptr;
pane_edit_pane  *info;
{
        xvf_change_input(formptr, info->select_I_index, 
          xvf_activation_chng, "0", 0);
    
        xvf_change_input(formptr, info->select_O_index, 
          xvf_activation_chng, "0", 0);
    
        xvf_change_input(formptr, info->select_f_index, 
          xvf_activation_chng, "0", 0);
    
        xvf_change_input(formptr, info->select_i_index, 
          xvf_activation_chng, "0", 0);
    
        xvf_change_input(formptr, info->select_s_index, 
          xvf_activation_chng, "0", 0);
    
        xvf_change_input(formptr, info->select_l_index, 
          xvf_activation_chng, "0", 0);
    
        xvf_change_input(formptr, info->select_T_index, 
          xvf_activation_chng, "0", 0);
    
        xvf_change_input(formptr, info->select_C_index, 
          xvf_activation_chng, "0", 0);
    
        xvf_change_input(formptr, info->select_b_index, 
          xvf_activation_chng, "0", 0);
    
        xvf_change_input(formptr, info->select_a_index, 
          xvf_activation_chng, "0", 0);
    
        xvf_change_input(formptr, info->select_H_index, 
          xvf_activation_chng, "0", 0);
    
        xvf_change_input(formptr, info->select_Q_index, 
          xvf_activation_chng, "0", 0);
    
        xvf_change_input(formptr, info->select_R_index, 
          xvf_activation_chng, "0", 0);
    
        xvf_change_input(formptr, info->delete_index, 
          xvf_activation_chng, "0", 0);
    
        xvf_change_input(formptr, info->copy_index, 
          xvf_activation_chng, "0", 0);
    
        xvf_change_input(formptr, info->var_name_index, 
          xvf_activation_chng, "0", 0);
    
        xvf_change_input(formptr, info->name_index, 
          xvf_activation_chng, "0", 0);
    
        xvf_change_input(formptr, info->button_label_index, 
          xvf_activation_chng, "0", 0);

        xvf_change_input(formptr, info->usage_string_index, 
          xvf_activation_chng, "0", 0);

        xvf_change_input(formptr, info->default_string_index, 
          xvf_activation_chng, "0", 0);

        xvf_change_input(formptr, info->default_string_index, 
          xvf_title_chng, "not used           ", 0);
    
        xvf_change_input(formptr, info->button_label_index, 
          xvf_title_chng, "Pane Description    ", 0);
    
        xvf_change_input(formptr, info->active_index, 
          xvf_activation_chng, "0", 0);
    
        xvf_change_input(formptr, info->live_index, 
          xvf_activation_chng, "0", 0);
    
        xvf_change_input(formptr, info->optional_index, 
          xvf_activation_chng, "0", 0);
    
        xvf_change_input(formptr, info->optional_index, 
          xvf_title_chng, "Item is   ", 0);
    
        xvf_change_input(formptr, info->opt_selected_index, 
          xvf_activation_chng, "0", 0);
    
        xvf_change_input(formptr, info->gs_width_index,
          xvf_activation_chng, "0", 0);
    
        xvf_change_input(formptr, info->gs_height_index,
          xvf_activation_chng, "0", 0);
    
        xvf_change_input(formptr, info->gs_xoff_index,
          xvf_activation_chng, "0", 0);
    
        xvf_change_input(formptr, info->gs_yoff_index,
          xvf_activation_chng, "0", 0);
    
        xvf_change_input(formptr, info->ps_xoff_index,
          xvf_activation_chng, "0", 0);
    
        xvf_change_input(formptr, info->ps_yoff_index,
          xvf_activation_chng, "0", 0);

        xvf_change_input(formptr, info->toggle_range_index,
          xvf_activation_chng, "0", 0);

        xvf_change_input(formptr, info->default_float_index,
          xvf_title_chng, "Default Value", 0);

        xvf_change_input(formptr, info->default_float_index,
          xvf_activation_chng, "0", 0);

        xvf_change_input(formptr, info->lower_range_index,
          xvf_activation_chng, "0", 0);

        xvf_change_input(formptr, info->upper_range_index,
          xvf_activation_chng, "0", 0);

        xvf_change_input(formptr, info->zero_label_index,
          xvf_activation_chng, "0", 0);

        xvf_change_input(formptr, info->one_label_index,
          xvf_activation_chng, "0", 0);

        xvf_change_input(formptr, info->default_logical_index,
          xvf_activation_chng, "0", 0);
}

/********************************************************
*
*  Routine Name:  ok_pane_edit()
*       Purpose:  activates portions of the user intrface that are
*                 appropriate to begin editing a new pane
*         Input:  formptr and info contain form data structure and UI tree
*		  formptr - pointer to the xvform structure
*		  info - pointer for the structure for the edit_pane.
*        Output:  the pane has user interface items activated
*
*     Called By:  run.c
*
********************************************************/


void
ok_pane_edit(formptr, info)
xvf_form 	*formptr;
pane_edit_pane  *info;
{
        xvf_change_input(formptr, info->select_I_index, 
          xvf_activation_chng, "1", 0);
    
        xvf_change_input(formptr, info->select_O_index, 
          xvf_activation_chng, "1", 0);
    
        xvf_change_input(formptr, info->select_f_index, 
          xvf_activation_chng, "1", 0);
    
        xvf_change_input(formptr, info->select_i_index, 
          xvf_activation_chng, "1", 0);
    
        xvf_change_input(formptr, info->select_s_index, 
          xvf_activation_chng, "1", 0);
    
        xvf_change_input(formptr, info->select_l_index, 
          xvf_activation_chng, "1", 0);
    
        xvf_change_input(formptr, info->select_T_index, 
          xvf_activation_chng, "1", 0);
    
        xvf_change_input(formptr, info->select_C_index, 
          xvf_activation_chng, "1", 0);
    
        xvf_change_input(formptr, info->select_b_index, 
          xvf_activation_chng, "1", 0);
    
        xvf_change_input(formptr, info->select_a_index, 
          xvf_activation_chng, "1", 0);
    
        xvf_change_input(formptr, info->select_H_index, 
          xvf_activation_chng, "1", 0);
    
        xvf_change_input(formptr, info->select_Q_index, 
          xvf_activation_chng, "1", 0);
    
        xvf_change_input(formptr, info->select_R_index, 
          xvf_activation_chng, "1", 0);
    
        xvf_change_input(formptr, info->delete_index, 
          xvf_activation_chng, "1", 0);
    
        xvf_change_input(formptr, info->copy_index, 
          xvf_activation_chng, "1", 0);

        xvf_change_input(formptr, info->name_index, 
          xvf_activation_chng, "1", 0);
    
        xvf_change_input(formptr, info->button_label_index, 
          xvf_activation_chng, "1", 0);

        xvf_change_input(formptr, info->default_string_index, 
          xvf_title_chng, "not used           ", 0);
    
        xvf_change_input(formptr, info->button_label_index, 
          xvf_title_chng, "Pane Description    ", 0);
    
        xvf_change_input(formptr, info->active_index, 
          xvf_activation_chng, "1", 0);
    
        xvf_change_input(formptr, info->gs_width_index,
          xvf_activation_chng, "1", 0);
    
        xvf_change_input(formptr, info->gs_height_index,
          xvf_activation_chng, "1", 0);
    
        xvf_change_input(formptr, info->gs_xoff_index,
          xvf_activation_chng, "1", 0);
    
        xvf_change_input(formptr, info->gs_yoff_index,
          xvf_activation_chng, "1", 0);
    
        xvf_change_input(formptr, info->ps_xoff_index,
          xvf_activation_chng, "1", 0);
    
        xvf_change_input(formptr, info->ps_yoff_index,
          xvf_activation_chng, "1", 0);
}
