 /*
  * Khoros: $Id: scale_2D.c,v 1.1 1991/05/10 15:56:56 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: scale_2D.c,v 1.1 1991/05/10 15:56:56 khoros Exp $";
#endif

 /*
  * $Log: scale_2D.c,v $
 * Revision 1.1  1991/05/10  15:56:56  khoros
 * Initial revision
 *
  */ 


/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.
 *
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */
#include "X3D.h"


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>	    file name: scale_2D.c
   >>>>               
   >>>>   description: Scale Utilities
   >>>>              
   >>>>      routines:
   >>>>			_X2D_scale_wc_coords                  <<<<
   >>>>			_X2D_scale_wc_coord                   <<<<
   >>>>              
   >>>> modifications:
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */

/************************************************************
*
*  MODULE NAME: _X2D_scale_wc_coords
*
*      PURPOSE: Converts a 3D world coordinate to the scale
*               type desired
*
*        INPUT: 
*
*       OUTPUT: 
*
*    CALLED BY: application program
*
*   WRITTEN BY: Mark Young & Mike Lang
*
*
*************************************************************/


int _X2D_scale_wc_coords(scale, coords, scoords, size)

Coord	scale, *coords, **scoords;
int	size;
{
	int	i;
	Coord	*temp;

	if (scale.x == LINEAR && scale.y == LINEAR)
	{
	   *scoords = coords;
	   return(TRUE);
	}

	if (!(temp = (Coord *) malloc((unsigned) sizeof(Coord) * size)))
	{
	   *scoords = coords;
	   return(FALSE);
	}

	if (setjmp(jump_dest) == 0)
	/* enable graphics signal handler */
	{
#ifndef mc68000
	   (void) signal(SIGFPE, X3D_signal_handler);
#endif
	   (void) signal(SIGILL, X3D_signal_handler);

	   for (i = 0; i < size; i++)
	   {
	      temp[i].x = X3D_get_scale_value((int) scale.x, coords[i].x);
	      temp[i].y = X3D_get_scale_value((int) scale.y, coords[i].y);
	   }

	   /* to clean up & turn off graphics signal handler */
	   (void) signal(SIGFPE, SIG_IGN);
	   (void) signal(SIGILL, SIG_IGN);
	   *scoords = temp;
	   return(TRUE);
	}
	else
	{
	   free(temp);
	   return(FALSE);
	}
}



/************************************************************
*
*  MODULE NAME: _X2D_scale_wc_coord
*
*      PURPOSE: Converts a 3D world coordinate to the scale
*               type desired
*
*        INPUT: 
*
*       OUTPUT: 
*
*    CALLED BY: application program
*
*   WRITTEN BY: Mark Young & Mike Lang
*
*************************************************************/

int	_X2D_scale_wc_coord(scale, coord, scoord)

Coord	scale, coord, *scoord;
{
	Coord	temp;

	if (setjmp(jump_dest) == 0)
	/* enable graphics signal handler */
	{
#ifndef mc68000
	   (void) signal(SIGFPE, X3D_signal_handler);
#endif
	   (void) signal(SIGILL, X3D_signal_handler);

	   temp.x = X3D_get_scale_value((int) scale.x, coord.x);
	   temp.y = X3D_get_scale_value((int) scale.y, coord.y);

	   /* to clean up & turn off graphics signal handler */
	   (void) signal(SIGFPE, SIG_IGN);
	   (void) signal(SIGILL, SIG_IGN);

	   *scoord = temp;
	   return(TRUE);
	}
	else
	   return(FALSE);
}
