 /*
  * Khoros: $Id: inquire_3D.c,v 1.1 1991/05/10 15:56:56 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: inquire_3D.c,v 1.1 1991/05/10 15:56:56 khoros Exp $";
#endif

 /*
  * $Log: inquire_3D.c,v $
 * Revision 1.1  1991/05/10  15:56:56  khoros
 * Initial revision
 *
  */ 


/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.
 * 
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *----------------------------------------------------------------------
 */

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */
#include 	"X3D.h"


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>             file name: inquire_3D.c                   <<<<
   >>>>                                                       <<<<
   >>>>                3D Inquiry Utilities 		      <<<<
   >>>>                                                       <<<<
   >>>>  	       X3D_inquire_projection()               <<<<
   >>>>  	       X3D_inquire_viewpoint()                <<<<
   >>>>  	       X3D_inquire_view_distance()            <<<<
   >>>>  	       X3D_inquire_window()                   <<<<
   >>>>  	       X3D_inquire_viewport()                 <<<<
   >>>>  	       X3D_inquire_wc_min_max()               <<<<
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */
 

/************************************************************
*
*  MODULE NAME: X3D_inquire_projection
*
*      PURPOSE: Inquire the 3D projection type for a given X3D 
*		graphics id
*
*        INPUT: 1) id           - X3D graphics structure ID
*               2) projection   - Type of projection:
*					Perspective     1
*					Orthographic    2
*					Cavalier        3
*					Cabinet         4
*					
*
*       OUTPUT: none
*
*    CALLED BY: application program
*
*   WRITTEN BY: Mark Young
*
*
*************************************************************/

X3D_inquire_projection (id, projection)

int     id, *projection;
{
        X3DGraphics *graphics;

        if (!(graphics = _X3D_get_graphics(id)))
        {
           (void) fprintf (stderr,"X3D_inquire_projection:");
	   (void) fprintf (stderr,"\t unknown graphics id %d\n",id);
           return;
        }

	*projection = graphics->projection;
}



/************************************************************
*
*  MODULE NAME: X3D_inquire_viewpoint
*
*      PURPOSE: Inquire the eye orientation for a given X3D graphics
*		structure.
*
*        INPUT: id        - X3D graphics structure ID
*		alpha     - the angle describing the position of the
*			    eye between the Z axis and the XY plane
*		theta     - Angle describing the position of the eye
*			    around Z axis with respect to the XY plane
*		eye_dist  - Distance of the eye from the object
*
*       OUTPUT: none
*
*    CALLED BY: application program
*
*   WRITTEN BY: Mark Young
*
*
************************************************************/

X3D_inquire_viewpoint (id, alpha, theta, eye_distance)

int	id;
Real	*alpha, *theta, *eye_distance;
{
	X3DGraphics *graphics;

	if (!(graphics = _X3D_get_graphics(id)))
	{
	   (void) fprintf (stderr,"X3D_inquire_viewpoint:");
	   (void) fprintf (stderr,"\t unknown graphics id %d\n",id);
	   return;
	}
	*alpha = graphics->alpha;
	*theta = graphics->theta;
	*eye_distance = graphics->eye_dist;
}



/************************************************************
*
*  MODULE NAME: X3D_inquire_view_distance
*
*      PURPOSE: Inquire the eye orientation for a given X3D graphics
*               structure.
*
*        INPUT: id        - X3D graphics structure ID
*               view_dist - Distance of the eye from the viewport
*
*       OUTPUT: none
*
*    CALLED BY: application program
*
*   WRITTEN BY: Mark Young
*
*
************************************************************/

X3D_inquire_view_distance (id, view_distance)

int     id;
Real    *view_distance;
{
        X3DGraphics *graphics;

        if (!(graphics = _X3D_get_graphics(id)))
        {
           (void) fprintf (stderr,"X3D_inquire_view_distance:");
           (void) fprintf (stderr,"\t unknown graphics id %d\n",id);
           return;
        }
        *view_distance = graphics->view_dist;
}



/************************************************************
*
*  MODULE NAME: X3D_inquire_window
*
*      PURPOSE: Inquires the minimum and maximum device coordinate
*		for a given X11 Window.
*
*        INPUT: id        - X3D graphics structure ID
*		x, y,
*		width,
*		height	  - the offset and size of the window (in device
*			    coordinates).
*
*       OUTPUT: none
*
*    CALLED BY: application program
*
*   WRITTEN BY: Mark Young
*
*
************************************************************/

X3D_inquire_window (id, x, y, width, height)

int	id;
short	*x, *y, *width, *height;
{
	X3DGraphics 	*graphics;


	if (!(graphics = _X3D_get_graphics(id)))
	{
	   (void) fprintf (stderr,"X3D_inquire_window:");
	   (void) fprintf (stderr,"\t unknown graphics id %d\n",id);
	   return;
	}

	if (graphics->device == X11)
	{
	   *x = graphics->X11_xmin;
	   *y = graphics->X11_ymin;
	   *width  = graphics->X11_xmax - *x;
	   *height = graphics->X11_ymax - *y;
	}
	else if (graphics->device == POSTSCR)
	{
	   *x = graphics->POS_xmin;
	   *y = graphics->POS_ymin;
	   *width  = graphics->POS_xmax - *x;
	   *height = graphics->POS_ymax - *y;
	}
	else if (graphics->device == IMPRESS)
	{
	   *x = graphics->IMP_xmin;
	   *y = graphics->IMP_ymin;
	   *width  = graphics->IMP_xmax - *x;
	   *height = graphics->IMP_ymax - *y;
	}
	else if (graphics->device == HPGL)
	{
	   *x = graphics->HPGL_xmin;
	   *y = graphics->HPGL_ymin;
	   *width  = graphics->HPGL_xmax - *x;
	   *height = graphics->HPGL_ymax - *y;
	}
}




/************************************************************
*
*  MODULE NAME: X3D_inquire_viewport
*
*      PURPOSE: Inquires the minimum and maximum viewport values
*		for a given X3D graphics structure.
*
*        INPUT: id     - X3D graphics structure ID
*		xmin   - A Real containing the x minimum viewport 
*			 normalized device coordinate value.
*		xmax   - A Real containing the x maximum world 
*			 normalized device coordinate value.
*		ymin   - A Real containing the y minimum viewport 
*			 normalized device coordinate value.
*		ymax   - A Real containing the y maximum world 
*			 normalized device coordinate value.
*		zmin   - A Real containing the z minimum viewport 
*			 normalized device coordinate value.
*		zmax   - A Real containing the z maximum world 
*			 normalized device coordinate value.
*
*       OUTPUT: none
*
*    CALLED BY: application program
*
*   WRITTEN BY: Mark Young
*
*
************************************************************/

X3D_inquire_viewport (id, xmin, xmax, ymin, ymax, zmin, zmax)

int	id;
Real	*xmin, *xmax, *ymin, *ymax, *zmin, *zmax;
{
	X3DGraphics *graphics;

	if (!(graphics = _X3D_get_graphics(id)))
	{
	   (void) fprintf (stderr,"X3D_inquire_viewport:");
	   (void) fprintf (stderr,"\t unknown graphics id %d\n",id);
	   return;
	}
	*xmin = graphics->xv_min;
	*xmax = graphics->xv_max;
	*ymin = graphics->yv_min;
	*ymax = graphics->yv_max;
	*zmin = graphics->zv_min;
	*zmax = graphics->zv_max;
}



/************************************************************
*
*  MODULE NAME: X3D_inquire_wc_min_max
*
*      PURPOSE: Inquires the minimum and maximum world coordinate
*		points for a given X3D graphics structure.
*
*        INPUT: id     - X3D graphics structure ID
*		wc_min - A coord containing the minimum world 
*			 coordinate values
*		wc_max - A coord containing the maximum world 
*			 coordinate values
*
*       OUTPUT: none
*
*    CALLED BY: application program
*
*   WRITTEN BY: Mark Young
*
*
*************************************************************/

X3D_inquire_wc_min_max (id, wc_min, wc_max)

int	id;
Coord	*wc_min, *wc_max;
{
	X3DGraphics *graphics;

	if (!(graphics = _X3D_get_graphics(id)))
	{
	   (void) fprintf (stderr,"X3D_inquire_wc_min_max:");
	   (void) fprintf (stderr,"\t unknown graphics id %d\n",id);
	   return;
	}

	*wc_min = graphics->wc_min;
	*wc_max = graphics->wc_max;
}
