 /*
  * Khoros: $Id: vextcent.c,v 1.2 1991/12/18 09:35:19 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: vextcent.c,v 1.2 1991/12/18 09:35:19 dkhoros Exp $";
#endif

 /*
  * $Log: vextcent.c,v $
 * Revision 1.2  1991/12/18  09:35:19  dkhoros
 * HellPatch3
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vextcent.c
 >>>>
 >>>>      Program Name: vextcent
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Extract a rectangular image from  the  center  of  a  larger
 >>>>	image.
 >>>>	
 >>>>	

 >>>>            Author: John Rasure, Richard Krukar
 >>>>
 >>>> Date Last Updated: Sat Dec 14 18:18:40 1991
 >>>>
 >>>>          Routines: main- the main program for vextcent
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vextcent.h"


/****************************************************************
 *
 * Routine Name:  main program for vextcent
 *
 *       Input:  
 *          -i  input image 
 *          -o  resulting output image 
 *
 *
 *          [-w] specifies the subimage width in pixels  (value > 0)
 *          [-h] specifies the subimage height in pixels  (value > 0)
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
struct xvimage  *img1,*img2,  *readimage();
float xoff, yoff;
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
if (check_args()) exit(1);

img1 = readimage(vextcent->i_file);
if (img1 == NULL) exit(1);    /* Quit if bad image */

CHECKINPUT(program,img1);   /* Verify input image */

/*  calculate the offset so that the extracted subimage comes from
    the center of the image */
xoff = (img1->row_size/2.0)-(vextcent->w_int/2.0);
yoff = (img1->col_size/2.0)-(vextcent->h_int/2.0);
/* -main_before_lib_call_end */

/* -main_library_call */
if(! lvextract(img1, &img2, vextcent->w_int, vextcent->h_int, (int) xoff, (int) yoff,TRUE))
 {
   (void) fprintf(stderr, "lvextract Failed\n");
   exit(1);
 }
/* -main_library_call_end */

/* -main_after_lib_call */
writeimage(vextcent->o_file,img2);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for vextcent 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "vextcent :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tExtract a rectangular image from  the  center  of  a  larger\n");
	fprintf(stderr, "\timage.\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i  input image  (infile)\n");
	fprintf(stderr,"\t-o  resulting output image  (outfile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-w]  specifies the subimage width in pixels (integer, > 0) [128]\n");
	fprintf(stderr,"\t[-h]  specifies the subimage height in pixels (integer, > 0) [128]\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for vextcent\n");
	fprintf(stderr, "\t[-U] Gives the usage for vextcent\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called vextcent.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses vextcent.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for vextcent
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i_pstr = 
	"\nEnter: (i) input image \n        {infile}: "; 
char	*o_pstr = 
	"\nEnter: (o) resulting output image \n        {outfile}: "; 
char	*w_pstr = 
	"\nEnter: (w) specifies the subimage width in pixels \n        {integer, > 0 [128] }: "; 
char	*h_pstr = 
	"\nEnter: (h) specifies the subimage height in pixels \n        {integer, > 0 [128] }: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "vextcent", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "vextcent.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "vextcent: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "vextcent.ans");
		}

	     }

	}

	/*
	 * allocate the vextcent structure
	 */
	vextcent = (vextcent_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (vextcent_struct));

	/*
	 * get required arguments for vextcent
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(vextcent->i_flag = vget_infile(fid, prompt_flag,
			"-i", i_pstr, &(vextcent->i_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vextcent->i_flag))
		{
		    fprintf(stderr, "\t\ti is required, please re-enter: \n");
		    vextcent->i_flag = vget_infile(fid, prompt_flag,
		    "-i", i_pstr, &(vextcent->i_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vextcent->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(vextcent->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vextcent->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    vextcent->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(vextcent->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for vextcent
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	vextcent->w_flag = vget_int(fid, prompt_flag,
	"-w", w_pstr, &(vextcent->w_int),
	128, 2, 2);

	vextcent->h_flag = vget_int(fid, prompt_flag,
	"-h", h_pstr, &(vextcent->h_int),
	128, 2, 2);


}



