 /*
  * Khoros: $Id: vlaser.c,v 1.1 1991/05/10 15:50:49 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: vlaser.c,v 1.1 1991/05/10 15:50:49 khoros Exp $";
#endif

 /*
  * $Log: vlaser.c,v $
 * Revision 1.1  1991/05/10  15:50:49  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vlaser.c
 >>>>
 >>>>      Program Name: vlaser
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Format a Khoros image in Impress for output  to  the  IMAGEN
 >>>>	8/300
 >>>>	
 >>>>	
 >>>>            Author: Scott Wilson, Mark Young
 >>>>
 >>>> Date Last Updated: Thu Mar 28 00:09:46 1991
 >>>>
 >>>>          Routines: main- the main program for vlaser
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vlaser.h"


/****************************************************************
 *
 * Routine Name:  main program for vlaser
 *
 *       Input:  
 *        -i  input image filename 
 *
 *
 *        [-m] mag factor = 2**(specifed mag amount)  (0 < value < 4)
 *        [-x] x offset in inches from upper left corner  (0.000 < value < 8.000)
 *        [-y] y offset in inches from upper left corner  (0.000 < value < 10.000)
 *        [-p] Photonegative output
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
        struct xvimage *image, *readimage();
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
        if (check_args()) exit(1);
        image = readimage(vlaser->i_file);
        if (image == NULL) exit(1);
        CHECKINPUT(program,image);
/* -main_before_lib_call_end */

/* -main_library_call */
        if(!lvlaser(stdout,image,
                    vlaser->m_int,
                    vlaser->x_float,
                    vlaser->y_float,
                    vlaser->p_logic,
                    FALSE))
          {
            (void) fprintf(stderr, "lvlaser Failed\n");
            exit(1);
          }
/* -main_library_call_end */

/* -main_after_lib_call */
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for vlaser 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "vlaser :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tFormat a Khoros image in Impress for output  to  the  IMAGEN\n");
	fprintf(stderr, "\t8/300\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i  input image filename  (infile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-m]  mag factor = 2**(specifed mag amount) (integer, 0 to 4) [2]\n");
	fprintf(stderr,"\t[-x]  x offset in inches from upper left corner (float,  0.000 to 8.000) [0]\n");
	fprintf(stderr,"\t[-y]  y offset in inches from upper left corner (float,  0.000 to 10.000) [0]\n");
	fprintf(stderr,"\t[-p]  Photonegative output (boolean) [false]\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for vlaser\n");
	fprintf(stderr, "\t[-U] Gives the usage for vlaser\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called vlaser.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses vlaser.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for vlaser
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i_pstr = 
	"\nEnter: (i) input image filename \n        {infile}: "; 
char	*m_pstr = 
	"\nEnter: (m) mag factor = 2**(specifed mag amount) \n        {integer, 0 to 4 [2] }: "; 
char	*x_pstr = 
	"\nEnter: (x) x offset in inches from upper left corner \n        {float,  0.000 to 8.000 [0.000000] }: "; 
char	*y_pstr = 
	"\nEnter: (y) y offset in inches from upper left corner \n        {float,  0.000 to 10.000 [0.000000] }: "; 
char	*p_pstr = 
	"\nEnter: (p) Photonegative output \n        {boolean, (y/n)  [no] }: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "vlaser", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "vlaser.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "vlaser: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "vlaser.ans");
		}

	     }

	}

	/*
	 * allocate the vlaser structure
	 */
	vlaser = (vlaser_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (vlaser_struct));

	/*
	 * get required arguments for vlaser
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(vlaser->i_flag = vget_infile(fid, prompt_flag,
			"-i", i_pstr, &(vlaser->i_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vlaser->i_flag))
		{
		    fprintf(stderr, "\t\ti is required, please re-enter: \n");
		    vlaser->i_flag = vget_infile(fid, prompt_flag,
		    "-i", i_pstr, &(vlaser->i_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for vlaser
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	vlaser->m_flag = vget_int(fid, prompt_flag,
	"-m", m_pstr, &(vlaser->m_int),
	2, 0, 4);

	vlaser->x_flag = vget_float(fid, prompt_flag,
	"-x", x_pstr, &(vlaser->x_float),
	0.000000, 0.000000, 8.000000);

	vlaser->y_flag = vget_float(fid, prompt_flag,
	"-y", y_pstr, &(vlaser->y_float),
	0.000000, 0.000000, 10.000000);

	vlaser->p_flag = vget_logic(fid, prompt_flag,
	"-p", p_pstr, &(vlaser->p_logic), 0);


}



