 /*
  * Khoros: $Id: vgbox.h,v 1.4 1991/12/18 09:39:22 dkhoros Exp $
  */

 /*
  * $Log: vgbox.h,v $
 * Revision 1.4  1991/12/18  09:39:22  dkhoros
 * HellPatch3
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */


/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vgbox.h
 >>>>            Author: Jean-Pierre GUERIN  (CEA)
 >>>> Date Last Updated: Sat Dec 14 18:01:59 1991
 >>>> 
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/

#ifndef _vgbox_h_
#define _vgbox_h_

#include "vinclude.h"


/* -include_includes */
/* -include_includes_end */

char	**av,		/* argv and argc used by gparams */
	*program;	/* a pointer to the program name argv[0] */
int	ac;

/****************************************************************
*
*                    vgbox Argument Structure
*
****************************************************************/

typedef struct _vgbox  {

/*
 *  resulting output image (Required outfile)
 */
char	*o_file;	/* resulting output image FILENAME */
int	 o_flag;	/* resulting output image FLAG */

/*
 *  trigger input (Optional infile)
 */
char	*trigger_file;	/* trigger input FILENAME */
int	 trigger_flag;	/* trigger input FLAG */

/*
 *  Number of Rows    (Height in pixels) of the CCD sensor (Optional integer)
 */
int	 r_int; 	/* Number of Rows    (Height in pixels) of the CCD sensor INT */
int	 r_flag;	/* Number of Rows    (Height in pixels) of the CCD sensor FLAG */

/*
 *  Number of Columns (Width  in pixels) of the CCD sensor (Optional integer)
 */
int	 c_int; 	/* Number of Columns (Width  in pixels) of the CCD sensor INT */
int	 c_flag;	/* Number of Columns (Width  in pixels) of the CCD sensor FLAG */

/*
 *  Active Pixel Height (vertical)   (Optional float)
 */
float	 px_h_float;	/* Active Pixel Height (vertical)   FLOAT */
int	 px_h_flag;   	/* Active Pixel Height (vertical)   FLAG */

/*
 *  Active Pixel Width (horizontal)  (Optional float)
 */
float	 px_w_float;	/* Active Pixel Width (horizontal)  FLOAT */
int	 px_w_flag;   	/* Active Pixel Width (horizontal)  FLAG */

/*
 *  Active Pixel offset from the top  of the cell (Optional float)
 */
float	 px_y_off_float;	/* Active Pixel offset from the top  of the cell FLOAT */
int	 px_y_off_flag;   	/* Active Pixel offset from the top  of the cell FLAG */

/*
 *  Active Pixel offset from the left of the cell (Optional float)
 */
float	 px_x_off_float;	/* Active Pixel offset from the left of the cell FLOAT */
int	 px_x_off_flag;   	/* Active Pixel offset from the left of the cell FLAG */

/*
 *  Height of the parallelogram (box) (in pixel unit) (Optional float)
 */
float	 h_float;	/* Height of the parallelogram (box) (in pixel unit) FLOAT */
int	 h_flag;   	/* Height of the parallelogram (box) (in pixel unit) FLAG */

/*
 *  Width  of the parallelogram (box) (in pixel unit) (Optional float)
 */
float	 w_float;	/* Width  of the parallelogram (box) (in pixel unit) FLOAT */
int	 w_flag;   	/* Width  of the parallelogram (box) (in pixel unit) FLAG */

/*
 *  Downward offset of the box (0 is CCD center = box center) (Optional float)
 */
float	 im_y_off_float;	/* Downward offset of the box (0 is CCD center = box center) FLOAT */
int	 im_y_off_flag;   	/* Downward offset of the box (0 is CCD center = box center) FLAG */

/*
 *  Right    offset of the box (0 is CCD center = box center) (Optional float)
 */
float	 im_x_off_float;	/* Right    offset of the box (0 is CCD center = box center) FLOAT */
int	 im_x_off_flag;   	/* Right    offset of the box (0 is CCD center = box center) FLAG */

/*
 *  Box rotation (clockwise, degrees) (center = box center) (Optional float)
 */
float	 angle_float;	/* Box rotation (clockwise, degrees) (center = box center) FLOAT */
int	 angle_flag;   	/* Box rotation (clockwise, degrees) (center = box center) FLAG */

/*
 *  the value of the 1st corner angle (degrees) (Optional float)
 */
float	 corner_angl_float;	/* the value of the 1st corner angle (degrees) FLOAT */
int	 corner_angl_flag;   	/* the value of the 1st corner angle (degrees) FLAG */

/*
 *  Grey level of the background pixels outside of the box (Optional integer)
 */
int	 g_o_int; 	/* Grey level of the background pixels outside of the box INT */
int	 g_o_flag;	/* Grey level of the background pixels outside of the box FLAG */

/*
 *  Grey level of the lighted pixels inside the box (Optional integer)
 */
int	 g_i_int; 	/* Grey level of the lighted pixels inside the box INT */
int	 g_i_flag;	/* Grey level of the lighted pixels inside the box FLAG */

}  vgbox_struct;

vgbox_struct *vgbox;

/* -include_additions */
/* -include_additions_end */

/* -include_macros */
#define PI     XV_PI       /*  3.14159265358979323846 */
#define PI_2   XV_PI_2     /*  PI/2                   */
/* -include_macros_end */

#endif
