 /*
  * Khoros: $Id: vgamut.h,v 1.2 1991/10/02 00:26:45 khoros Exp $
  */

 /*
  * $Log: vgamut.h,v $
 * Revision 1.2  1991/10/02  00:26:45  khoros
 * HellPatch2
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */


/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vgamut.h
 >>>>            Author: Scott Wilson
 >>>> Date Last Updated: Sat Aug 24 21:24:06 1991
 >>>> 
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/

#ifndef _vgamut_h_
#define _vgamut_h_

#include "vinclude.h"


/* -include_includes */
/* -include_includes_end */

char	**av,		/* argv and argc used by gparams */
	*program,	/* a pointer to the program name argv[0] */
	*calloc();
int	ac;

/****************************************************************
*
*                    vgamut Argument Structure
*
****************************************************************/

typedef struct _vgamut  {

/*
 *  input image filename (Required infile)
 */
char	*i_file;	/* input image filename FILENAME */
int	 i_flag;	/* input image filename FLAG */

/*
 *  output image filename (Required outfile)
 */
char	*o_file;	/* output image filename FILENAME */
int	 o_flag;	/* output image filename FLAG */

/*
 *  specifies the number of colors to compress to (Optional integer)
 */
int	 n_int; 	/* specifies the number of colors to compress to INT */
int	 n_flag;	/* specifies the number of colors to compress to FLAG */

/*
 *  grey levels are truncated to this number of bits (Optional integer)
 */
int	 p_int; 	/* grey levels are truncated to this number of bits INT */
int	 p_flag;	/* grey levels are truncated to this number of bits FLAG */

/*
 *  fraction of color splits based on color subspace 2-norm (Optional float)
 */
float	 r_float;	/* fraction of color splits based on color subspace 2-norm FLOAT */
int	 r_flag;   	/* fraction of color splits based on color subspace 2-norm FLAG */

}  vgamut_struct;

vgamut_struct *vgamut;

/* -include_additions */
/* -include_additions_end */

/* -include_macros */
#define CHECKINPUT(program, img) \
        (void) propertype(program,img,VFF_TYP_1_BYTE,TRUE); \
        (void) proper_num_images(program,img,1,TRUE); \
        (void) proper_num_bands(program,img,3, TRUE); \
        (void) proper_map_enable(program,img,VFF_MAP_OPTIONAL,TRUE)
/* -include_macros_end */

#endif
