 /*
  * Khoros: $Id: vcmtrans.h,v 1.1 1991/05/10 15:46:31 khoros Exp $
  */

 /*
  * $Log: vcmtrans.h,v $
 * Revision 1.1  1991/05/10  15:46:31  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */


/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vcmtrans.h
 >>>>            Author: Tom Sauer
 >>>> Date Last Updated: Tue Mar  5 22:21:57 1991
 >>>> 
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/

#ifndef _vcmtrans_h_
#define _vcmtrans_h_

#include "vinclude.h"


/* -include_includes */
/* -include_includes_end */

char	**av,		/* argv and argc used by gparams */
	*program,	/* a pointer to the program name argv[0] */
	*calloc();
int	ac;

/****************************************************************
*
*                    vcmtrans Argument Structure
*
****************************************************************/

typedef struct _vcmtrans  {

/*
 *  input image (Required infile)
 */
char	*i1_file;	/* input image FILENAME */
int	 i1_flag;	/* input image FLAG */

/*
 *  input conversion image (Required infile)
 */
char	*i2_file;	/* input conversion image FILENAME */
int	 i2_flag;	/* input conversion image FLAG */

/*
 *  output resulting image (Required outfile)
 */
char	*o_file;	/* output resulting image FILENAME */
int	 o_flag;	/* output resulting image FLAG */

/*
 *  specifies normalization factor (default = 255) (Optional float)
 */
float	 n_float;	/* specifies normalization factor (default = 255) FLOAT */
int	 n_flag;   	/* specifies normalization factor (default = 255) FLAG */

}  vcmtrans_struct;

vcmtrans_struct *vcmtrans;

/* -include_additions */
/* -include_additions_end */

/* -include_macros */
#define READINPUT(image) \
image = readimage(vcmtrans->i1_file); \
   if(image == NULL){ \
      (void) fprintf(stderr,"vcmtrans: Image could not be read\n"); \
      exit(1); \
   }

#define READINPUT1(image1) \
image1 = readimage(vcmtrans->i2_file); \
if(image1 == NULL){ \
    (void) fprintf(stderr,"vcmtrans: Image could not be read\n"); \
    exit(1); \
}
#define CHECKINPUT(program, image) \
   (void) proper_num_images(program,image,1,TRUE); \
   \
   (void) proper_num_bands(program,image,3,TRUE); \
   \
   (void) proper_map_enable(program,image,VFF_MAP_OPTIONAL,TRUE); \
   \
   (void) propertype(program, image, VFF_TYP_FLOAT, TRUE)

#define CHECKMATRIXINPUT(program, image1) \
   (void) proper_num_images(program,image1,1,TRUE); \
   \
   (void) proper_num_bands(program,image1,1,TRUE); \
   \
   (void) proper_map_enable(program,image1,VFF_MAP_OPTIONAL,TRUE); \
   \
   (void) propertype(program, image1, VFF_TYP_FLOAT, TRUE); \
   \
   (void) propersize(program, image1, 3, 3, TRUE); \
   \
   (void) propersize(program, image1, 3, 3, TRUE)

/* -include_macros_end */

#endif
