 /*
  * Khoros: $Id: vwmdd.c,v 1.1 1991/05/10 15:46:20 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: vwmdd.c,v 1.1 1991/05/10 15:46:20 khoros Exp $";
#endif

 /*
  * $Log: vwmdd.c,v $
 * Revision 1.1  1991/05/10  15:46:20  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vwmdd.c
 >>>>
 >>>>      Program Name: vwmdd
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Weighted minimum distance detector
 >>>>	
 >>>>	
 >>>>            Author: Tom Sauer
 >>>>
 >>>> Date Last Updated: Tue Apr  9 08:36:56 1991
 >>>>
 >>>>          Routines: main- the main program for vwmdd
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vwmdd.h"


/****************************************************************
 *
 * Routine Name:  main program for vwmdd
 *
 *       Input:  
 *       -i1  Input Image 
 *       -i2  Input Center/Class Image 
 *       -i3  Input Variance Image 
 *       -o  output image specifying which vector belongs to what cluster 
 *
 *
 *       [-k]  specifies the scaling factor (default = 1)  (value > 0.0)
 *       [-b]  specifies the border width in pixels (default = 0)  (0 < value < 100)
 *       [-s] Use Summed Method
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
        struct xvimage *image, *center, *varimg, 
                       *readimage(), *images[3];
        
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
        if (check_args()) exit(1);
/* -main_before_lib_call_end */

/* -main_library_call */
        READINPUT1 (image);
        READINPUT2 (center);
        READINPUT3 (varimg);

        CHECKINPUT (program, image);
        CHECKINPUT(program, center);
        CHECKINPUT(program, varimg);

          /* upconvert all images to float */
        images[0] = image;
        images[1] = center;
        images[2] = varimg;
        if (! lvcast(images, 3, VFF_TYP_FLOAT))
        {
            fprintf(stderr,
                "vwmdd: Input images could not be upcast to the data storage type of FLOAT. Check the data storage type of each input image\n");
            exit(1);
        }

        if ( image->num_data_bands != (center->num_data_bands - 1)) 
        {
            fprintf(stderr,
                "vwmdd: The center/class image does not contain the correct\n");
            fprintf(stderr, "number of data_bands\n");
            fprintf(stderr, 
                        "Should have %d bands, but contains %d bands\n", 
                        (image->num_data_bands + 1), center->num_data_bands);
            exit(1);
        }

        if ( image->num_data_bands != varimg->num_data_bands) 
        {
             fprintf(stderr, 
                "vwmdd: The variance image does not contain the correct\n");
             fprintf(stderr, "number of data_bands\n");
             fprintf(stderr, 
                        "Should have %d bands, but contains %d bands\n", 
                        image->num_data_bands , varimg->num_data_bands);
             exit(1);
        }

    /* Call the lib routine for minimum distance algorithm */

        if(! lvwmdd(image, center, varimg, vwmdd->b_int, vwmdd->k_float, 
                    vwmdd->s_logic))
        {
           (void) fprintf(stderr, "lvwmdd Failed\\n");
            exit(1);
        }

/* -main_library_call_end */

/* -main_after_lib_call */
        writeimage(vwmdd->o_file,image);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for vwmdd 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "vwmdd :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tWeighted minimum distance detector\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i1  Input Image  (infile)\n");
	fprintf(stderr,"\t-i2  Input Center/Class Image  (infile)\n");
	fprintf(stderr,"\t-i3  Input Variance Image  (infile)\n");
	fprintf(stderr,"\t-o  output image specifying which vector belongs to what cluster  (outfile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-k]   specifies the scaling factor (default = 1) (float, > 0.0) [1]\n");
	fprintf(stderr,"\t[-b]   specifies the border width in pixels (default = 0) (integer, 0 to 100) [0]\n");
	fprintf(stderr,"\t[-s]  Use Summed Method (boolean) [false]\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for vwmdd\n");
	fprintf(stderr, "\t[-U] Gives the usage for vwmdd\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called vwmdd.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses vwmdd.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for vwmdd
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i1_pstr = 
	"\nEnter: (i1) Input Image \n        {infile}: "; 
char	*i2_pstr = 
	"\nEnter: (i2) Input Center/Class Image \n        {infile}: "; 
char	*i3_pstr = 
	"\nEnter: (i3) Input Variance Image \n        {infile}: "; 
char	*o_pstr = 
	"\nEnter: (o) output image specifying which vector belongs to what cluster \n        {outfile}: "; 
char	*k_pstr = 
	"\nEnter: (k)  specifies the scaling factor (default = 1) \n        {float, > 0.0 [1.000000] }: "; 
char	*b_pstr = 
	"\nEnter: (b)  specifies the border width in pixels (default = 0) \n        {integer, 0 to 100 [0] }: "; 
char	*s_pstr = 
	"\nEnter: (s) Use Summed Method \n        {boolean, (y/n)  [no] }: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "vwmdd", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "vwmdd.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "vwmdd: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "vwmdd.ans");
		}

	     }

	}

	/*
	 * allocate the vwmdd structure
	 */
	vwmdd = (vwmdd_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (vwmdd_struct));

	/*
	 * get required arguments for vwmdd
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(vwmdd->i1_flag = vget_infile(fid, prompt_flag,
			"-i1", i1_pstr, &(vwmdd->i1_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vwmdd->i1_flag))
		{
		    fprintf(stderr, "\t\ti1 is required, please re-enter: \n");
		    vwmdd->i1_flag = vget_infile(fid, prompt_flag,
		    "-i1", i1_pstr, &(vwmdd->i1_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i1' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vwmdd->i2_flag = vget_infile(fid, prompt_flag,
			"-i2", i2_pstr, &(vwmdd->i2_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vwmdd->i2_flag))
		{
		    fprintf(stderr, "\t\ti2 is required, please re-enter: \n");
		    vwmdd->i2_flag = vget_infile(fid, prompt_flag,
		    "-i2", i2_pstr, &(vwmdd->i2_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i2' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vwmdd->i3_flag = vget_infile(fid, prompt_flag,
			"-i3", i3_pstr, &(vwmdd->i3_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vwmdd->i3_flag))
		{
		    fprintf(stderr, "\t\ti3 is required, please re-enter: \n");
		    vwmdd->i3_flag = vget_infile(fid, prompt_flag,
		    "-i3", i3_pstr, &(vwmdd->i3_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i3' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vwmdd->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(vwmdd->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vwmdd->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    vwmdd->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(vwmdd->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for vwmdd
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	vwmdd->k_flag = vget_float(fid, prompt_flag,
	"-k", k_pstr, &(vwmdd->k_float),
	1.000000, 2.000000, 2.000000);

	vwmdd->b_flag = vget_int(fid, prompt_flag,
	"-b", b_pstr, &(vwmdd->b_int),
	0, 0, 100);

	vwmdd->s_flag = vget_logic(fid, prompt_flag,
	"-s", s_pstr, &(vwmdd->s_logic), 0);


}



