 /*
  * Khoros: $Id: vkmeans.h,v 1.2 1991/12/18 09:32:27 dkhoros Exp $
  */

 /*
  * $Log: vkmeans.h,v $
 * Revision 1.2  1991/12/18  09:32:27  dkhoros
 * HellPatch3
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */


/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vkmeans.h
 >>>>            Author: Tom Sauer, Charlie Gage
 >>>> Date Last Updated: Wed Dec  4 14:44:05 1991
 >>>> 
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/

#ifndef _vkmeans_h_
#define _vkmeans_h_

#include "vinclude.h"


/* -include_includes */
/* -include_includes_end */

char	**av,		/* argv and argc used by gparams */
	*program;	/* a pointer to the program name argv[0] */
int	ac;

/****************************************************************
*
*                    vkmeans Argument Structure
*
****************************************************************/

typedef struct _vkmeans  {

/*
 *  input image (Required infile)
 */
char	*i1_file;	/* input image FILENAME */
int	 i1_flag;	/* input image FLAG */

/*
 *  output cluster number image (Required outfile)
 */
char	*o1_file;	/* output cluster number image FILENAME */
int	 o1_flag;	/* output cluster number image FLAG */

/*
 *  output file for kmeans statistics (Required outfile)
 */
char	*f2_file;	/* output file for kmeans statistics FILENAME */
int	 f2_flag;	/* output file for kmeans statistics FLAG */

/*
 *  output image for cluster centers (Optional outfile)
 */
char	*o2_file;	/* output image for cluster centers FILENAME */
int	 o2_flag;	/* output image for cluster centers FLAG */

/*
 *  output image for variance (Optional outfile)
 */
char	*o3_file;	/* output image for variance FILENAME */
int	 o3_flag;	/* output image for variance FLAG */

/*
 *  Output Image Map Enable (Optional logical)
 */
int	 m_logic;	/* Output Image Map Enable LOGIC */
int	 m_flag;  	/* Output Image Map Enable FLAG */

/*
 *  specifies maximum number of iterations (default = 100000) (Optional integer)
 */
int	 n_int; 	/* specifies maximum number of iterations (default = 100000) INT */
int	 n_flag;	/* specifies maximum number of iterations (default = 100000) FLAG */

/*
 *  specifies number of clusters (default = 2) (Optional integer)
 */
int	 k_int; 	/* specifies number of clusters (default = 2) INT */
int	 k_flag;	/* specifies number of clusters (default = 2) FLAG */

/*
 *   specifies the border width in pixels (default = 0) (Optional integer)
 */
int	 b_int; 	/*  specifies the border width in pixels (default = 0) INT */
int	 b_flag;	/*  specifies the border width in pixels (default = 0) FLAG */

/*----  these are an Optional mutually exclusive group ----*/
/*
 *  if Yes use First K Vectors As Cluster Centers (Required logical)
 */
int	 c_logic;	/* if Yes use First K Vectors As Cluster Centers LOGIC */
int	 c_flag;  	/* if Yes use First K Vectors As Cluster Centers FLAG */

/*
 *  input ASCII file for x-y coordinates of cluster centers (Required infile)
 */
char	*f1_file;	/* input ASCII file for x-y coordinates of cluster centers FILENAME */
int	 f1_flag;	/* input ASCII file for x-y coordinates of cluster centers FLAG */

/*
 *  input image cluster center values (Required infile)
 */
char	*i2_file;	/* input image cluster center values FILENAME */
int	 i2_flag;	/* input image cluster center values FLAG */

/*-------------------------------------------*/

}  vkmeans_struct;

vkmeans_struct *vkmeans;

/* -include_additions */
/* -include_additions_end */

/* -include_macros */
#define READINPUT(image) \
image = readimage(vkmeans->i1_file); \
if(image == NULL){ \
(void) fprintf(stderr,"vkmeans: Image could not be read\n"); \
exit(1); \
}

#define CHECKINPUT(program, image) \
        (void) proper_num_images(program,image,1,TRUE); \
        \
        (void) proper_map_enable(program,image,VFF_MAP_OPTIONAL,TRUE); \
        \
        (void) propertype(program, image, VFF_TYP_FLOAT, TRUE)
/* -include_macros_end */

#endif
