 /*
  * Khoros: $Id: vlog.c,v 1.1 1991/05/10 15:45:46 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: vlog.c,v 1.1 1991/05/10 15:45:46 khoros Exp $";
#endif

 /*
  * $Log: vlog.c,v $
 * Revision 1.1  1991/05/10  15:45:46  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vlog.c
 >>>>
 >>>>      Program Name: vlog
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Compute the logarithm of an image pixel by pixel.
 >>>>	
 >>>>	
 >>>>            Author: Scott Wilson
 >>>>
 >>>> Date Last Updated: Wed Mar 27 23:58:04 1991
 >>>>
 >>>>          Routines: main- the main program for vlog
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vlog.h"


/****************************************************************
 *
 * Routine Name:  main program for vlog
 *
 *       Input:  
 *      -i  input image 
 *      -o  resulting output image 
 *
 *
 *      [-m] logarithm operation masking input image
 *      [-n] Choose Natural Log [False] or Log Base 10 [True]
 *      [-t] Operate either on value [False] or value+1 [True]
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
    struct xvimage *img1,*img2, *readimage();
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
   if (check_args()) exit(1);
   img1 = readimage(vlog->i_file);
    if (img1 == NULL) exit(1);                   /* Quit if bad image */
    if (vlog->m_flag) img2 = readimage(vlog->m_file);
    if (vlog->m_flag && (img2 == NULL)) exit(1);  /* Quit if bad image */

    CHECKINPUT(program,img1);   /* Verify input image */

    if(vlog->m_flag){
        MATCHINPUT(program,img1,img2);  /* Verify input images */
    }

/* -main_before_lib_call_end */

/* -main_library_call */
    if(! lvlog(img1,img2,vlog->m_flag,vlog->t_logic,vlog->n_logic))
    {
        (void) fprintf(stderr, "lvlog Failed\n");
        exit(1);
    }
/* -main_library_call_end */

/* -main_after_lib_call */
    writeimage(vlog->o_file,img1);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for vlog 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "vlog :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tCompute the logarithm of an image pixel by pixel.\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i  input image  (infile)\n");
	fprintf(stderr,"\t-o  resulting output image  (outfile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-m]  logarithm operation masking input image (infile) [null]\n");
	fprintf(stderr,"\t[-n]  Choose Natural Log [False] or Log Base 10 [True] (boolean) [true]\n");
	fprintf(stderr,"\t[-t]  Operate either on value [False] or value+1 [True] (boolean) [true]\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for vlog\n");
	fprintf(stderr, "\t[-U] Gives the usage for vlog\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called vlog.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses vlog.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for vlog
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i_pstr = 
	"\nEnter: (i) input image \n        {infile}: "; 
char	*o_pstr = 
	"\nEnter: (o) resulting output image \n        {outfile}: "; 
char	*m_pstr = 
	"\nEnter: (m) logarithm operation masking input image \n        {infile}: "; 
char	*n_pstr = 
	"\nEnter: (n) Choose Natural Log [False] or Log Base 10 [True] \n        {boolean, (y/n)  [yes] }: "; 
char	*t_pstr = 
	"\nEnter: (t) Operate either on value [False] or value+1 [True] \n        {boolean, (y/n)  [yes] }: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "vlog", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "vlog.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "vlog: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "vlog.ans");
		}

	     }

	}

	/*
	 * allocate the vlog structure
	 */
	vlog = (vlog_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (vlog_struct));

	/*
	 * get required arguments for vlog
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(vlog->i_flag = vget_infile(fid, prompt_flag,
			"-i", i_pstr, &(vlog->i_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vlog->i_flag))
		{
		    fprintf(stderr, "\t\ti is required, please re-enter: \n");
		    vlog->i_flag = vget_infile(fid, prompt_flag,
		    "-i", i_pstr, &(vlog->i_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vlog->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(vlog->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vlog->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    vlog->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(vlog->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for vlog
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	vlog->m_flag = vget_infile(fid, prompt_flag,
	"-m", m_pstr, &(vlog->m_file))
;

	vlog->n_flag = vget_logic(fid, prompt_flag,
	"-n", n_pstr, &(vlog->n_logic), 1);

	vlog->t_flag = vget_logic(fid, prompt_flag,
	"-t", t_pstr, &(vlog->t_logic), 1);


}



