 /*
  * Khoros: $Id: lvwiener.c,v 1.2 1992/03/20 23:08:04 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: lvwiener.c,v 1.2 1992/03/20 23:08:04 dkhoros Exp $";
#endif

 /*
  * $Log: lvwiener.c,v $
 * Revision 1.2  1992/03/20  23:08:04  dkhoros
 * VirtualPatch5
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1992, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1992 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: lvwiener.c
 >>>>
 >>>>      Program Name: vwiener
 >>>>
 >>>> Date Last Updated: Mon Mar  9 18:44:44 1992 
 >>>>
 >>>>          Routines: lvwiener - the library call for vwiener
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vinclude.h"


/* -library_includes */
/* -library_includes_end */


/****************************************************************
*
* Routine Name: lvwiener - library call for vwiener
*
* Purpose:
*    
*    Perform  image   restoration   by   Wiener   (least-squares)
*    filtering.
*    
*    

* Input:
*    
*         1. f1 --  first  xvimage  structure;  FFT  of  image  to  be
*         restored
*         2. f2 -- second xvimage structure; FFT  of  reference  image
*         (optional)
*         3. f3 -- third xvimage structure; FFT of PSF function
*         4. bflg -- a flag set if reference image is available
*         5. thresh -- minimum PSF threshold (optional)
*         6. rest -- Weiner parameter
*    
*         The input xvimage structures must be of the same  data  type
*         and size.
*    
*    

* Output:
*    
*         1. f1 -- holds the result of the Weiner filtering
*                  operation. The output data type is the same
*                  as the input data type.
*         2. f3 -- holds the restoration filter.
*    
*         f1 is used for both the input xvimage structure and the out-
*         put result xvimage structure. This is done to save space.
*    
*         lvwiener returns a zero upon failure and a one upon success.
*    
*    

*
* Written By: Scott Wilson
*    
*    Marcelo Teran, Ramiro Jordan
*    
*    Scott Wilson - 27-Jan-91 - Removed FFT data type processing
*    
*    

****************************************************************/


/* -library_def */
int
lvwiener(f1,f2,f3,bflg,thresh,rest)
struct xvimage *f1,*f2,*f3;
int   bflg;
float thresh, rest;
/* -library_def_end */

/* -library_code */
{
    int i,j;
    float *p1,*p2,*p3,m,mu;
    double angle;
    float tr,ti,r1,i1,r2,i2;

    if (f1->row_size != f3->row_size || f1->col_size != f3->col_size
        || (bflg && (f1->row_size != f2->row_size))
        || (bflg && (f1->col_size != f2->col_size)))
    {
        (void) fprintf(stderr,"lvinverse: Input images are of different size!\n");
        return(0);
    }

    if (f1->data_storage_type != VFF_TYP_COMPLEX ||
        f3->data_storage_type != VFF_TYP_COMPLEX ||
        (bflg && (f2->data_storage_type != VFF_TYP_COMPLEX)))
    {
        (void) fprintf(stderr,"lvinverse: Input images must be VFF_TYP_COMPLEX!\n");
        return(0);
     }

    p1 = (float *)(f1->imagedata);
    if (bflg) p2 = (float *)(f2->imagedata);
    p3 = (float *)(f3->imagedata);

    for (i = 0; i < f1->col_size; i++) /* Rows of FFT */
    {
        for (j = 0; j < f1->row_size; j++)
        {
            m = vcabs(*p3,*(p3+1));            /* Get PSF magnitude */
            mu = (m*m)/(m*m + rest*rest);    /* Form Weiner multiplier */
            if (m < thresh)                   /* Check PSF thresh level*/
            {
                angle = cang(*p3,*(p3+1));
                *p3     = cos(angle)*thresh;
                *(p3+1) = sin(angle)*thresh;
             }
            cdiv(&tr,&ti,mu,0.0,*p3,*(p3+1)); /* Compute rest. filter */
            *p3 = tr; *(p3+1) = ti;           /* Save the rest filter */
            r1 = *p1; i1 = *(p1+1);           /* Get image value */
            if (bflg)                         /* Subtract ref if needed */
            {
                r1 -= *p2; i1 -= *(p2+1);
             }
            cmul(&r2,&i2,r1,i1,tr,ti);        /* Perform division */
            *p1 = r2; *(p1+1) = i2;           /* Save result image */
            p1 += 2; p2 += 2; p3 += 2;
          }
      }
   return(1);
}
/* -library_code_end */
