 /*
  * Khoros: $Id: lvsqrt.c,v 1.2 1991/10/02 00:23:19 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: lvsqrt.c,v 1.2 1991/10/02 00:23:19 khoros Exp $";
#endif

 /*
  * $Log: lvsqrt.c,v $
 * Revision 1.2  1991/10/02  00:23:19  khoros
 * HellPatch2
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: lvsqrt.c
 >>>>
 >>>>      Program Name: vsqrt
 >>>>
 >>>> Date Last Updated: Wed Mar 27 23:59:54 1991 
 >>>>
 >>>>          Routines: lvsqrt - the library call for vsqrt
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vinclude.h"


/* -library_includes */
/* -library_includes_end */


/****************************************************************
*
* Routine Name: lvsqrt - library call for vsqrt
*
* Purpose:
*    
*    Compute the square root of an image pixel by  pixel  with  a
*    masking image.
*    
*    
* Input:
*    
*         1. img1 -- input xvimage structure
*         2. img2 -- operation gating xvimage structure
*         3. mflg -- if set to one,
*                    use img2 to gate the sqrt operation
*    
*         The inputs must be of the same data type and size.
*    
*    
* Output:
*    
*         1. img1 -- output xvimage structure
*                    img1 is used for both the input xvimage
*                    structure and the output result xvimage
*                    structure.  This is done to save space,
*                    but you must be careful not to overwrite
*                    important data.
*    
*         The square root of a negative number is zero.
*    
*         lvsqrt returns a zero upon failure.
*    
*    
*
* Written By: Scott Wilson
*    
*    Marcelo Teran, John Rasure, Tom Sauer
*    
*    Jeremy Worley Feb 27, 1991 added double processing
*    
*    
****************************************************************/


/* -library_def */
int
lvsqrt(img1,img2,mflg)
struct xvimage *img1,*img2;
int  mflg;
/* -library_def_end */

/* -library_code */
{

    int j,k;
    unsigned char *c1,*c2;
    short *s1,*s2;
    int *i1,*i2;
    float f,*f1,*f2;
    double d,*d1,*d2;

    k = img1->row_size*img1->col_size * img1->num_data_bands;          /* Normal operation count */
    switch (img1->data_storage_type)
      {
        case VFF_TYP_BIT :
          fprintf(stderr,"lvsqrt: Don't know how to SQRT a BIT image!\n");
          return(0);
          break;
        case VFF_TYP_1_BYTE : 
          c1 = (unsigned char *)(img1->imagedata);
          if (mflg) c2 = (unsigned char *)(img2->imagedata);
          if (!mflg)
            {
              for (j=0; j<k; j++)
                {
                  f = sqrt((double)*c1);
                  *c1++ = f;
                }
            }
          else
            {
              for (j=0; j<k; j++)
                {
                  if (*c2++)
                    {
                      f = sqrt((double)*c1);
                      *c1++ = f;
                    }
                  else c1++;
                }
            }
          break;
        case VFF_TYP_2_BYTE :
          s1 = (short *)(img1->imagedata);
          if (mflg) s2 = (short *)(img2->imagedata);
          if (!mflg)
            {
              for (j=0; j<k; j++)
                {
                  if (*s1 >= 0) f = sqrt((double)*s1);
                  else f = 0.0;
                  *s1++ = f;
                }
            }
          else
            {
              for (j=0; j<k; j++)
                {
                  if (*s2++)
                    {
                      if (*s1 >= 0) f = sqrt((double)*s1);
                      else f = 0.0;
                      *s1++ = f;
                    }
                  else s1++;
                }
            }
          break;
        case VFF_TYP_4_BYTE :
          i1 = (int *)(img1->imagedata);
          if (mflg) i2 = (int *)(img2->imagedata);
          if (!mflg)
            {
              for (j=0; j<k; j++)
                {
                  if (*i1 >= 0) f = sqrt((double)*i1);
                  else f = 0.0;
                  *i1++ = f;
                }
            }
          else
            {
              for (j=0; j<k; j++)
                {
                  if (*i2++)
                    {
                      if (*i1 >= 0) f = sqrt((double)*i1);
                      else f = 0.0;
                      *i1++ = f;
                    }
                  else i1++;
                }
            }
          break;
        case VFF_TYP_FLOAT :
          f1 = (float *)(img1->imagedata);
          if (mflg) f2 = (float *)(img2->imagedata);
          if (!mflg)
            {
              for (j=0; j<k; j++)
                {
                  if (*f1 >= 0) f = sqrt((double)*f1);
                  else f = 0.0;
                  *f1++ = f;
                }
            }
          else
            {
              for (j=0; j<k; j++)
                {
                  if (*f2++)
                    {
                      if (*f1 >= 0) f = sqrt((double)*f1);
                      else f = 0.0;
                      *f1++ = f;
                    }
                  else f1++;
                }
            }
          break;
        case VFF_TYP_DOUBLE :
          d1 = (double *)(img1->imagedata);
          if (mflg) d2 = (double *)(img2->imagedata);
          if (!mflg)
            {
              for (j=0; j<k; j++)
                {
                  if (*d1 >= 0) d = sqrt((double)*d1);
                  else d = 0.0;
                  *d1++ = d;
                }
            }
          else
            {
              for (j=0; j<k; j++)
                {
                  if (*d2++)
                    {
                      if (*d1 >= 0) d = sqrt((double)*d1);
                      else d = 0.0;
                      *d1++ = d;
                    }
                  else d1++;
                }
            }
          break;
        case VFF_TYP_COMPLEX :
        case VFF_TYP_DCOMPLEX :
          fprintf(stderr,"lvsqrt: Don't know how to SQRT a COMPLEX image!\n");
          return(0);
          break;
        default:
          fprintf(stderr,"lvsqrt: Unknown data storage type, %d\n",img1->data_storage_type);
          return(0);
          break;
      }
      return(1);

}
/* -library_code_end */
