 /*
  * Khoros: $Id: lvrect2pol.c,v 1.2 1992/03/20 23:07:27 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: lvrect2pol.c,v 1.2 1992/03/20 23:07:27 dkhoros Exp $";
#endif

 /*
  * $Log: lvrect2pol.c,v $
 * Revision 1.2  1992/03/20  23:07:27  dkhoros
 * VirtualPatch5
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1992, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1992 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: lvrect2pol.c
 >>>>
 >>>>      Program Name: vrect2pol
 >>>>
 >>>> Date Last Updated: Mon Mar  9 18:46:50 1992 
 >>>>
 >>>>          Routines: lvrect2pol - the library call for vrect2pol
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vinclude.h"


/* -library_includes */
/* -library_includes_end */


/****************************************************************
*
* Routine Name: lvrect2pol - library call for vrect2pol
*
* Purpose:
*    
*    Converts  Data  from  Rectangular  to  Polar  or  Polar   to
*    rectangular coordinates.
*    
*    

* Input:
*    
*    *image         (struct xvimage) data to be converted
*    
*    convert_dir    (int) 0 = rectangular -> polar, 1 = polar to rect.
*    
*    process_dir    (int) 0 = down vectors, 1 = across bands
*    
*    

* Output:
*    
*    *image         (struct xvimage) converted image
*    
*    

*
* Written By: Ramiro Jordan, Jeremy Worley, Tom Sauer
*    
*    Wed Jun  6 18:14:24 MDT 1990 Donna Koechner - updated  to  ghost-
*    writer
*    Audit Done  05-OCT-90  Donna Koechner
*    
*    

****************************************************************/


/* -library_def */
int 
lvrect2pol ( image, convert_dir, process_dir)
struct xvimage *image;
int    process_dir, convert_dir;
/* -library_def_end */

/* -library_code */
{
    int   i, dimension, num_vects, arith;
    int   lpol2rec(), lrec2pol(), dunload_vector();
    float **data; 

    char **dload_vector(),
         *program = "lvrect2pol";

    int  propertype();


    if( ! (propertype(program,image,VFF_TYP_FLOAT,FALSE)) &&
        ! (propertype(program,image,VFF_TYP_COMPLEX,FALSE)) ) {
          fprintf(stderr,"%s: data storage type must be float or complex.\n",
                  program);
          return(0);
    }

    arith = 1;
    if (image->data_storage_type == VFF_TYP_COMPLEX)
    {
      arith = 2;
    }

    if( (data = (float **)dload_vector(image, &num_vects, &dimension, 
                process_dir)) == NULL)
    {
      (void) fprintf(stderr,"%s: dload_vector failed \n",program);
      return(0);
    }

    dimension *= arith;

    for ( i = 0; i < num_vects; i++ )
    {
        if ( !convert_dir )                /* convert rect to polar */
        {
           if ( !lrec2pol ( data[i], dimension ) )
           {
               (void) fprintf ( stderr,"ldccmplx failed\n");
               return(0);
           }
        }
        else
        {
           if ( !lpol2rec ( data[i], dimension ) )
           {
               fprintf(stderr,"ldccmplx failed\n"); 
               return(0);
           }
        }
    }

    dimension /= arith;

    if (!dunload_vector((char **)data, image, image->data_storage_type, 
         num_vects, dimension, process_dir))
    {
       (void) fprintf (stderr,"%s: dunload_vector failed \n",program);
       return(0);
    }
 
    return(1);

} /* end of ldccmplx */


/*
*****************************************************************************
*
*       datain:                 input - data sequence to convert
*                               output - converted data record
*
*       points:                 length of data record
*
*****************************************************************************
*/

int
lrec2pol ( datain, points )

int    points;
float  *datain;
{
    int   i;
    float r,theta;

    for ( i = 0; i < points; i+=2 )
    {
       r = (float)vcabs(datain[i],datain[i+1]);
       theta = (float)cang(datain[i],datain[i+1]);

       datain[i] = r;
       datain[i+1] = theta;
    }

    return(1);

} /* end of lrec2pol */




int
lpol2rec ( datain, points )

int    points;
float  *datain;
{
    int   i;
    float x,y;

    for ( i = 0; i < points; i+=2 )
    {
       x = datain[i] * cos(datain[i+1]);
       y = datain[i] * sin(datain[i+1]);

       datain[i] = x;
       datain[i+1] = y;
    }

    return(1);
}

/*** the end ***/
/* -library_code_end */
