 /*
  * Khoros: $Id: lvgamth.c,v 1.1 1991/05/10 15:41:54 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: lvgamth.c,v 1.1 1991/05/10 15:41:54 khoros Exp $";
#endif

 /*
  * $Log: lvgamth.c,v $
 * Revision 1.1  1991/05/10  15:41:54  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: lvgamth.c
 >>>>
 >>>>      Program Name: vgamth
 >>>>
 >>>> Date Last Updated: Tue Mar  5 22:39:43 1991 
 >>>>
 >>>>          Routines: lvgamth - the library call for vgamth
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vinclude.h"


/* -library_includes */
/* -library_includes_end */


/****************************************************************
*
* Routine Name: lvgamth - library call for vgamth
*
* Purpose:
*    
*    Generate a binary image by thresholding a gamut image.
*    
*    
* Input:
*    
*         image -- input pseudo colored image in byte format
*         rlower -- lower threshold value  for  map  column  #1  pixel
*         value
*         rupper -- upper threshold value  for  map  column  #1  pixel
*         value
*         lrflag -- flag that says map column #1 lower thresh value is
*         valid
*    
*         urflag -- flag that says map column #1 upper thresh value is
*         valid
*    
*         glower -- lower threshold value  for  map  column  #2  pixel
*         value
*         gupper -- upper threshold value  for  map  column  #2  pixel
*         value
*         lgflag -- flag says map column  #2  lower  thresh  value  is
*         valid
*         ugflag -- flag says map column  #2  upper  thresh  value  is
*         valid
*         blower -- lower threshold value  for  map  column  #3  pixel
*         value
*         bupper -- upper threshold value  for  map  column  #3  pixel
*         value
*         lbflag -- flag says map map column #3 lower thresh value  is
*         valid
*    
*         ubflag -- flag says map column  #3  upper  thresh  value  is
*         valid
*         value  -- Value for the non-zero pixel.
*    
*    
* Output:
*    
*         image -- thresheld binary output image.
*    
*         image is used for both input and the output result.  This is
*         done to save space, but you must be careful not to overwrite
*         important data.
*    
*         lvgamth returns 1 upon success and 0 on failure.
*    
*    
*
* Written By: Tom Sauer
*    
*    
****************************************************************/


/* -library_def */
int
lvgamth(image,rupper,rlower,gupper,glower,bupper,blower,
          lrflag, urflag, lgflag, ugflag, lbflag, ubflag,vflag,value)

struct xvimage *image;
int rupper, rlower, bupper, blower, gupper, glower;
int lrflag, urflag, lgflag, ugflag, lbflag, ubflag;
int vflag, value;
/* -library_def_end */

/* -library_code */
{

    unsigned char *c, cvalue, *rptr, *bptr, *gptr; 
    int j;
    char *program = "lvgamth";

        /* by default the lower threshhold value is used, if nothing
                was specified */
     if (!lrflag && !urflag) lrflag = 1;
     if (!lbflag && !ubflag) lbflag = 1;
     if (!lgflag && !ugflag) lgflag = 1;

      /* can only have one image */
     if (! (proper_num_images(program,image,1,FALSE))) {
          (void) fprintf(stderr,
                  "%s: ERROR All inputs must contain only one image\n"
                  , program);
           return(0);
      }

      /* can only have one data band */
     if (! (proper_num_bands(program,image,1,FALSE))) {
          (void) fprintf(stderr,
                  "%s: ERROR All inputs must contain only one data band\n"
                  , program);
           return(0);
      }

      /* can only have data type of BYTE */
     if (! (propertype(program,image,VFF_TYP_1_BYTE,FALSE))) {
          (void) fprintf(stderr,
                  "%s: ERROR input must have data type of BYTE\n"
                  , program);
           return(0);
      }

      /* must have map enable set to FORCE */
     if (! (proper_map_enable(program,image,VFF_MAP_FORCE,FALSE))) {
          (void) fprintf(stderr,
                  "%s: ERROR input must have map enable type FORCE\n"
                  , program);
           return(0);
      }

        /* must have 3 columns in the map */
     if (! (proper_map_rowsize(program,image,3,FALSE))) {
          (void) fprintf(stderr,
                  "%s: ERROR input must have map row size of 3\n"
                  , program);
           return(0);
      }

        /* map data type must be BYTE */
     if (! (proper_map_type(program,image,VFF_MAPTYP_1_BYTE,FALSE))) {
          (void) fprintf(stderr,
                  "%s: ERROR input must have map data type of BYTE\n"
                  , program);
           return(0);
      }

       /* point to each column in the map */

     rptr = (unsigned char *)&image->maps[0];
     gptr = (unsigned char *)&image->maps[image->map_col_size];
     bptr = (unsigned char *)&image->maps[2 * image->map_col_size];
    
     c = (unsigned char *)image->imagedata;

       /* loop through the image and set each pixel to either zero
          or to value depending on the threshhold specifications */

     for (j = 0;j < (image->row_size * image->col_size);j++)
     {
       cvalue = *c;
       *c = 0;

           /* all lower flags must be set */

       if ( lrflag && (*(rptr + cvalue) > rlower) 
            && lbflag && (*(bptr + cvalue) > blower) 
            && lgflag && (*(gptr + cvalue) > glower)) *c = value;

          /* all upper flags must be set */

       if ( urflag && (*(rptr + cvalue) > rupper) 
            && ubflag && (*(bptr + cvalue) > bupper) 
            && ugflag && (*(gptr + cvalue) > gupper)) *c = 0;

            /* map colunm 1 has upper and lower equal, with 
               the other 2 lower flags set */

       if ( lrflag && urflag && rlower == rupper 
            && (*(rptr + cvalue) == rlower) 
            && lbflag && (*(bptr + cvalue) > blower) 
            && lgflag && (*(gptr + cvalue) > glower))  *c = value;

            /* map colunm 1 has upper and lower equal, with 
               the other 2 upper flags set */

       if ( lrflag && urflag && rlower == rupper 
            && (*(rptr + cvalue) == rlower) 
            && ubflag && (*(bptr + cvalue) > bupper) 
            && ugflag && (*(gptr + cvalue) > gupper))  *c = 0;

            /* map colunm 2 has upper and lower equal, with 
               the other 2 lower flags set */

       if ( lgflag && ugflag && glower == gupper 
            && (*(gptr + cvalue) == glower) 
            && lbflag && (*(bptr + cvalue) > blower) 
            && lrflag && (*(rptr + cvalue) > rlower))  *c = value;

            /* map colunm 2 has upper and lower equal, with 
               the other 2 upper flags set */

       if ( lgflag && ugflag && glower == gupper 
            && (*(gptr + cvalue) == glower) 
            && ubflag && (*(bptr + cvalue) > bupper) 
            && urflag && (*(rptr + cvalue) > rupper))  *c = 0;

            /* map colunm 3 has upper and lower equal, with 
               the other 2 lower flags set */

       if ( lbflag && ubflag && blower == bupper 
            && (*(bptr + cvalue) == blower) 
            && lgflag && (*(gptr + cvalue) > glower) 
            && lrflag && (*(rptr + cvalue) > rlower))  *c = value;

            /* map colunm 3 has upper and lower equal, with 
               the other 2 upper flags set */

       if ( lbflag && ubflag && blower == bupper 
            && (*(bptr + cvalue) == blower) 
            && ugflag && (*(gptr + cvalue) > gupper) 
            && urflag && (*(rptr + cvalue) > rupper))  *c = 0;

            /* all 3 map column upper and lower flags set */

       if ( lrflag && urflag && rlower == rupper 
            && (*(rptr + cvalue) == rlower) 
            && lbflag && ubflag && blower == bupper 
            && (*(bptr + cvalue) == blower) 
            && lgflag && ugflag && glower == gupper 
            && (*(gptr + cvalue) == glower))  *c = value;
       c++;
     }

        /* maps are no longer needed since the image is now a 
           binary image */
     free(image->maps);
     image->maps = NULL;
     image->map_row_size = 0;
     image->map_col_size = 0;
     image->map_enable = VFF_MAP_OPTIONAL;
     image->map_scheme = VFF_MS_NONE;
     image->color_space_model = VFF_CM_NONE;

     return(1);
}
/* -library_code_end */
