 /*
  * Khoros: $Id: lvexp.c,v 1.1 1991/05/10 15:41:54 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: lvexp.c,v 1.1 1991/05/10 15:41:54 khoros Exp $";
#endif

 /*
  * $Log: lvexp.c,v $
 * Revision 1.1  1991/05/10  15:41:54  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: lvexp.c
 >>>>
 >>>>      Program Name: vexp
 >>>>
 >>>> Date Last Updated: Wed Mar 27 23:57:04 1991 
 >>>>
 >>>>          Routines: lvexp - the library call for vexp
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vinclude.h"


/* -library_includes */
/* -library_includes_end */


/****************************************************************
*
* Routine Name: lvexp - library call for vexp
*
* Purpose:
*    
*    Compute the base  10  antilogarithm  of  an  image  with  an
*    operation gating image.
*    
*    
* Input:
*    
*         1. img1 -- first xvimage structure
*         2. img2 -- mask xvimage structure
*         3. tflg -- if set to non zero, compute exp10(x) - 1,
*                    if set to zero compute exp10(x)
*         4. mflg -- if set, then the mask image is available
*                    and will be used.
*    
*         The inputs must be of the same data type and size.
*    
*    
* Output:
*    
*         1. img1 -- output xvimage structure img1 is  used  for  both
*         the  input  xvimage  structure and the output result xvimage
*         structure.  This is done to save  space,  but  you  must  be
*         careful not to overwrite important data.
*    
*         lvexp returns a zero upon failure.
*    
*    
*
* Written By: Scott Wilson
*    
*    Marcelo Teran,  John  Rasure,  Tom  Sauer  27-Feb-91  Jeremy
*    Worley added processing for double precision images.
*    
*    
****************************************************************/


/* -library_def */
int
lvexp(img1,img2,tflg,mflg)
struct xvimage *img1, *img2;
int  tflg,mflg;
/* -library_def_end */

/* -library_code */
{
    int i,j,k;
    unsigned char *c1,*c2;
    short *s1,*s2;
    int *i1,*i2;
    float *f1,*f2;
    double *d1,*d2;

           /* Normal operation count */
    k = img1->row_size*img1->col_size * img1->num_data_bands;   
    switch (img1->data_storage_type)
      {
        case VFF_TYP_BIT :
          fprintf(stderr,"lvexp: Don't know how to EXP a BIT image!\n");
          return(0);
          break;
        case VFF_TYP_1_BYTE : 
          c1 = (unsigned char *)(img1->imagedata);
          if (mflg) c2 = (unsigned char *)(img2->imagedata);
          if (!mflg)
            {
              for (j=0; j<k; j++)
                {
                  if (tflg) i = pow(10.0,(double)(*c1))-1.0;
                  else i = pow(10.0,(double)(*c1));
                  if (i < 0) i = 0;
                  *c1++ = i;
                }
            }
          else
            {
              for (j=0; j<k; j++)
                {
                  if (*c2++)
                    {
                      if (tflg) i = pow(10.0,(double)(*c1))-1.0;
                      else i = pow(10.0,(double)(*c1));
                      if (i < 0) i=0;
                      *c1++ = i;
                    }
                  else c1++;
                }
            }
          break;
        case VFF_TYP_2_BYTE :
          s1 = (short *)(img1->imagedata);
          if (mflg) s2 = (short *)(img2->imagedata);
          if (!mflg)
            {
              for (j=0; j<k; j++)
                {
                  if (tflg) *s1 = pow(10.0,(double)(*s1))-1.0;
                  else *s1 = pow(10.0,(double)(*s1));
                  s1++;
                }
            }
          else
            {
              for (j=0; j<k; j++)
                {
                  if (*s2++)
                    {
                      if (tflg) *s1 = pow(10.0,(double)(*s1))-1.0;
                      else *s1 = pow(10.0,(double)(*s1));
                      s1++;
                    }
                  else s1++;
                }
            }
          break;
        case VFF_TYP_4_BYTE :
          i1 = (int *)(img1->imagedata);
          if (mflg) i2 = (int *)(img2->imagedata);
          if (!mflg)
            {
              for (j=0; j<k; j++)
                {
                  if (tflg) *i1 = pow(10.0,(double)(*i1))-1.0;
                  else *i1 = pow(10.0,(double)(*i1));
                  i1++;
                }
            }
          else
            {
              for (j=0; j<k; j++)
                {
                  if (*i2++)
                    {
                      if (tflg) *i1 = pow(10.0,(double)(*i1))-1.0;
                      else *i1 = pow(10.0,(double)(*i1));
                      i1++;
                    }
                  else i1++;
                }
            }
          break;
        case VFF_TYP_FLOAT :
          f1 = (float *)(img1->imagedata);
          if (mflg) f2 = (float *)(img2->imagedata);
          if (!mflg)
            {
              for (j=0; j<k; j++)
                {
                  if (tflg) *f1 = pow(10.0,(double)(*f1))-1.0;
                  else *f1 = pow(10.0,(double)(*f1));
                  f1++;
                }
            }
          else
            {
              for (j=0; j<k; j++)
                {
                  if (*f2++)
                    {
                      if (tflg) *f1 = pow(10.0,(double)(*f1))-1.0;
                      else *f1 = pow(10.0,(double)(*f1));
                      f1++;
                    }
                  else f1++;
                }
            }
          break;
        case VFF_TYP_DOUBLE :
          d1 = (double *)(img1->imagedata);
          if (mflg) d2 = (double *)(img2->imagedata);
          if (!mflg)
            {
              for (j=0; j<k; j++)
                {
                  if (tflg) *d1 = pow(10.0,(double)(*d1))-1.0;
                  else *d1 = pow(10.0,(double)(*d1));
                  d1++;
                }
            }
          else
            {
              for (j=0; j<k; j++)
                {
                  if (*d2++)
                    {
                      if (tflg) *d1 = pow(10.0,(double)(*d1))-1.0;
                      else *d1 = pow(10.0,(double)(*d1));
                      d1++;
                    }
                  else d1++;
                }
            }
          break;
        case VFF_TYP_COMPLEX :
        case VFF_TYP_DCOMPLEX :
          fprintf(stderr,"lvexp: Don't know how to EXP a COMPLEX image!\n");
          return(0);
          break;
        default:
          fprintf(stderr,"lvexp: Unknown data storage type, %d\n",img1->data_storage_type);
          return(0);
          break;
      }
      return(1);

}
/* -library_code_end */
