 /*
  * Khoros: $Id: lvdiff.c,v 1.1 1991/05/10 15:41:54 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: lvdiff.c,v 1.1 1991/05/10 15:41:54 khoros Exp $";
#endif

 /*
  * $Log: lvdiff.c,v $
 * Revision 1.1  1991/05/10  15:41:54  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: lvdiff.c
 >>>>
 >>>>      Program Name: vdiff
 >>>>
 >>>> Date Last Updated: Tue Mar  5 22:28:47 1991 
 >>>>
 >>>>          Routines: lvdiff - the library call for vdiff
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vinclude.h"


/* -library_includes */
/* -library_includes_end */


/****************************************************************
*
* Routine Name: lvdiff - library call for vdiff
*
* Purpose:
*    
*    Performs image differentiation by  running  2  NxN  weighted
*    operators on an image.
*    
*    
* Input:
*    
*         1. img -- xvimage structure
*         2. kern1 -- kernel or operator in X
*         3. kern2 -- kernel or operator in Y
*    
*    
* Output:
*    
*         1. img -- xvimage structure, holds the
*                   resulting image
*    
*         img is used for both the input  xvimage  structure  and  the
*         output  result  xvimage  structure.   This  is  done to save
*         space, but you must be careful not  to  overwrite  important
*         data.
*    
*         lvdiff returns 1 upon success and 0 on failure.
*    
*    
*
* Written By: Marcelo Teran, Ramiro Jordan
*    
*    
****************************************************************/


/* -library_def */
int
lvdiff(img,kern1,kern2)
struct xvimage *img, *kern1, *kern2;
/* -library_def_end */

/* -library_code */
{

    int row,                            /* points image row */ 
        col,                            /* points image col */ 
        xend,                           /* step in img up to here */
        yend,                           /* step in img up to here */
        xsize,                          /* window width size */
        ysize,                          /* window height size */
        nc,                             /* column size of image */
        nr,                             /* row size of image */
        i, j;                           /* general counters */

    float  *result,                     /* pointer to resulting image float */
           *ptr,                        /* pointer to the image data */
           *mx1,                        /* pointer to the kern1 data */
           *mx2,                        /* pointer to the kern2 data */
           mdn1,                        /* auxiliary variable for matrix 1*/
           mdn2,                        /* auxiliary variable for matrix 2*/
           mdn,                         /* auxiliary variable*/
           g1,                          /* auxiliary variable */
           g2;                          /* auxiliary variable */

    if( !lvconvert(img,5,0,1,255.0,1.0,0)){
        (void)fprintf(stderr,"lvconvert: Failed (lvdiff)\n");
        return(0);
    }

    if(kern1->col_size != kern2->col_size){ 
        (void)fprintf(stderr,"lvdiff: Columns of both kernels must be equal\n");
        return(0);
    }

    if(kern1->row_size != kern2->row_size){ 
        (void)fprintf(stderr,"lvdiff: Rows of both kernels must be equal\n");
        return(0);
    }


    if(kern1->data_storage_type == VFF_TYP_4_BYTE){
        if( !lvconvert(kern1,5,0,1,255.0,1.0,0)){
            (void)fprintf(stderr,"lvconvert: Failed (lvdiff)\n");
            return(0);
        }
    }

    if(kern2->data_storage_type == VFF_TYP_4_BYTE){
        if( !lvconvert(kern2,5,0,1,255.0,1.0,0)){
            (void)fprintf(stderr,"lvconvert: Failed (lvdiff)\n");
            return(0);
        }
    }

   /* get image size */
    nr = img->col_size;
    nc = img->row_size;

   /* get kern size */
    xsize = kern1->col_size;
    ysize = kern1->row_size;;

    mdn1 = 0;
    mdn2 = 0;
    xend = nc - xsize + 1;
    yend = nr - ysize + 1;

   /* Allocate space for resulting image */ 
    result = (float *)malloc((unsigned int)nc*nr*sizeof(float));
    if(result == NULL) {
        (void) fprintf(stderr,"lvhmed: insufficient memory available\n");
        return(0);
    }

   /* Zero array for result */
    bzero((char *) result, (int) nc*nr * sizeof(float));

   /* Assign image data address to ptr */
    ptr = (float *)img->imagedata;

   /* Assign kern1 data address to mx1 */
    mx1 = (float *)kern1->imagedata;

   /* Assign kern2 data address to mx2 */
    mx2 = (float *)kern2->imagedata;

   /* perform differentiation process */
    for (row = 0 ; row < yend; row++){
        for (col = 0 ; col < xend; col++){

           /* setup the current window */
            for(i = 0; i < ysize; i++){
                for(j = 0; j < xsize; j++){

                    g1 = ptr[col + nc*(row + i) + j];
                    mdn1 +=  mx1[i*xsize + j] * g1;

                    g2 = ptr[col + nc*(row + i) + j];
                    mdn2 +=  mx2[i*xsize + j] * g2;

                }
            }

           /* assign the value to respective place */

            if(mdn1 < 0) mdn1 = -1*mdn1;
            if(mdn2 < 0) mdn2 = -1*mdn2;

            mdn = mdn1 + mdn2;
            if(mdn > 255) mdn = 255;

            result[col + 1 + nc*(row + 1)] = mdn;
            mdn1 = 0;
            mdn2 = 0;

        }
    }

    free (img->imagedata);
    img->imagedata = (char *) result;

    if( !lvconvert(img,1,0,1,255.0,1.0,0)){
        (void)fprintf(stderr,"lvconvert: Failed (lvdiff)\n");
        return(0);
    }

    return(1);
}
/* -library_code_end */
