#! /bin/csh -f

# 
#  Khoros: $Id: kdinstall_csh.csh,v 1.3 1991/12/18 08:54:35 dkhoros Exp $
#

#
# $Log: kdinstall_csh.csh,v $
# Revision 1.3  1991/12/18  08:54:35  dkhoros
# HellPatch3
#
# 

#
#*----------------------------------------------------------------------
#*
#* Copyright 1991, University of New Mexico.  All rights reserved.
#*
#* Permission to copy and modify this software and its documen-
#* tation only for internal use in your organization is hereby
#* granted, provided that this notice is retained thereon and
#* on all copies.  UNM makes no representations as too the sui-
#* tability and operability of this software for any purpose.
#* It is provided "as is" without express or implied warranty.
#* 
#* UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
#* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
#* NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
#* INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
#* SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
#* IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
#* ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
#* FORMANCE OF THIS SOFTWARE.
#* 
#* No other rights, including for example, the right to redis-
#* tribute this software and its documentation or the right to
#* prepare derivative works, are granted unless specifically
#* provided in a separate license agreement.
#*---------------------------------------------------------------------
#

#include "unmcopyright.h"	 /* Copyright 1991 by UNM */


#  >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
#  >>>>                                                       <<<<
#  >>>> file name: kdinstall_csh                              <<<<
#  >>>>                                                       <<<<
#  >>>> description: utility for de-installing khoros routines
#  >>>>                                                       <<<<
#  >>>> modifications: 					      <<<<
#  >>>>                                                       <<<<
#  >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< 

#
# ROUTINE NAME:	kdinstall_csh
# 
# AUTHORS:	Charlie Gage, Tom Sauer
# 
# DATE:		3/19/91
# 
# DESCRIPTION:	used to de-install programs from the Khoros environment 
# 
# MODIFICATIONS: Added support for toolboxes and single source.
#
#		

set noclobber
onintr cleanup
umask 002


#  Input Argument Checking
#------------------------------------------------------------
if ($#argv != 15) then
  echo ""
  echo "Invalid number of arguments detected."
  echo "Please invoke this script from the driver routine." 
  echo ""
  exit 0
endif

# Get the arguments from the driver program
#------------------------------------------------------------
set PROGRAM = $1
set DESTPATH = $2
set PROGPATH = $3
set CPATH = $4
set HPATH = $5
set LPATH = $6
set LIBHPATH = $7
set MAN1PATH = $8
set MAN3PATH = $9
set PANEPATH = $10
set HELPPATH = $11
set SUBHELPPATH = $12
set MACH = $13
set TOPSRC = $14
set FORCE = $15


# Summary of variables used in this script:
#------------------------------------------------------------
# Program requires the use of a reserved keyword - "_NULL_"
#  to represent any NULL or empty arguments passed in.
#
# Input Variables to kdinstall
#  PROGRAM    -  specifies the name of the program to deinstall
#  DESTPATH   -  specifies the path to the destination directory
#  PROGPATH   -  specifies the path to the src subdirectory
#  CPATH      -  specifies the path to the C driver file
#  HPATH      -  specifies the path to the include file
#  LPATH      -  specifies the path for the library file (optional)
#  LIBHPATH   -  specifies the path to the library include file (optional)
#  MAN1PATH   -  specifies the path for the man1 file
#  MAN3PATH   -  specifies the path for the man3 file (optional)
#  PANEPATH   -  specifies the path for the .pane file
#  HELPPATH   -  specifies the path to the cantata online manpages
#  SUBHELPPATH -  specifies the path to the Overview.doc file
#  MACH       -  specifies the path to the mach file
#  TOPSRC     -  specifies the top of src as indicated in the *.conf file
#  FORCE      -  specifies whether to override the overwrite prompts
#
#
# Variables used in the script:
#  KHOROS_HOME - environment variable
#
# Optional variables will have "_NULL_" passed in to them if no
#  path is specified.

# Set up environment variables
#----------------------------------------------------
if (! $?KHOROS_HOME) then
   echo ""
   echo "kdinstall: Error, need KHOROS_HOME "
   echo "          environment variable set to proceed."
   echo ""
   exit 0
endif

# Set the PATH for the user
set path = ( . $KHOROS_HOME/bin $path /usr/local/bin /usr/ucb \
             /usr/bin /bin /usr/local/etc/ /usr/etc /etc )


set FULLHOST = `hostname`

#  Get the proper mach file
#---------------------------------------------------------------
if ($MACH == "_NULL_") then
    if (-f $KHOROS_HOME/repos/config/src_conf/default_mach.{$FULLHOST}) then
       set MACH = $KHOROS_HOME/repos/config/src_conf/default_mach.{$FULLHOST}
    else if (-f $KHOROS_HOME/repos/config/src_conf/default_mach) then
	set MACH = $KHOROS_HOME/repos/config/src_conf/default_mach
    else
        echo ""
        echo "kdinstall: The mach_def file does not exist"
        echo " Since you are insatlling in KHOROS_HOME, please"
        echo " create the file $KHOROS_HOME/repos/config/src_conf/default_mach"
        echo " For more information please Khoros Manual Vol 1, Ch. 9"
        echo ""
        exit 1
    endif
else if (-f $MACH.{$FULLHOST} ) then
        set MACH = $MACH.{$FULLHOST}
    else if (! -f $MACH ) then
           echo ""
           echo "kinstall: Error, the mach file '$MACH' for the toolbox"
           echo "specified was not found. Please create the mach file"
           echo "$MACH"
           echo ""
           exit 1
    endif
endif

# source the mach file determined in the chaos above
source $MACH

# Determine the relative path to src from the TOPSRC parameter
#  from the *.conf file.  Also check read/write permissions.
#--------------------------------------------------------------
@ count = 1
set iflag = 0

foreach i ( $PROGPATH $CPATH $HPATH $LPATH )
  if ($TOPSRC == "_NULL_") then
     if (-e $LOCAL_SRC_TOP/$i) then
        if (! -r $LOCAL_SRC_TOP/$i ) then
	  echo "Cannot access $LOCAL_SRC_TOP/$i for reading! Exiting..."
	  goto cleanup
	endif
        set iflag = 1
     else
        # Try to get a relative path.
        #  This only works if i has the initial part of the path
        #  in common with LOCAL_SRC_TOP
        set RELPATH = `echo $i | sed -e "s|$LOCAL_SRC_TOP/||"`
        if (-e $LOCAL_SRC_TOP/$RELPATH) then
           if (! -r $LOCAL_SRC_TOP/$RELPATH ) then
	       echo "Cannot access $LOCAL_SRC_TOP/$RELPATH for reading! Exiting..."
	       goto cleanup
           endif
           if ($count == 1) then
              set REL_PROGPATH = $RELPATH
           endif
        else
           echo ""
           echo "Invalid path detected in config file."
           echo "The following path was constructed from the LOCAL_SRC_TOP"
           echo " parameter and the relative path between topsrc and the src"
           echo " paths specified in the config file."
           echo " Path:  $LOCAL_SRC_TOP/$RELPATH "
           echo ""
           echo "A complete, valid path must be supplied."
           echo " An example of a configuration file can be found in,"
           echo " $KHOROS_HOME/repos/config/src_conf/TEMPLATE.conf"
           echo ""
           echo "Please check config file."
           echo ""
           goto cleanup
        endif
     endif
 else
     if ( -e $LOCAL_SRC_TOP/$i ) then
        if (! -r $LOCAL_SRC_TOP/$i ) then
          echo "Cannot access $LOCAL_SRC_TOP/$i for reading! Exiting..."
          goto cleanup
	endif
        set iflag = 1
     else
        if (! -d $TOPSRC) then
           echo ""
           echo "Invalid or incomplete path specified for"
           echo " topsrc parameter in config file."
           echo " Path: $TOPSRC"
           echo ""
           goto cleanup
        endif
        if ($i == $TOPSRC) then
           set RELPATH = ""
        else
           set RELPATH = `echo $i | sed -e "s|$TOPSRC/||"`
        endif
        if (-e $LOCAL_SRC_TOP/$RELPATH) then
          if (! -r $LOCAL_SRC_TOP/$RELPATH ) then
	      echo "Cannot access $LOCAL_SRC_TOP/$RELPATH for reading! Exiting..."
	      goto cleanup
	  endif
          if ($count == 1) then
             set REL_PROGPATH = $RELPATH
          endif
        else
          echo ""
          echo "Invalid path detected in config file."
          echo "The following path was constructed from the LOCAL_SRC_TOP"
          echo " parameter and the relative path between topsrc and the src"
          echo " paths specified in the config file."
          echo " Path:  $LOCAL_SRC_TOP/$RELPATH"
          echo ""
          echo "A complete, valid path must be supplied."
          echo " Please specify either a full path to each of the src locations"
          echo " in the config file, or use a combination of the topsrc path"
          echo " and each src path in config file to comprise a full path."
          echo ""
          echo "Please check config file."
          echo ""
          goto cleanup
        endif
     endif
  endif
@ count++
end

if ($iflag) then
   set PROGPATH = $LOCAL_SRC_TOP/$PROGPATH
   set LPATH = $LOCAL_SRC_TOP/$LPATH
else
   set PROGPATH = $LOCAL_SRC_TOP/$REL_PROGPATH
   set LPATH = $LOCAL_SRC_TOP/$RELPATH
endif

if (! -d $DESTPATH) then
   echo ""
   echo "Destination path: "
   echo "$DESTPATH "
   echo " does not exist."
   echo ""
   echo "Create $DESTPATH ? (y/n) [y]: "
   set continue_flg = $<
      if ($continue_flg == 'n') then
          echo "exiting ..."
          goto cleanup
      else
          echo "creating directory $DESTPATH"
          mkdir $DESTPATH
      endif
else if (-d $DESTPATH && ! -w $DESTPATH) then
   echo ""
   echo "kdinstall:"
   echo "Unable to access $DESTPATH for writing."
   echo ""
   echo "Please check permissions in $DESTPATH"
   echo " exiting ..."
   echo ""
   goto cleanup
endif

# check other parameters in config file, and make sure they 
#  are valid paths and directories.
#--------------------------------------------------------------
  foreach i ( $MAN1PATH $MAN3PATH $PROGPATH $PANEPATH $LPATH $LIBHPATH )
     if (-e $i && -d $i ) then
        if (! -r $i ) then
           echo "Cannot access $i for reading! Exiting..."
           goto cleanup
        endif
     endif
  end

# Print out the paths where the source will be placed and ask user to
# continue with the deinstall
#    

   if (! -e $LPATH) then
      echo "kdinstall:"
      echo -n "kdinstall: ERROR; kdinstall cannot access"
      echo " the directory: $LPATH"
      echo ""
      goto cleanup
   endif

   if (! -e $PROGPATH) then
      echo "kdinstall:"
      echo -n "kdinstall: ERROR; kdinstall cannot access"
      echo " the directory: $PROGPATH"
      echo ""
      echo "You must have specified somthing wrong on the command line or"
      echo " the directory $PROGPATH does not exist"
      echo ""
      goto cleanup
   endif

    echo ""
    echo "Library source location: $LPATH"
    echo "Driver source location : $PROGPATH"
    echo ""
    echo "kdinstall will copy all files to the following location:"
    echo "  $DESTPATH"
    echo ""
    echo -n "kdinstall: Do you wish to continue? (y/n) [y]: "
    set continue_flg = $<
    echo ""

    if ($continue_flg == 'n') goto cleanup


# Check to see that KHOROS_USER was sourced from mach file
#-----------------------------------------------------
if ($KHOROS_USER == "") then
   echo ""
   echo "kdinstall: KHOROS_USER environment variable not set."
   echo " Please check your mach file for this variable."
   echo ""
   goto cleanup
endif

if ($LIBHPATH:t == l$PROGRAM.h) then
    LIBHPATH = $LIBHPATH:h
endif

# copy library header file to DESTPATH 
#-----------------------------------------------------
    if ( -e $LIBHPATH/l$PROGRAM.h ) then
       echo ""
       echo "Copying library header..."
       echo " from: $LIBHPATH"
       echo " to: $DESTPATH"
       echo ""
       if ($FORCE) then
         \cp $LIBHPATH/l$PROGRAM.h $DESTPATH
       else
         \cp -i $LIBHPATH/l$PROGRAM.h $DESTPATH
       endif
    endif

# copy library source files 
#----------------------------------------------------------------
    foreach i ($LPATH/l$PROGRAM.c $LPATH/l$PROGRAM.f)
      if (-e $i) then
         echo ""
         echo "Copying library source..."
         echo " from: $LPATH"
         echo " to: $DESTPATH"
         echo ""
         if ($FORCE) then
            \cp $i $DESTPATH
         else
            \cp -i $i $DESTPATH
         endif
      endif
    end

# copy man pages 
#------------------------------------------------------
    if (-e $MAN1PATH/$PROGRAM.1) then
       echo ""
       echo "Copying man pages..."
       echo " from: $MAN1PATH"
       echo " to: $DESTPATH"
       echo ""
       if ($FORCE) then
          \cp $MAN1PATH/$PROGRAM.1 $DESTPATH
       else
          \cp -i $MAN1PATH/$PROGRAM.1 $DESTPATH
       endif
    endif
    if (-e $MAN3PATH/l$PROGRAM.3) then
       if ($FORCE) then
          \cp $MAN3PATH/l$PROGRAM.3 $DESTPATH
       else
          \cp -i $MAN3PATH/l$PROGRAM.3 $DESTPATH
       endif
    endif

# copy cantata pane to DESTPATH
#-----------------------------------------------------
    if (-e $PANEPATH/$PROGRAM.pane) then
       echo ""
       echo "copying cantata pane..."
       echo " from: $PANEPATH"
       echo " to: $DESTPATH"
       echo ""
       if ($FORCE) then
         \cp $PANEPATH/$PROGRAM.pane $DESTPATH
       else
         \cp -i $PANEPATH/$PROGRAM.pane $DESTPATH
       endif
    endif


# copy the source files to DESTPATH
#------------------------------------------------------
    echo ""
    echo "copying driver source files..."
    echo " from:$PROGPATH"
    echo " to: $DESTPATH"
    echo ""
    foreach i ($PROGRAM.c $PROGRAM.h $PROGRAM.prog $PROGRAM.conf ghost.ans)
      if (-e $PROGPATH/$i) then
         if ($FORCE) then
            \cp $PROGPATH/$i $DESTPATH
         else
            \cp -i $PROGPATH/$i $DESTPATH
         endif
      endif
    end

    echo ""
    echo ""
    echo "<<<<<<<<<<<<<<<<<<<   >>>>>>>>>>>>>>>>>>>"
    echo ""
    echo "De-installation of $PROGRAM completed."
    echo ""
    echo "NOTE: you may want to check the ghost.ans"
    echo " before reghosting $PROGRAM."
    echo "<<<<<<<<<<<<<<<<<<<   >>>>>>>>>>>>>>>>>>>"
    echo ""
    echo ""

# End of kdinstall script, finish by executing cleanup.

cleanup:
# cleanup by unsetting variables.
#------------------------------------------------------------------
unset KHOROS_USER
unset KHOROS_MACHINES
unset KHOROS_MACH_DIR
unset KHOROS_SRC_TOP
unset LOCAL_SRC_TOP

exit 0        # normal exit

