 /*
  * Khoros: $Id: msvd.c,v 1.2 1992/03/20 23:44:07 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: msvd.c,v 1.2 1992/03/20 23:44:07 dkhoros Exp $";
#endif

 /*
  * $Log: msvd.c,v $
 * Revision 1.2  1992/03/20  23:44:07  dkhoros
 * VirtualPatch5
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1992, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1992 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: msvd.c
 >>>>
 >>>>      Program Name: msvd
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	compute the Singular Value Decomposition of a matrix
 >>>>	
 >>>>	

 >>>>            Author: Jeremy Worley
 >>>>
 >>>> Date Last Updated: Tue Feb 25 01:00:40 1992
 >>>>
 >>>>          Routines: main- the main program for msvd
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "msvd.h"


/****************************************************************
 *
 * Routine Name:  main program for msvd
 *
 *       Input:  
 *      -i  input image (image) 
 *
 *
 *      [-o1] resulting U output image (image)
 *      [-o2] resulting S output image (image)
 *      [-o3] resulting V output image (image)
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
struct xvimage *image,*simage,*vimage,*createimage();
int     type;
char    *comment = "no comment...";
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
  if (check_args()) exit(1);

  if((image = readimage(msvd->i_file))==NULL){
     (void)fprintf(stderr,"%s:  failed call to readimage()\n",
             program);
     exit(1);
  }

  (void)proper_num_images(program,image,1,TRUE);

  if(image->row_size<=0 || image->col_size<=0){
     (void)fprintf(stderr,"%s:  matrix dimensions cannot be zero.\n",program);
     exit(1);
  }

/*
** create the images 
*/

      simage = createimage(0,0,image->data_storage_type,1,1,comment,
                           (unsigned long)0, /* map_row_size */
                           (unsigned long)0, /* map_col_size */
                           (unsigned long)VFF_MS_NONE,
                           (unsigned long)VFF_MAPTYP_NONE,
                           (unsigned long)VFF_LOC_IMPLICIT,
                           (unsigned long)0);/* location dimension */

      vimage = createimage(0,0,image->data_storage_type,1,1,comment,
                           (unsigned long)0, /* map_row_size */
                           (unsigned long)0, /* map_col_size */
                           (unsigned long)VFF_MS_NONE,
                           (unsigned long)VFF_MAPTYP_NONE,
                           (unsigned long)VFF_LOC_IMPLICIT,
                           (unsigned long)0);/* location dimension */
/* -main_before_lib_call_end */

/* -main_library_call */
  if(!lmsvd(image,simage,vimage)) {
     (void)fprintf(stderr, "%s: lmsvd failed\n",program);
     exit(1);
  }
/* -main_library_call_end */

/* -main_after_lib_call */
  if(msvd->o1_flag){
     if(!(writeimage(msvd->o1_file,image))){
        (void)fprintf(stderr,"%s:  failed call to writeimage()",
              program);
        exit(1);
     }
  }
  if(msvd->o2_flag){
     if(!(writeimage(msvd->o2_file,simage))){
        (void)fprintf(stderr,"%s:  failed call to writeimage()",
              program);
        exit(1);
     }
  }
  if(msvd->o3_flag){
     if(!(writeimage(msvd->o3_file,vimage))){
        (void)fprintf(stderr,"%s:  failed call to writeimage()\n",
              program);
        exit(1);
     }
  }
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for msvd 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "msvd :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tcompute the Singular Value Decomposition of a matrix\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i  input image (image)  (infile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-o1]  resulting U output image (image) (outfile) [null]\n");
	fprintf(stderr,"\t[-o2]  resulting S output image (image) (outfile) [null]\n");
	fprintf(stderr,"\t[-o3]  resulting V output image (image) (outfile) [null]\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for msvd\n");
	fprintf(stderr, "\t[-U] Gives the usage for msvd\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called msvd.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses msvd.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for msvd
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i_pstr = 
	"\nEnter: (i) input image (image) \n        {infile}: "; 
char	*o1_pstr = 
	"\nEnter: (o1) resulting U output image (image) \n        {outfile}: "; 
char	*o2_pstr = 
	"\nEnter: (o2) resulting S output image (image) \n        {outfile}: "; 
char	*o3_pstr = 
	"\nEnter: (o3) resulting V output image (image) \n        {outfile}: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "msvd", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "msvd.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "msvd: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "msvd.ans");
		}

	     }

	}

	/*
	 * allocate the msvd structure
	 */
	msvd = (msvd_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (msvd_struct));

	/*
	 * get required arguments for msvd
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(msvd->i_flag = vget_infile(fid, prompt_flag,
			"-i", i_pstr, &(msvd->i_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(msvd->i_flag))
		{
		    fprintf(stderr, "\t\ti is required, please re-enter: \n");
		    msvd->i_flag = vget_infile(fid, prompt_flag,
		    "-i", i_pstr, &(msvd->i_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for msvd
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	msvd->o1_flag = vget_outfile(fid, prompt_flag,
	"-o1", o1_pstr, &(msvd->o1_file))
;

	msvd->o2_flag = vget_outfile(fid, prompt_flag,
	"-o2", o2_pstr, &(msvd->o2_file))
;

	msvd->o3_flag = vget_outfile(fid, prompt_flag,
	"-o3", o3_pstr, &(msvd->o3_file))
;


}



