 /*
  * Khoros: $Id: fits2viff.c,v 1.1 1991/05/10 15:52:54 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: fits2viff.c,v 1.1 1991/05/10 15:52:54 khoros Exp $";
#endif

 /*
  * $Log: fits2viff.c,v $
 * Revision 1.1  1991/05/10  15:52:54  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: fits2viff.c
 >>>>
 >>>>      Program Name: fits2viff
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Converts a FITS file format to the VIFF image file format.
 >>>>	
 >>>>	
 >>>>            Author: Robin Corbet, PSU
 >>>>
 >>>> Date Last Updated: Sat Mar  2 14:27:48 1991
 >>>>
 >>>>          Routines: main- the main program for fits2viff
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "fits2viff.h"


/****************************************************************
 *
 * Routine Name:  main program for fits2viff
 *
 *       Input:  
 *           -i  input FITS data file 
 *           -o  resulting output image (viff file) 
 *           -c  lets user chose color space model
 *		0 (no model),
 *		1 (choose ntscRGB model),
 *		15 (choose genericRGB model),
 *		7 (choose cieRGB model),
 *		2 (choose ntscCMY model),
 *		3 (choose ntscYIQ model),
 *		4 (choose HSV model),
 *		5 (choose HLS model),
 *		6 (choose IHS model),
 *		8 (choose cieXYZ model),
 *		9 (choose cieUVW model),
 *		10 (choose cieucsUVW model),
 *		11 (choose cieucsSOW model),
 *		12 (choose cieucsLab model),
 *		or 14 (choose GENERIC model)
 *		 
 *
 *
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
struct xvimage *viff_image;
struct fits *read_fits(), *fits_image;
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
    if (check_args()) exit(1);

    READINPUT (fits_image);
/* -main_before_lib_call_end */

/* -main_library_call */
    if (!lfits2viff (fits_image, &viff_image, fits2viff->c_toggle)) {
        (void) fprintf (stderr, "lfits2viff Failed\n");
        exit (1);
    }
/* -main_library_call_end */

/* -main_after_lib_call */
    writeimage (fits2viff->o_file, viff_image);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for fits2viff 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "fits2viff :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tConverts a FITS file format to the VIFF image file format.\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i  input FITS data file  (infile)\n");
	fprintf(stderr,"\t-o  resulting output image (viff file)  (outfile)\n");
	fprintf(stderr, "\t-c  ");
	fprintf(stderr, "lets user chose color space model\n  ");
	fprintf(stderr, "\t\t0  (no model),\n");
	fprintf(stderr, "\t\t1  (choose ntscRGB model),\n");
	fprintf(stderr, "\t\t15  (choose genericRGB model),\n");
	fprintf(stderr, "\t\t7  (choose cieRGB model),\n");
	fprintf(stderr, "\t\t2  (choose ntscCMY model),\n");
	fprintf(stderr, "\t\t3  (choose ntscYIQ model),\n");
	fprintf(stderr, "\t\t4  (choose HSV model),\n");
	fprintf(stderr, "\t\t5  (choose HLS model),\n");
	fprintf(stderr, "\t\t6  (choose IHS model),\n");
	fprintf(stderr, "\t\t8  (choose cieXYZ model),\n");
	fprintf(stderr, "\t\t9  (choose cieUVW model),\n");
	fprintf(stderr, "\t\t10  (choose cieucsUVW model),\n");
	fprintf(stderr, "\t\t11  (choose cieucsSOW model),\n");
	fprintf(stderr, "\t\t12  (choose cieucsLab model),\n");
	fprintf(stderr, "\t\tor 14  (choose GENERIC model)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for fits2viff\n");
	fprintf(stderr, "\t[-U] Gives the usage for fits2viff\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called fits2viff.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses fits2viff.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for fits2viff
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i_pstr = 
	"\nEnter: (i) input FITS data file \n        {infile}: "; 
char	*o_pstr = 
	"\nEnter: (o) resulting output image (viff file) \n        {outfile}: "; 
char	*c_pstr = "\nEnter: (c) lets user chose color space model -- \n      \t\t0 (no model)\n\t\t1 (choose ntscRGB model)\n\t\t15 (choose genericRGB model)\n\t\t7 (choose cieRGB model)\n\t\t2 (choose ntscCMY model)\n\t\t3 (choose ntscYIQ model)\n\t\t4 (choose HSV model)\n\t\t5 (choose HLS model)\n\t\t6 (choose IHS model)\n\t\t8 (choose cieXYZ model)\n\t\t9 (choose cieUVW model)\n\t\t10 (choose cieucsUVW model)\n\t\t11 (choose cieucsSOW model)\n\t\t12 (choose cieucsLab model)\n\t\tor 14 (choose GENERIC model)\n     : "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "fits2viff", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "fits2viff.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "fits2viff: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "fits2viff.ans");
		}

	     }

	}

	/*
	 * allocate the fits2viff structure
	 */
	fits2viff = (fits2viff_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (fits2viff_struct));

	/*
	 * get required arguments for fits2viff
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(fits2viff->i_flag = vget_infile(fid, prompt_flag,
			"-i", i_pstr, &(fits2viff->i_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(fits2viff->i_flag))
		{
		    fprintf(stderr, "\t\ti is required, please re-enter: \n");
		    fits2viff->i_flag = vget_infile(fid, prompt_flag,
		    "-i", i_pstr, &(fits2viff->i_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(fits2viff->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(fits2viff->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(fits2viff->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    fits2viff->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(fits2viff->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}


	/*
	 * get required toggles for fits2viff
	 */
	if (prompt_flag == TRUE)
	{
	    ok = FALSE;
	    while(!ok)
	    {
		fits2viff->c_flag = vget_int(fid, prompt_flag,
		"-c", c_pstr, &(fits2viff->c_toggle),
		0, 0, 0);

		if (((fits2viff->c_toggle == 0 ) || 
		     (fits2viff->c_toggle == 1 ) || 
		     (fits2viff->c_toggle == 15 ) || 
		     (fits2viff->c_toggle == 7 ) || 
		     (fits2viff->c_toggle == 2 ) || 
		     (fits2viff->c_toggle == 3 ) || 
		     (fits2viff->c_toggle == 4 ) || 
		     (fits2viff->c_toggle == 5 ) || 
		     (fits2viff->c_toggle == 6 ) || 
		     (fits2viff->c_toggle == 8 ) || 
		     (fits2viff->c_toggle == 9 ) || 
		     (fits2viff->c_toggle == 10 ) || 
		     (fits2viff->c_toggle == 11 ) || 
		     (fits2viff->c_toggle == 12 ) || 
		     (fits2viff->c_toggle == 14 )) &&
		     (fits2viff->c_flag))
		      ok = TRUE;
		else
		{
		    fprintf(stderr, "\nc is a required argument.\n");
		}
	    }
	}
	else
	{
		fits2viff->c_flag = vget_int(fid, prompt_flag,
		"-c", c_pstr, &(fits2viff->c_toggle),
		0, 0, 0);

		if (((fits2viff->c_toggle != 0 ) && 
		     (fits2viff->c_toggle != 1 ) && 
		     (fits2viff->c_toggle != 15 ) && 
		     (fits2viff->c_toggle != 7 ) && 
		     (fits2viff->c_toggle != 2 ) && 
		     (fits2viff->c_toggle != 3 ) && 
		     (fits2viff->c_toggle != 4 ) && 
		     (fits2viff->c_toggle != 5 ) && 
		     (fits2viff->c_toggle != 6 ) && 
		     (fits2viff->c_toggle != 8 ) && 
		     (fits2viff->c_toggle != 9 ) && 
		     (fits2viff->c_toggle != 10 ) && 
		     (fits2viff->c_toggle != 11 ) && 
		     (fits2viff->c_toggle != 12 ) && 
		     (fits2viff->c_toggle != 14 )) ||
		     (!(fits2viff->c_flag)))
		{
		    fprintf(stderr, "c is a required argument.\n");
		    fprintf(stderr, "\n");
		    gw_usage();
		    exit(0);
		}
	}


}



