 /*
  * Khoros: $Id: lviff2xbm.c,v 1.1 1991/05/10 15:43:29 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: lviff2xbm.c,v 1.1 1991/05/10 15:43:29 khoros Exp $";
#endif

 /*
  * $Log: lviff2xbm.c,v $
 * Revision 1.1  1991/05/10  15:43:29  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: lviff2xbm.c
 >>>>
 >>>>      Program Name: viff2xbm
 >>>>
 >>>> Date Last Updated: Thu Apr  4 17:36:33 1991 
 >>>>
 >>>>          Routines: lviff2xbm - the library call for viff2xbm
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vinclude.h"


/* -library_includes */
/* -library_includes_end */


/****************************************************************
*
* Routine Name: lviff2xbm - library call for viff2xbm
*
* Purpose:
*    
*    Converts an Khoros (viff) bitmap file to an X11 bitmap  file
*    (xbm).
*    
*    
* Input:
*    
*         FILE *file: will contain the X11 bitmap file
*    
*         struct xvimage *image: xvimage to convert
*    
*         char *xbmname: string (description name)
*    
*         int photo_neg: logical, photonegative(0) photopositive(1)
*    
*    
* Output:
*    
*    
*
* Written By: Mark Young, Mike Lang
*    
*    Ghosted by Pascal ADAM 14-JUNE-90
*    
*    
****************************************************************/


/* -library_def */
int
lviff2xbm(file, image, xbmname, photo_neg)

FILE           *file;
struct xvimage *image;
char           *xbmname;
int            photo_neg;
/* -library_def_end */

/* -library_code */
{
        int      i, j, b, row, col;
        char     name[LENGTH];
        unsigned char *imgdata;


        row = (image->row_size + 7)/8;
        col = image->col_size;

        if (photo_neg)
        {
           imgdata = (unsigned char *) image->imagedata;
           for (i = 0; i < row*col; i++)
           {
              *imgdata = ~(*imgdata);
              imgdata++;
           }
        }
        imgdata = (unsigned char *) image->imagedata;

        for (b = 0; b < image->num_data_bands; b++)
        {
           if (image->num_data_bands == 1)
              (void) sprintf(name,"%s", xbmname);
           else
              (void) sprintf(name,"%s%d", xbmname, b+1);

           fprintf(file, "#define %s_width   %d\n", name, image->row_size);
           fprintf(file, "#define %s_height  %d\n", name, image->col_size);

           fprintf(file, "static char %s_bits[] = {\n", name);
           for (j = 0; j < col; j++)
           {
              fprintf(file, "\t");
              for (i = 0; i < row; i++)
              {
                 fprintf(file, "0x%1x, ", *imgdata++);
              }
              fprintf(file, "\n");
           }
           fprintf(file, "};\n\n");
        }
        return(TRUE);
}
/* -library_code_end */
