 /*
  * Khoros: $Id: lviff2raw.c,v 1.2 1991/12/18 09:50:09 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: lviff2raw.c,v 1.2 1991/12/18 09:50:09 dkhoros Exp $";
#endif

 /*
  * $Log: lviff2raw.c,v $
 * Revision 1.2  1991/12/18  09:50:09  dkhoros
 * HellPatch3
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: lviff2raw.c
 >>>>
 >>>>      Program Name: viff2raw
 >>>>
 >>>> Date Last Updated: Thu Mar  7 16:32:41 1991 
 >>>>
 >>>>          Routines: lviff2raw - the library call for viff2raw
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vinclude.h"


/* -library_includes */
/* -library_includes_end */


/****************************************************************
*
* Routine Name: lviff2raw - library call for viff2raw
*
* Purpose:
*    
*    Convert a Khoros image to raw binary data
*    
*    
* Input:
*    
*         image - pointer to image to be written out
*    
*         ofile - file descriptor for output file
*    
*    
* Output:
*    
*         Raw binary data is written to the output  file.   Note  that
*         the  Khoros  header  is  no longer present so you'll have to
*         keep track of the image properties yourself!
*    
*    
*
* Written By: Mark Young
*    
*    John Rasure Sat Mar 25 18:28:22 MST 1989 brought up  todate  with
*    new xviff
*    
*    Pascal Adam Fri Jun 15 10:27:24 MDT 1990  Ghosting,  Change  name
*    from vxvtoraw to viff2raw.
*    
*    
****************************************************************/


/* -library_def */
int
lviff2raw(image,filename)
struct xvimage *image;
char *filename;
/* -library_def_end */

/* -library_code */
{
    int rows,cols,k;
    int ofile;

    if ( (ofile = kopen(filename, O_WRONLY|O_TRUNC|O_CREAT,0664)) < 0)
      {
        fprintf(stderr,"lviff2raw: Unable to access output file %s\n",filename);
        return(0);
      }

    rows = image->col_size;
    cols = image->row_size;
    k = -1;
    switch (image->data_storage_type)
      {
        case VFF_TYP_BIT:
          k = kwrite(ofile,image->imagedata,((cols+7)/8)*rows);
          break;
        case VFF_TYP_1_BYTE:
          k = kwrite(ofile,image->imagedata,rows*cols);
          break;
        case VFF_TYP_2_BYTE:
          k = kwrite(ofile,image->imagedata,rows*cols*sizeof(short));
          break;
        case VFF_TYP_4_BYTE:
          k = kwrite(ofile,image->imagedata,rows*cols*sizeof(int));
          break;
        case VFF_TYP_FLOAT:
          k = kwrite(ofile,image->imagedata,rows*cols*sizeof(float));
          break;
        case VFF_TYP_COMPLEX:
          k = kwrite(ofile,image->imagedata,rows*cols*sizeof(float)*2);
          break;
        default:
          fprintf(stderr,
                  "viff2raw: Unknown data storage type: %d\n",
                  image->data_storage_type);
          break;
      }
    kclose(ofile);
    if (k < 0) return(0);
    else return(1);
 
  }
/* -library_code_end */
