 /*
  * Khoros: $Id: lfits2viff.c,v 1.1 1991/05/10 15:43:29 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: lfits2viff.c,v 1.1 1991/05/10 15:43:29 khoros Exp $";
#endif

 /*
  * $Log: lfits2viff.c,v $
 * Revision 1.1  1991/05/10  15:43:29  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: lfits2viff.c
 >>>>
 >>>>      Program Name: fits2viff
 >>>>
 >>>> Date Last Updated: Sat Mar  2 14:27:49 1991 
 >>>>
 >>>>          Routines: lfits2viff - the library call for fits2viff
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vinclude.h"


/* -library_includes */
#include "file_formats/fits.h"
/* -library_includes_end */


/****************************************************************
*
* Routine Name: lfits2viff - library call for fits2viff
*
* Purpose:
*    
*    Converts a FITS file format to the VIFF image file format.
*    
*    
* Input:
*    
*         struct  fits *fits_image - pointer to fits image
*         struct  xvimage **viff_image - pointer to a  pointer  of  an
*         VIFF image file format.
*         int color_model - the color space  model  specified  by  the
*         user.
*    
*    
* Output:
*    
*         struct  xvimage **viff_image - malloced and copied imagedata
*         for VIFF image
*    
*    
*
* Written By: Robin Corbet, PSU
*    
*    7-Dec-90 Scott Wilson - A little cleaning up
*    
*    
****************************************************************/


/* -library_def */
int lfits2viff(fits_image, viff_image, color_model)

struct  fits *fits_image;
struct  xvimage **viff_image;
int color_model;
/* -library_def_end */

/* -library_code */
{

        struct xvimage *img, *createimage();
        char           *program = "lfits2viff";
        char           *fits_ptr, *img_ptr;

        int             nr, nc;
        int             bands;
        int             i, j, bytepix;
        int             data_type;

        nc = (int) fits_image->naxis1;
        nr = (int) fits_image->naxis2;

        bands = (int) fits_image->naxis3;
        if (bands == 0) bands = 1;

        bytepix = fits_image->bitpix/8;
        switch (bytepix) {
        case 4:
                data_type = VFF_TYP_4_BYTE;
                break;
        case 2:
                data_type = VFF_TYP_2_BYTE;
                break;
        case 1:
                data_type = VFF_TYP_1_BYTE;
                break;
        default:
                fprintf(stderr, "%d : BITPIX not supported\n",                                          fits_image->bitpix);
                return (0);
                break;
        }


    /* get space for new image and fill in the header info */

   img = createimage(   (unsigned long) nr,              /* number of rows */
                        (unsigned long) nc,              /* number of columns */
                        (unsigned long) data_type,       /* data_storage_type */
                        (unsigned long) 1,               /* num_of_images */
                        (unsigned long) bands,           /* num_data_bands */
                        fits_image->title,               /* comment */
                        (unsigned long) 0,               /* map_row_size */
                        (unsigned long) 0,               /* map_col_size */
                        (unsigned long) VFF_MS_NONE,     /* map_scheme */
                        (unsigned long) VFF_MAPTYP_NONE, /* map_storage_type */
                        (unsigned long) VFF_LOC_IMPLICIT, /* location_type */
                        (unsigned long) 0);               /* dimension */

   *viff_image = img;
   if ( img == NULL )
   {
       (void)fprintf(stderr,"%s: Unable to allocate new image!\n",program);
       return(0);
   }

   /* load the data according to the VIFF format.  */
   fits_ptr = fits_image->imagedata;
   img_ptr = img->imagedata; 
   for (i=0; i< nr*bytepix*bands; i++)
     for (j=0; j<nc; j++)
       img_ptr[i*nc+j] = *fits_ptr++;

    /* set the color space model as the user specified */

    set_color_space_model(img, color_model); 
    return(1);
}
/* -library_code_end */
