 /*
  * Khoros: $Id: elas.c,v 1.2 1991/12/18 09:49:11 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: elas.c,v 1.2 1991/12/18 09:49:11 dkhoros Exp $";
#endif

 /*
  * $Log: elas.c,v $
 * Revision 1.2  1991/12/18  09:49:11  dkhoros
 * HellPatch3
 *
  */ 


/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.

 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 *
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 *
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"       /* Copyright 1990 by UNM */
#include "vinclude.h"	 
#include "file_formats/elas.h"

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>     file name: elas.c                                 <<<<
   >>>>                                                       <<<<
   >>>>   description: utilities to open and read elas images <<<<
   >>>>                                                       <<<<
   >>>>      routines: open_elas()                            <<<<
   >>>>                read_elas_line()                       <<<<
   >>>>                                                       <<<<
   >>>> modifications:                                        <<<<
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */

/*
*
# SPEICAL NOTE:
*
# DATE:		2/4/91
# 
# DESCRIPTION:	utilities for elas2viff
# 
# MODIFICATIONS:
# 
# ROUTINES:	functions()
#
#	1. The not define flag
#		This routine can be compiled so that it is not machine dependent
#		by using -DNMD option. NMD stands for not machine dependent.
#		When compiled with this option the bigendian to litendian 
#		conversion is not performed.
#	2. defines for machine dependencies
#		The defines for machine dependencies 
#		(conversion to and from bigendian)
#		are sun, bigendian, and ieeeorder. So elas.c can be compiled
#		with -Dbigendian. Note, when compiling on a sun machine, sun is
#		defined so the conversion code from bigendian to litendian will 
#		be compiled. If it is unwanted see 1. above.
#		
*/

/**************************************************************
*
* MODULE NAME:  open_elas
*
*     PURPOSE:  Opens an ELAS image file for reading from disk.
*
*       INPUT:  char *filename - file name
*               int fid - file descriptor of elas image
*
*      OUTPUT:
*
* ROUTINES CALLED: block_read() - to read in header info.
*
**************************************************************/

ELAS *
open_elas(filename, fid)
char *filename;
int *fid;

{
  ELAS *elas_hdr;
  unsigned long type;
  int numread, headersize;

  *fid = kopen(filename, O_RDONLY);
  if (*fid < 0)
  {
    (void)fprintf(stderr,"open_elas: unable to open file %s\n",
                  filename);
    return(NULL);
  }

    /* Get space for ELAS header structure */

  elas_hdr = (ELAS *)malloc(sizeof(ELAS));
  if (elas_hdr == NULL)
  {
    (void) fprintf(stderr,"open_elas: Not enough memory ");
    (void) fprintf(stderr,"for image header\n");
    kclose(*fid);
    return(NULL);
  }

   /* Make sure header of elas image is valid */
   /* compute size of the header, and read header */

  headersize = sizeof(ELAS) - sizeof(char *);
  numread = block_read(*fid, elas_hdr, headersize);
  if (numread != headersize)
  {
    (void) fprintf(stderr,"open_elas: Incorrect header byte count: ");
    (void) fprintf(stderr,"found %d, should be %d\n", numread, headersize);
    (void) fprintf(stderr,"Possible invalid input or an empty file\n");
    free(elas_hdr);
    kclose(*fid);
    return(NULL);
  }

    /* May have to do byte swapping to read header info,
     * if in big endian then swap bytes.
     */

   type = machtype(NULL);
   if (type != VFF_DEP_NSORDER)
   {
     nstoieeel(&elas_hdr->num_hdr_bytes);
     nstoieeel(&elas_hdr->num_bytes_record);
     nstoieeel(&elas_hdr->init_line);
     nstoieeel(&elas_hdr->last_line);
     nstoieeel(&elas_hdr->init_elem_scan_line);
     nstoieeel(&elas_hdr->last_elem_scan_line);
     nstoieeel(&elas_hdr->num_channels);
     nstoieeel(&elas_hdr->header_id);
     nstoieeel(&elas_hdr->y_offset);
     nstoieeel(&elas_hdr->x_offset);
     nstoieeef(&elas_hdr->y_spot_size);
     nstoieeef(&elas_hdr->x_spot_size);
     nstoieeef(&elas_hdr->trans_matrix_il);
     nstoieeef(&elas_hdr->trans_matrix_ll);
     nstoieeef(&elas_hdr->trans_matrix_ie);
     nstoieeef(&elas_hdr->trans_matrix_le);
     nstoieeel(&elas_hdr->eikonix);
     nstoieeel(&elas_hdr->labl);
   }


  return(elas_hdr);
}


/**************************************************************
*
* MODULE NAME:  read_elas_line()
*
*     PURPOSE:  Reads one scan line of an ELAS image
*
*       INPUT:  elas_file - pointer to elas coordinate structure
*
*      OUTPUT:  
*
* ROUTINES CALLED: block_read() - to read ELAS image data.
*
**************************************************************/

read_elas_line(elas_file)
ECOORD  *elas_file;

{
  int i;


     /* Seek to desired x coordinate into the current ELAS line */
  for (i=0; i < elas_file->rec_length; i++)
  {
   if (i == elas_file->x_init)
   {
         /* Read in desired ELAS image data for current scan line */
     if (block_read(elas_file->fid, elas_file->buf, elas_file->wid) != elas_file->wid)
     {
       (void) fprintf(stderr,"\nread_elas: ");
       (void) fprintf(stderr,"Incorrect byte count reading image data!\n");
       kclose(elas_file->fid);
       return(0);
     }
                  /* Seek to end of the scan line */
     lseek(elas_file->fid, (elas_file->skip + elas_file->pad), 1);
     break;
   }
   else
    lseek(elas_file->fid, 1, 1);   /* increment file pointer to next element */
  }

  return(1);
}
