 /*
  * Khoros: $Id: dmusic.h,v 1.2 1992/03/20 23:14:55 dkhoros Exp $
  */

 /*
  * $Log: dmusic.h,v $
 * Revision 1.2  1992/03/20  23:14:55  dkhoros
 * VirtualPatch5
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1992, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1992 by UNM */


/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: dmusic.h
 >>>>            Author: Jeremy Worley, Ramiro Jordan, Glen Abousleman
 >>>> Date Last Updated: Fri Mar  6 09:13:51 1992
 >>>> 
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/

#ifndef _dmusic_h_
#define _dmusic_h_

#include "vinclude.h"


/* -include_includes */
/* -include_includes_end */

char	**av,		/* argv and argc used by gparams */
	*program;	/* a pointer to the program name argv[0] */
int	ac;

/****************************************************************
*
*                    dmusic Argument Structure
*
****************************************************************/

typedef struct _dmusic  {

/*
 *  input file (xviff file) (Required infile)
 */
char	*i_file;	/* input file (xviff file) FILENAME */
int	 i_flag;	/* input file (xviff file) FLAG */

/*
 *  resulting output file (xviff file) (Required outfile)
 */
char	*o_file;	/* resulting output file (xviff file) FILENAME */
int	 o_flag;	/* resulting output file (xviff file) FLAG */

/*
 *  model order (same as number of eigenvectors) (Optional integer)
 */
int	 s_int; 	/* model order (same as number of eigenvectors) INT */
int	 s_flag;	/* model order (same as number of eigenvectors) FLAG */

/*
 *  specify number of spectral values desired (Optional integer)
 */
int	 f_int; 	/* specify number of spectral values desired INT */
int	 f_flag;	/* specify number of spectral values desired FLAG */

/*
 *  do not center the psd estimate (0) or center the psd estimate (1) (Optional logical)
 */
int	 p_logic;	/* do not center the psd estimate (0) or center the psd estimate (1) LOGIC */
int	 p_flag;  	/* do not center the psd estimate (0) or center the psd estimate (1) FLAG */

/*
 *  scalar processing (0) or vector processing (1) (Optional logical)
 */
int	 j_logic;	/* scalar processing (0) or vector processing (1) LOGIC */
int	 j_flag;  	/* scalar processing (0) or vector processing (1) FLAG */

/*
 *  data processing direction (0 = down vectors, 1 = across bands) (Optional logical)
 */
int	 d_logic;	/* data processing direction (0 = down vectors, 1 = across bands) LOGIC */
int	 d_flag;  	/* data processing direction (0 = down vectors, 1 = across bands) FLAG */

/*
 * type of autocorrelation file to be used (Optional integer toggle - )
 */
int	 g_toggle;		/* type of autocorrelation file to be used INT TOGGLE */
int	 g_flag;		/* type of autocorrelation file to be used FLAG */

/*----  these are an Optional mutually exclusive group ----*/
/*
 *  Use AIC (0) or MDL(1) criterion (Required logical)
 */
int	 c_logic;	/* Use AIC (0) or MDL(1) criterion LOGIC */
int	 c_flag;  	/* Use AIC (0) or MDL(1) criterion FLAG */

/*
 *  dimension of noise subspace sequence (Required integer)
 */
int	 k_int; 	/* dimension of noise subspace sequence INT */
int	 k_flag;	/* dimension of noise subspace sequence FLAG */

/*-------------------------------------------*/

}  dmusic_struct;

dmusic_struct *dmusic;

/* -include_additions */
/* -include_additions_end */

/* -include_macros */
#define READIMAGE(image) \
image = readimage(dmusic->i_file);  \
if (image == NULL) {  \
   (void) fprintf(stderr, "%s: Can not read input image \n",program);  \
   exit(1);  /* Quit if bad image */ \
}

#define CHECKTYPE(program, image) \
    if( ! (propertype(program,image,VFF_TYP_FLOAT,FALSE)) && \
        ! (propertype(program,image,VFF_TYP_COMPLEX,FALSE)) ) { \
          fprintf(stderr,"%s: data storage type must be float or complex.", \
                  program); \
          exit(1); \
    }

#define CHECKINPUT(program, image) \
    proper_num_images(program,image,1,TRUE);  \
    proper_map_enable(program,image,VFF_MAP_OPTIONAL,TRUE);

/*
** these values are passed in as kdim if the user wants this type of
** criterion to determine the dimension of the noise subspace.  These 
** values should be copied into the section -LIBRARY_INCLUDES
*/

#define AIC_CRIT 0
#define MDL_CRIT -1
/* -include_macros_end */

#endif
