 /*
  * Khoros: $Id: dsubsamp.c,v 1.2 1992/03/20 23:33:01 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: dsubsamp.c,v 1.2 1992/03/20 23:33:01 dkhoros Exp $";
#endif

 /*
  * $Log: dsubsamp.c,v $
 * Revision 1.2  1992/03/20  23:33:01  dkhoros
 * VirtualPatch5
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: dsubsamp.c
 >>>>
 >>>>      Program Name: dsubsamp
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Subsamples 1-D vector(s).
 >>>>	
 >>>>	

 >>>>            Author: Donna Koechner
 >>>>
 >>>> Date Last Updated: Wed Feb 19 09:22:57 1992
 >>>>
 >>>>          Routines: main- the main program for dsubsamp
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "dsubsamp.h"


/****************************************************************
 *
 * Routine Name:  main program for dsubsamp
 *
 *       Input:  
 *          -i  input image 
 *          -o  resulting output image 
 *
 *
 *          [-s] Subsample skip value (0 = no skipping)  (value >= 0)
 *          [-x] Point to begin subsampling  (value >= 0)
 *          [-d] data processing direction (0 = down vectors, 1 = across bands)
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
struct xvimage  *img1, *readimage();
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
  if (check_args())
  {
    fprintf(stderr, "%s: Illegal arguments on command line.\n", program);
    exit(1);
  }

  READINPUT1(img1);
  CHECKTYPE(program, img1);
  CHECKINPUT(program, img1);

  if (!dsubsamp->x_flag)
  {
    dsubsamp->x_int = 0;
  }
/* -main_before_lib_call_end */

/* -main_library_call */
 /*
  * Only call library if skip value != zero or nonzero offset into data.
  */
  if ( (dsubsamp->s_int != 0) || (dsubsamp->x_int != 0) )
  {
    if ( !(ldsubsamp(img1,                      /* input/output file */
                     dsubsamp->s_int,           /* skip value */
                     dsubsamp->x_int,           /* first sample point */
                     dsubsamp->d_logic) ))     /* process direction */
    {
      (void) fprintf(stderr, "ldsubsamp Failed\\n");
       exit(1);
    }
  }
/* -main_library_call_end */

/* -main_after_lib_call */
  (void) writeimage(dsubsamp->o_file,img1);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for dsubsamp 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "dsubsamp :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tSubsamples 1-D vector(s).\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i  input image  (infile)\n");
	fprintf(stderr,"\t-o  resulting output image  (outfile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-s]  Subsample skip value (0 = no skipping) (integer, >= 0) [0]\n");
	fprintf(stderr,"\t[-x]  Point to begin subsampling (integer, >= 0) [0]\n");
	fprintf(stderr,"\t[-d]  data processing direction (0 = down vectors, 1 = across bands) (boolean) [true]\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for dsubsamp\n");
	fprintf(stderr, "\t[-U] Gives the usage for dsubsamp\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called dsubsamp.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses dsubsamp.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for dsubsamp
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i_pstr = 
	"\nEnter: (i) input image \n        {infile}: "; 
char	*o_pstr = 
	"\nEnter: (o) resulting output image \n        {outfile}: "; 
char	*s_pstr = 
	"\nEnter: (s) Subsample skip value (0 = no skipping) \n        {integer, >= 0 [0] }: "; 
char	*x_pstr = 
	"\nEnter: (x) Point to begin subsampling \n        {integer, >= 0 [0] }: "; 
char	*d_pstr = 
	"\nEnter: (d) data processing direction (0 = down vectors, 1 = across bands) \n        {boolean, (y/n)  [yes] }: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "dsubsamp", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "dsubsamp.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "dsubsamp: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "dsubsamp.ans");
		}

	     }

	}

	/*
	 * allocate the dsubsamp structure
	 */
	dsubsamp = (dsubsamp_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (dsubsamp_struct));

	/*
	 * get required arguments for dsubsamp
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(dsubsamp->i_flag = vget_infile(fid, prompt_flag,
			"-i", i_pstr, &(dsubsamp->i_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(dsubsamp->i_flag))
		{
		    fprintf(stderr, "\t\ti is required, please re-enter: \n");
		    dsubsamp->i_flag = vget_infile(fid, prompt_flag,
		    "-i", i_pstr, &(dsubsamp->i_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(dsubsamp->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(dsubsamp->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(dsubsamp->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    dsubsamp->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(dsubsamp->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for dsubsamp
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	dsubsamp->s_flag = vget_int(fid, prompt_flag,
	"-s", s_pstr, &(dsubsamp->s_int),
	0, 1, 1);

	dsubsamp->x_flag = vget_int(fid, prompt_flag,
	"-x", x_pstr, &(dsubsamp->x_int),
	0, 1, 1);

	dsubsamp->d_flag = vget_logic(fid, prompt_flag,
	"-d", d_pstr, &(dsubsamp->d_logic), 1);


}



