 /*
  * Khoros: $Id: ldnormal.c,v 1.2 1992/03/20 23:28:45 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: ldnormal.c,v 1.2 1992/03/20 23:28:45 dkhoros Exp $";
#endif

 /*
  * $Log: ldnormal.c,v $
 * Revision 1.2  1992/03/20  23:28:45  dkhoros
 * VirtualPatch5
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1992, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1992 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: ldnormal.c
 >>>>
 >>>>      Program Name: dnormal
 >>>>
 >>>> Date Last Updated: Mon Mar  9 18:53:09 1992 
 >>>>
 >>>>          Routines: ldnormal - the library call for dnormal
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vinclude.h"


/* -library_includes */
/* -library_includes_end */


/****************************************************************
*
* Routine Name: ldnormal - library call for dnormal
*
* Purpose:
*    
*    Normalize Data
*    
*    

* Input:
*    
*    image          pointer to VIFF structure containing image data to
*                   be processed.
*    
*    minimum        minimum value of normalizeed data.
*    
*    maximum        maximum value of normalizeed data.
*    
*    norm_type      type of normalization to be  performed.   0  indi-
*                   cates  standard normalization by dividing the mag-
*                   nitude of each data point by the magnitude of  the
*                   largest  value.   1 indicates adjusting the magni-
*                   tude by scaling and shifting it so  that  it  fits
*                   into a specified range.
*    
*    procdir        process direction:  0  indicated  vector  oriented
*                   processing, 1 indicates band oriented processing.
*    
*    

* Output:
*    
*    image          pointer to VIFF structure  containing  image  data
*                   after processing.
*    
*    Return Value:  1 on success, 0 on failure.
*    
*    

*
* Written By: Jeremy Worley, Ramiro Jordan
*    
*    Jeremy Worley  22-Jul-90       modifications  made  to  call  and
*                                  declaration of dload_vector to con-
*                                  form  to  new  character   oriented
*                                  definition.
*    
*    Jeremy Worley 23-Jul-90       changed normalize value  to  a  min
*                                  and max value so that normalize can
*                                  take place on a range of values.
*    
*    Jeremy Worley  06-Oct-90       modifications  to  lcnormalize  to
*                                  correct for magnitude errors.
*    
*    Jeremy Worley 22-Apr-91       corrected a bug in the complex case
*                                  due  to  vcabs() not being properly
*                                  declared.  also added  the  conven-
*                                  tional normalization mode.
*    
*    

****************************************************************/


/* -library_def */
int
ldnormal ( image, minimum, maximum, norm_type, process_dir)

struct xvimage *image;
int    process_dir, norm_type;
float  minimum, maximum;
/* -library_def_end */

/* -library_code */
{
    int   i, dimension, num_vects;
    int   lcnormalize(),lrnormalize(), dunload_vector();
    float **data; 
    char **dload_vector();

    char *program = "ldnormal";

    if((data = (float **)dload_vector(image, &num_vects, &dimension, 
        process_dir)) == NULL)
    {
      (void) fprintf(stderr,"%s: dload_vector failed \n",program);
      return(0);
    }

    for ( i = 0; i < num_vects; i++ )
    {
        if(image->data_storage_type == VFF_TYP_COMPLEX){
           if(!lcnormalize(data[i], dimension, norm_type,minimum, maximum)){
              fprintf(stderr,"%s:  lcnormalize failed\n",program);
              return(0);
           }
        }else{
           if(!lrnormalize(data[i], dimension, norm_type,minimum, maximum)){
              fprintf ( stderr,"lrnormalize failed\n");
              return(0);
           }
        }
    }

    if (!dunload_vector((char **)data, image, image->data_storage_type, 
        num_vects, dimension, process_dir))
    {
       (void) fprintf (stderr,"%s: dunload_vector failed \n",program);
       return(0);
    }
 
    return(1);

} /* end of ldnormal */



/***********************************************************************
*
*  Routine Name: lrnormalize 
*
*          Date: 2/28/90
*        
*       Purpose:  
*
*         Input: data sequence to normalize, length of data record,
*                normalize factors 
*
*        Output: normalize data record 
*
*    Written By: Ramiro Jordan 
*
* Modifications:
*
***********************************************************************/

int 
lrnormalize ( datain, points, norm_type,minimum, maximum )

int    points,norm_type;
float  *datain, minimum, maximum;
{
    int   i;
    float dmin, dmax, factor;

    /* normalize each data band */ 
    dmax = datain[0];
    dmin = datain[0];
    for ( i = 1; i < points; i++ )
    {
        if ( datain[i] > dmax )dmax = datain[i]; 
        if ( datain[i] < dmin )dmin = datain[i];
    }

    if(norm_type){
       if(dmax==dmin)
          factor = 1.0;
       else
          factor = (maximum - minimum) / (dmax - dmin);

       for ( i = 0; i < points; i++ )
       {
           datain[i] = (datain[i]  - dmin)*factor + minimum;
       }
    }else{

       if((float)fabs((double)dmax)<(float)fabs((double)dmin))dmax = dmin;
       if(dmax!=0.0){
          dmax = (float)fabs((double)dmax);
          for(i=0;i<points;i++){
              datain[i] = datain[i] / dmax;
          }
       }
    }

    return(1);

} /* end of lnormalize */

/***********************************************************************
*
*  Routine Name: lcnormalize 
*
*          Date: 2/28/90
*        
*       Purpose:  
*
*         Input: data sequence to normalize, length of data record,
*                normalize factors 
*
*        Output: normalize data record 
*
*    Written By: jeremy worley 
*
* Modifications:
*
***********************************************************************/

int 
lcnormalize ( datain, points, norm_type,minimum, maximum )

int    points,norm_type;
float  *datain, minimum, maximum;
{
    int   i,j;
    float dmin, dmax, factor;
    double ang,mag;

/*
** here is some distortion of the minimum and maximum
*/

    if(minimum<0.0) minimum = 0.0;
 
    /* normalize each data band */ 
    dmax = sqrt(datain[0]*datain[0] + datain[1]*datain[1]);
    dmin = dmax ;

    for ( i = 1,j = 2; i < points; i++,j+=2 )
    {
        mag = sqrt(datain[j]*datain[j] + datain[j+1]*datain[j+1]);
        if ( mag > dmax )dmax = mag; 
        if ( mag < dmin )dmin = mag;
    }

    if(norm_type){
       if(dmax==dmin)
          factor = 1.0;
       else
          factor = (maximum - minimum) / (dmax - dmin);

       for ( i = 0, j=0; i < points; i++, j+=2 )
       {
           mag = vcabs(datain[j],datain[j+1]);
           ang = cang(datain[j],datain[j+1]);
           mag = (mag - dmin)*factor + minimum;
           datain[j] = (float)mag*cos(ang);
           datain[j+1] = (float)mag*sin(ang);
       }
    }else{
       if(dmax!=0.0){
          for(i=0,j=0;i<points;i++,j+=2){
              datain[j] /= dmax;
              datain[j+1] /= dmax;      
          }
       }
    }

  return(1);
} /* end of lnormalize */
/* -library_code_end */
