 /*
  * Khoros: $Id: cp_locdata.c,v 1.2 1991/12/18 09:56:04 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: cp_locdata.c,v 1.2 1991/12/18 09:56:04 dkhoros Exp $";
#endif

 /*
  * $Log: cp_locdata.c,v $
 * Revision 1.2  1991/12/18  09:56:04  dkhoros
 * HellPatch3
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.

 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

/*
#
# FILE NAME:	cp_locdata.c
# 
# AUTHORS:	Ron E. Neher
# 
# DATE:		3/23/89
# 
# DESCRIPTION:	Copy location data
# 
# MODIFICATIONS:
# 
*/

/*INCLUDE*/
#include "unmcopyright.h"	 /* Copyright 1990 by UNM */
#include "vdefines.h"	 	
#include "viff.h"	 	
#include <stdio.h>

#define LENGTH 512

/**************************************************************
*
* MODULE NAME: copylocationdata
*
*     PURPOSE: Copy location data
*
*       INPUT: 	img1 -- image location data to be copied
*		img2 -- pointer to copied location data
*               malloc_flg -- if set (=1) malloc room
*
*      OUTPUT: 	returns a 1 upon success and a zero upon failure.
*
* CALLED FROM: 
*
* ROUTINES CALLED:
*
**************************************************************/
int
copylocationdata(img1, img2, malloc_flg)
struct
xvimage	*img1,
	**img2;
int	malloc_flg;
{
float	fsize;

/* room for the location */

    switch (img1->location_type)
    {
	case VFF_LOC_IMPLICIT:
	    (*img2)->location = NULL;
	    break;
	case VFF_LOC_EXPLICIT:
	    fsize = img1->row_size*img1->col_size*
		    img1->location_dim*sizeof(float);
	    if (malloc_flg)
                if (((*img2)->location =
		    (float *) malloc((unsigned int) fsize)) == NULL)
                {
	            (void) fprintf(stderr,"copylocationdata: Not enough\
 memory for location data!\n");
		    return(0);
	        }
	    bcopy((char *) img1->location, (char *) (*img2)->location,
		  (int) fsize);
	    break;
	default:
	    (void) fprintf(stderr,"copylocationdata: Not a valid \
location type\n");
	    return(NULL);
	    break;
    }

    (*img2)->location_type = img1->location_type;
    (*img2)->location_dim = img1->location_dim;
    (*img2)->col_size = img1->col_size;
    (*img2)->row_size = img1->row_size;

    return(1);
}
