 /*
  * Khoros: $Id: transport.h,v 1.2 1991/12/18 09:55:23 dkhoros Exp $
  */

 /*
  * $Log: transport.h,v $
 * Revision 1.2  1991/12/18  09:55:23  dkhoros
 * HellPatch3
 *
  */ 


/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.

 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>								<<<<
   >>>>	    file name: transport.h				<<<<
   >>>>								<<<<
   >>>>   description:						<<<<
   >>>>								<<<<
   >>>> modifications:						<<<<
   >>>>								<<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */


#ifndef _transport_h_
#define _transport_h_

#include "internals.h"


/*
 *  Internal structures for the following transports can be found in
 *  the following includes:
 *
 *		file	   -  File.h
 *		shm	   -  Shm.h
 *		sunvm	   -  SunVM.h
 *		tli	   -  Tli.h
 *		pipe	   -  Pipe.h
 *		socket	   -  Socket.h
 *		stream	   -  Stream.h
 *		sun rpc	   -  SunRPC.h
 *		apollo rpc -  ApolloRPC.h
 */

#include "File.h"
/*
 * #ifdef KFILE
 * #else
 * #define  file_routines NULL
 * #endif
 */

#ifdef KSHM
#include "Shm.h"
#else
#define  shm_routines NULL
#endif

#ifdef KSUNVM
#include "SunVM.h"
#else
#define  sunvm_routines NULL
#endif

#ifdef KTLI
#include "Tli.h"
#else
#define  tli_routines NULL
#endif

#ifdef KPIPE
#include "Pipe.h"
#else
#define  pipe_routines NULL
#endif

#ifdef KSOCKET
#include "Socket.h"
#else
#define  socket_routines NULL
#endif

#ifdef KSTREAM
#include "Stream.h"
#else
#define  stream_routines NULL
#endif

#ifdef KSUNRPC
#include "SunRPC.h"
#else
#define  sunrpc_routines NULL
#endif

#ifdef KAPOLLORPC
#include "ApolloRPC.h"
#else
#define  apollorpc_routines NULL
#endif



/*
 *  List of currently supported transports....
 *
 *  To add a new transport please see supporting documentation
 *  transport.3
 */
static TransportInformation *transports[] =
{
	shm_routines,
	pipe_routines,
	stream_routines,
	socket_routines,
	file_routines,
	sunvm_routines,
	tli_routines,
	sunrpc_routines, 
	apollorpc_routines
};

#endif /* _transport_h_ */
/* don`t add after the endif */
