 /*
  * Khoros: $Id: daemon.h,v 1.2 1991/12/18 09:54:02 dkhoros Exp $
  */

 /*
  * $Log: daemon.h,v $
 * Revision 1.2  1991/12/18  09:54:02  dkhoros
 * HellPatch3
 *
  */ 


/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.

 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>								<<<<
   >>>>	    file name: daemon.h					<<<<
   >>>>								<<<<
   >>>>   description:						<<<<
   >>>>								<<<<
   >>>> modifications:						<<<<
   >>>>								<<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */


#ifndef _daemon_h_
#define _daemon_h_

#include "internals.h"


/*
 *  Internal structures for the following transports can be found in
 *  the following includes:
 *
 *		tli	   -  Tli.h
 *		socket	   -  Socket.h
 *		sun rpc	   -  SunRPC.h
 *		apollo rpc -  ApolloRPC.h
 */

#ifdef KTLI
#include "Tli.h"
#else
#define  tli_daemons NULL
#endif

#ifdef KSOCKET
#include "Socket.h"
#else
#define  socket_daemons NULL
#endif

#ifdef KSUNRPC
#include "SunRPC.h"
#else
#define  sunrpc_daemons NULL
#endif

#ifdef KAPOLLORPC
#include "ApolloRPC.h"
#else
#define  apollorpc_daemons NULL
#endif


/*
 *  List of currently supported daemons....
 *
 *  To add a new transport please see supporting documentation
 *  transport.3
 */
static DaemonInformation *daemons[] =
{
	socket_daemons,
	tli_daemons,
	sunrpc_daemons, 
	apollorpc_daemons
};

#endif /* _transport_h_ */
/* don`t add after the endif */
