 /*
  * Khoros: $Id: basename.c,v 1.1 1991/05/10 15:41:06 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: basename.c,v 1.1 1991/05/10 15:41:06 khoros Exp $";
#endif

 /*
  * $Log: basename.c,v $
 * Revision 1.1  1991/05/10  15:41:06  khoros
 * Initial revision
 *
  */ 


/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */
#include "vgparm.h"	


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>	    file name: basename.c                             <<<<
   >>>>                                                       <<<<
   >>>>   description: Strip the filename off a path          <<<<
   >>>>                                                       <<<<
   >>>>      routines: 					      <<<<
   >>>>                                                       <<<<
   >>>> modifications:					      <<<<
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */


/**************************************************************
*
* MODULE NAME: vbasename
*
*     PURPOSE: 	This function is used to strip the filename off a
*		path.
*
*       INPUT: 	1. a valid directory path with filename at the end
*
*      OUTPUT:  returns a pointer to the filename. In the case the
*		filename does not exist (i.e. .., ~user, etc )
*		a NULL is returned.
*
* CALLED FROM: 
*
*  WRITTEN BY:  Mark Young & Tom Sauer
*
**************************************************************/

char *vbasename(filename)

char	*filename;
{
	char *file, temp[LENGTH];


	/*
	 *  If the filename is null then error and return NULL
	 */
	if (filename == NULL)
	{
	   (void) fprintf(stderr,"\nvbasename:\n");
	   (void) fprintf(stderr,"   Error!  NULL input file encountered.\n");
	   return(NULL);
	}

	/*
	 *  If the filename is  empty then error and return NULL
	 */
	strcpy(temp, filename);
	filename = _cleanup_string(temp);
	if (VStrlen(filename) == 0)
	{
	   (void) fprintf(stderr,"\nvbasename:\n");
	   (void) fprintf(stderr,"   Error!  Empty input file encountered.\n");
	   return(NULL);
	}

	if (!(file = strrchr(filename,'/')))
	{
           if (filename[0] == '~')
              return(NULL);
	   else
	      file = filename;
	}
        else 
	{
	   file = (file + 1);
	}

        if ((strcmp(file,"..")) == 0 || (strcmp(file,".")) == 0) 
            return(NULL);
        
        return(VStrcpy(file));
}
