 /*
  * Khoros: $Id: SunVM.h,v 1.3 1992/03/20 23:39:02 dkhoros Exp $
  */

 /*
  * $Log: SunVM.h,v $
 * Revision 1.3  1992/03/20  23:39:02  dkhoros
 * VirtualPatch5
 *
  */ 


/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.

 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>								<<<<
   >>>>	    file name: Shm.h					<<<<
   >>>>								<<<<
   >>>>   description:						<<<<
   >>>>								<<<<
   >>>> modifications:						<<<<
   >>>>								<<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */


#ifndef _SunVM_h_
#define _SunVM_h_

/* sun's virtual memory transport */
#include <sys/mman.h>


/*
 *  Internal structures for the following transport
 *
 *		sunvm	   -  Sun's Virtual Memory
 */

/* virtual memory structure */
typedef struct
{
	int     fid;
	caddr_t addr;
	int     size;
	int	offset;
	int	prot;

} SunvmStruct;

#undef  ResourceStruct
#define ResourceStruct SunvmStruct


int	sunvm_tempnam(),
	sunvm_open(),
	sunvm_close(),
	sunvm_read(),
	sunvm_write(),
	sunvm_lseek(),
	sunvm_tell(),
	sunvm_access(),
	sunvm_unlink(),
	sunvm_lock();


static TransportInformation sunvm_routines[] =
{
    {
	"Sun's Virtual Memory Management",
	"sunvm",
	TRUE,
	sunvm_tempnam,
	sunvm_open,
	sunvm_close,
	sunvm_read,
	sunvm_write,
	sunvm_lseek,
	sunvm_tell,
	NULL,
	sunvm_unlink,
	sunvm_lock,
	NULL,

	NULL,
    }
};

#endif /* _SunVM_h_ */
/* don`t add after the endif */
