 /*
  * Khoros: $Id: xvparser.h,v 1.3 1991/12/18 08:53:26 dkhoros Exp $
  */

 /*
  * $Log: xvparser.h,v $
 * Revision 1.3  1991/12/18  08:53:26  dkhoros
 * HellPatch3
 *
  */ 

/**************************************************************
*
*   Written by:   Richard Krukar & Mark Young
*
**************************************************************/


/*******  #Includes, #Defines, and Global variables & declarations ****/
  
#ifndef _xvparser_h_
#define _xvparser_h_

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.
 * 
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *----------------------------------------------------------------------
 */

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */
#include "vmath.h"
#include "stdio.h"

/*
 * declare routines for the function tabel.  Most of the functions are
 * declared in /usr/include/math.h
 */
#if !defined(hp9000) && !defined(hp9000s300) && !defined(hp9000s400) && !defined(hp9000s700) && !defined(hp9000s800) && !defined(CRAY) && !defined(__convex__) && !defined(AUX) 
    extern double   rint(), expm1(), log1p();
#endif

extern double   vurngx(), vfact(), vimpulse(), vstep(),
		vsign(), vgnoise(), vunoise();

#if defined(__convex__)
    extern double erf(), erfc();
#endif

/*
 * Function structure declaration
 */
struct _function {
		   char    *name;
		   double (*routine)();
		   int      num_args;
		 };

/*
 * Function declaration list
 */
static struct _function functions[] =
{
    { "pow",	  pow,         2 },
    { "sin",	  sin,	       1 },
    { "cos",	  cos,	       1 },
    { "tan",	  tan,	       1 },
    { "sinh",	  sinh,	       1 },
    { "cosh",	  cosh,	       1 },
    { "tanh",	  tanh,	       1 },
    { "asin",	  asin,	       1 },
    { "acos",	  acos,	       1 },
    { "atan",	  atan,	       1 },
    { "atan2",	  atan2,       2 },
    { "exp",	  exp,	       1 },
    { "sqrt",	  sqrt,	       1 },
    { "ln",	  log,	       1 },
    { "log10",	  log10,       1 },
    { "hypot",	  hypot,       2 },
    { "abs",	  fabs,	       1 },
    { "floor",	  floor,       1 },
    { "ceil",	  ceil,	       1 },
    { "fact",	  vfact,        1 },
    { "gnoise",   vgnoise,      1 },
    { "unoise",   vunoise,      1 },
    { "impulse",  vimpulse,     1 },
    { "step",	  vstep,        1 },
    { "sign",	  vsign,        1 },
    { "j0",	  j0,	       1 },
    { "j1",	  j1,	       1 },
    { "y0",	  y0,          1 },
    { "y1",	  y1,	       1 },
    { "erf",	  erf,         1 },
    { "erfc",	  erfc,        1 },

#if defined(sony_news) || defined(apollo) || defined(NeXT) || defined(luna)
    { "gamma",	  lgamma,      1 },
#else
    { "gamma",	  gamma,       1 },
#endif

#if !defined(hp9000) && !defined(hp9000s300) && !defined(hp9000s400) && !defined(hp9000s700) && !defined(hp9000s800) && !defined(CRAY) && !defined(__convex__) && !defined(AUX) && !defined(m88k) && !defined(luna)
    { "expm1",	  expm1,       1 },
    { "rint",	  rint,	       1 },
    { "log1p",	  log1p,       1 },
#endif

    { NULL,	  0,	       0 },
};

/*
 * Constant structure declaration
 */
struct _constant {
		   char *name;
		   double value;
		 };

/*
 * Variable declaration list
 */
static struct _constant variables[] =
{
    { "x",		0.0 },
    { "y",		1.0 },
    { NULL,		0   },
};

/*
 * Constant declaration list
 */
static struct _constant constants[] =
{
    { "e",       XV_E        },
    { "pi",      XV_PI       },
    { "deg",     XV_DEG      },
    { "phi",     XV_PHI      },
    { "maxfl",   XV_MAXFLOAT },
    { "maxint",  XV_MAXLINT  },
    { "maxshort",XV_MAXSINT  },
    { "gamma",   XV_GAMMA    },
    { "log2e",   XV_LOG2E    },
    { "log10e",  XV_LOG10E   },
    { "ln2",     XV_LN2      },
    { "ln10",    XV_LN10     },
    { "pi_2",    XV_PI_2     },
    { "pi_4",    XV_PI_4     },
    { "sqrtpi",  XV_SQRTPI   },
    { "sqrt2",   XV_SQRT2    },
    { "sqrt1_2", XV_SQRT1_2  },
    {  NULL,	 0	     },
};

/*

yuck...  what do we do about this??
extern double frexp(), ldexp(), modf(), jn(), yn();
extern int matherr();
#define _POLY1(x, c)	((c)[0] * (x) + (c)[1])
#define _POLY2(x, c)	(_POLY1((x), (c)) * (x) + (c)[2])
#define _POLY3(x, c)	(_POLY2((x), (c)) * (x) + (c)[3])
#define _POLY4(x, c)	(_POLY3((x), (c)) * (x) + (c)[4])
#define _POLY5(x, c)	(_POLY4((x), (c)) * (x) + (c)[5])
#define _POLY6(x, c)	(_POLY5((x), (c)) * (x) + (c)[6])
#define _POLY7(x, c)	(_POLY6((x), (c)) * (x) + (c)[7])
#define _POLY8(x, c)	(_POLY7((x), (c)) * (x) + (c)[8])
#define _POLY9(x, c)	(_POLY8((x), (c)) * (x) + (c)[9])
*/

#endif /* _xvparser_h_ */
/* Dont' add after this point */
