 /*
  * Khoros: $Id: dem.h,v 1.1 1991/05/10 04:13:15 khoros Exp $
  */

 /*
  * $Log: dem.h,v $
 * Revision 1.1  1991/05/10  04:13:15  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>	    file name: dem.h                                  <<<<
   >>>>                                                       <<<<
   >>>>      contains: contains the structures demimage and   <<<<
   >>>>                demprofile, used with DEM data.        <<<<
   >>>>                                                       <<<<
   >>>>      written by:  Per Lysne			      <<<<
   >>>>                                                       <<<<
   >>>>      date: 8/1/90                                     <<<<
   >>>>                                                       <<<<
   >>>>      modifications:				      <<<<
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _dem_h_
#define _dem_h_

/*
 * This structure holds all of the data from the DEM file (A,B,C Records).
 */
struct demimage {
    /* This Section is the A Record */
    char      name[150];	/* The comment at the head of the DEM file */
    int       level;		/* The USGS level code for the data        */
    int       pattern;		/* Regular or non-regular sampled data     */
    int       reference;	/* The ground reference system used        */
    int       zone;		/* Geographic location of data             */
    double    projection[15];	/* Map projection parameters               */
    int       groundunit;	/* Unit which ground distances are in      */
    int       elevationunit;	/* Unit which elevations are in            */
    int       sides;		/* Number of side bounding the region      */
    double    corners[4][2];	/* Geo-Location of corners of data         */
    double    minimum;		/* Minimum elevation in the data           */
    double    maximum;		/* Maximum elevation in the data           */
    double    angle;		/* Angle from primary to local reference   */
    int       accuracy;		/* Is there accuracy data in this file     */
    double    xres;		/* Distance between data in x direction    */
    double    yres;		/* Distance between data in y direction    */
    double    zres;		/* Distance between data in z direction    */
    int       numrows;		/* Number of rows in a profile (1)         */
    int       numcolumns;	/* Number of columns in the data           */

    /* This Section Points to the B Records */
    struct demprofile **data;	/* Array of profile structures             */

    /* This Section is the C Record */
    int       absolute;		/* Is absolute accuracy data available     */
    int       absoluteRMSE[3];	/* RMSE relative to absolute data          */
    int       absolutesize;	/* Size of sample for RMSE absolute        */
    int       relative;		/* Is relative accuracy data available     */
    int       relativeRMSE[3];	/* RMSE relative to rest of file           */
    int       relativesize;	/* Size of sample for RMSE relative        */
};




/*
 * This structure is used to hold the columns of elevation data (B Records).
 */
struct demprofile {
    int      row;		/* Row number of this profile (1)          */
    int      column;		/* Column number of this profile           */
    int      numrows;		/* Number of data in this profile          */
    int      numcolumns;	/* Number of bands in this profile (1)     */
    double   xground;		/* Geo-X location of 1st data in profile   */
    double   yground;		/* Geo-Y location of 1st data in profile   */
    double   elevation;		/* Base elevation for data in this profile */
    double   minimum;		/* Minimum elevation in this profile       */
    double   maximum; 		/* Maximum elevation in this profile       */
    int      *data;		/* Pointer to array of elevation data      */
};


/* defines for pattern field */
#define IRREGULAR   0
#define REGULAR     1

/* defines for reference field */
#define GEOGRAPHIC  0
#define UTM         1
#define STATE_PLANE 2

/* defines for zone field */
#define DEM         0

/* defines for groundunit field (1 and 2 also apply to elevationunit) */
#define RADIANS     0
#define FEET        1
#define METERS      2
#define ARC_SECONDS 3

/* defines for accuracy field */
#define KNOWN       1
#define UNKNOWN     0


#endif /* do not add after this point */
