#ifndef lint
static char *RCSid = "$Header: /empire/empire/EMP/player/commands/name.c,v 1.32 90/11/10 12:28:31 bailey Exp $";
#endif /* not lint */

/*
 * name.c
 *
 * name a ship
 *
 * Jeff Bailey (bailey@mcs.kent.edu)
 */

#include "misc.h"
#include "var.h"
#include "sect.h"
#include "ship.h"
#include "xy.h"
#include "nsc.h"
#include "nat.h"
#include "deity.h"
#include "file.h"
#include "path.h"

#ifdef	SHIPNAMES

/*
 * name <SHIP> <NAME>
 */
name()
{
	extern	char *argp[];
	struct	shpstr	ship;
	char	*p;
	struct nstr_item nb;

	if (!snxtitem(&nb, EF_SHIP, argp[1]))
		return RET_SYN;
	while (nxtitem(&nb, (char *)&ship)) {
		if (!owner)
			continue;
		p = getstarg(argp[2], "Name? ");
		if (p == 0 || *p == 0)
			return RET_SYN;
		if (!strcmp(p,"~")) {
			ship.shp_name[0] = 0;
		}
		else
		{
			strncpy(ship.shp_name,p,MAXSHPNAMLEN - 1);
			ship.shp_name[MAXSHPNAMLEN - 1] = 0;
		}
		putship(ship.shp_uid,&ship);
	}

	return RET_OK;
}

#endif	SHIPNAMES
