#ifndef lint
static char *RCSid = "$Header: /users/empire/EMP/empmain/COMS/RCS/decl.c,v 1.4 89/05/29 14:18:29 emp-src Exp $";
#endif /* not lint */

/*
 * decl.c
 *
 * declare war, neutrality or alliance.
 *
 * from PSL Empire, 1985
 */

#include "misc.h"
#include "nat.h"
#include "news.h"
#include "file.h"
decl()
{
	extern	char *argp[];
	register char *p;
	struct	natstr	*natp;
	int	rel;
	int	oldrel;
	int	n;
	natid	with;

	natp = getnatp(cnum);

#ifdef FODDER
	p = getstarg(argp[1], "alliance, neutrality, fodder, hostility, or war? ");
#else
	p = getstarg(argp[1], "alliance, neutrality, hostility, or war? ");
#endif
	switch (*p) {
	case 'a':
		rel = ALLIED;
		break;
	case 'h':
		rel = HOSTILE;
		break;
	case 'n':
		rel = NEUTRAL;
		break;
	case 'w':
		rel = AT_WAR;
		break;
#ifdef FODDER
	case 'f':
		rel = FODDER;
		break;
#endif FODDER
	default:
		pr("That's no declaration!\n");
		return RET_SYN;
	}
	if ((n = natarg(argp[2], "with which country? ")) < 0)
		return RET_SYN;
	with = n;
	if ((oldrel = getrel(natp, with)) == rel) {
		pr("No change required for that!\n");
		return RET_FAIL;
	}
	setrel(cnum, with, rel);
	if (rel == ALLIED) {
		pr("Congratulations.\n");
		nreport(cnum, N_DECL_ALLY, with, 1);
#ifdef MERC
#ifdef REJECTS
		if((getrejects(cnum, getnatp(with)) & REJ_TELE) == 0)
#endif
#endif
		wu(0, with,
			fmt("Country #%d has declared an alliance with you!",
			cnum));
	} else if (rel == NEUTRAL) {
		if (oldrel == 1)
			nreport(cnum, N_DIS_ALLY, with, 1);
		else
			nreport(cnum, N_DIS_WAR, with, 1);
		pr("Neutrality declared.\n");
#ifdef MERC
#ifdef REJECTS
		if((getrejects(cnum, getnatp(with)) & REJ_TELE) == 0)
#endif
#endif
		wu(0, with,
			fmt("Country #%d has declared neutrality toward you!",
			cnum));
	} else if (rel == HOSTILE) {
		pr("Another cold war...\n");
#ifdef MERC
#ifdef REJECTS
		if((getrejects(cnum, getnatp(with)) & REJ_TELE) == 0)
#endif
#endif
		wu(0, with, fmt("Country #%d has become hostile!", cnum));
	} else if (rel == AT_WAR) {
		pr("Declaration made (give 'em hell).\n");
#ifdef MERC
#ifdef REJECTS
		if((getrejects(cnum, getnatp(with)) & REJ_TELE) == 0)
#endif
#endif
		wu(0, with, fmt("Country #%d has declared war on you!", cnum));
		nreport(cnum, N_DECL_WAR, with, 1);
#ifdef FODDER
	} else if (rel == FODDER) {
		pr("another sap added to the collection...\n");
#ifdef MERC
#ifdef REJECTS
		if((getrejects(cnum, getnatp(with)) & REJ_TELE) == 0)
#endif
#endif
		wu(0, with, 
		   fmt("Country #%d has declared you to be fodder.", cnum));
#endif FODDER
	}
	return RET_OK;
}

