#ifndef lint
static char *RCSid = "$Header: /sequent2/empire/EMP/player/commands/RCS/coun.c,v 1.8 89/09/16 17:16:19 mr-frog Exp $";
#endif /* not lint */

/*
 * coun.c
 *
 * do a country roster.
 *
 * from PSL Empire, 1985
 */

#include "misc.h"
#include "var.h"
#include "sect.h"
#include "nat.h"
#include "deity.h"
#include "xy.h"
#include "nsc.h"
#include "file.h"

int
coun()
{
	extern	char *argp[];
	struct	nstr_item ni;
	struct	natstr nat;
	int	first;
	int     onnow;

	onnow = (argp[2] && argp[2][0] == 'w');

	if (!snxtitem(&ni, EF_NATION, argp[1]))
		return RET_SYN;
	first = 1;
	while (nxtitem(&ni, (char *)&nat)) {
		if ((nat.nat_stat & STAT_INUSE) == 0)
			continue;
		if (first) {
			coun_header();
			first = 0;
		}
		coun_list((natid)ni.cur, &nat, onnow);
	}
	return RET_OK;
}

static
coun_header()
{
	prdate();
	pr("  #   ");
	if (god) pr("last access       time\t");
	pr("status\t\t country name\n");
}

static
coun_list(cn, natp, onnow)
	natid	cn;
	struct	natstr *natp;
        int onnow;
{
	char	*status;
	struct	sctstr sect;

	if (onnow)
	  if(god&&!natp->nat_login) return; /*only show if logged in*/
	pr(fmt("%3d  ",cn));
	if (god)
	  pr(fmt("%-16.16s   [%d]", natp->nat_login ?
		" Now logged on" : ctime(&natp->nat_date),
		natp->nat_btu));
	switch (natp->nat_stat & (STAT_NORM|STAT_GOD|STAT_NEW|STAT_SANCT)) {
	case 0:
		status = "Visitor";
		break;
	case STAT_NEW:
		status = "New";
		break;
	case STAT_SANCT:
		status = "Sanctuary";
		break;
	case (STAT_NORM|STAT_SANCT):
		getsect(natp->nat_xcap, natp->nat_ycap, &sect);
		if (sect.sct_own != cn ||
		    sect.sct_type != SCT_CAPIT)
			status = "In flux";
		else if (natp->nat_money < 0)
			status = "Broke";
		else
			status = "Active";
		break;
	case (STAT_GOD|STAT_NORM):
	case (STAT_GOD|STAT_NORM|STAT_SANCT):
		status = "DEITY";
		break;
	default:
		status = "Buggy";
		break;
	}
	pr(fmt("\t%-9.9s\t %s\n", status, natp->nat_cnam));
}
