/* This file is part of dvi2bitmap; see README for copyrights and licence */

#ifndef STRINGSTREAM_H_LOADED
#define STRINGSTREAM_H_LOADED 1

#include <config.h>

#ifdef HAVE_SSTREAM

#include <sstream>
#define SSTREAM ostringstream
#define SS_C_STR(s) (s).str().c_str()
#define SS_STRING(s) (s).str()

using STD::ostringstream;

#elif HAVE_STRSTREAM

#include <strstream>
#define SSTREAM ostrstream
#define SS_C_STR(s) (s).str()
/* Add the end-of-string to the stringbuf and convert it to a string */
#define SS_STRING(s) ((s)<<ends,string((s).str()))

using STD::ostrstream;
using STD::ends;

#else
#error "Neither HAVE_SSTREAM nor HAVE_STRSTREAM is defined!"
#endif

#endif /* STRINGSTREAM_H_LOADED */
