/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.classfile.attribute;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.cojen.classfile.Attribute;
import org.cojen.classfile.AttributeFactory;
import org.cojen.classfile.CodeBuffer;
import org.cojen.classfile.ConstantPool;
import org.cojen.classfile.ExceptionHandler;
import org.cojen.classfile.LocalVariable;
import org.cojen.classfile.Location;
import org.cojen.classfile.attribute.LineNumberTableAttr;
import org.cojen.classfile.attribute.LocalVariableTableAttr;

public class CodeAttr
extends Attribute {
    private CodeBuffer mCodeBuffer;
    private List mAttributes = new ArrayList(2);
    private LineNumberTableAttr mLineNumberTable;
    private LocalVariableTableAttr mLocalVariableTable;
    private LineNumberTableAttr mOldLineNumberTable;
    private LocalVariableTableAttr mOldLocalVariableTable;

    public CodeAttr(ConstantPool cp) {
        super(cp, "Code");
    }

    public CodeAttr(ConstantPool cp, String name) {
        super(cp, name);
    }

    public CodeAttr(ConstantPool cp, String name, int length, DataInput din, AttributeFactory attrFactory) throws IOException {
        super(cp, name);
        final int maxStackDepth = din.readUnsignedShort();
        final int maxLocals = din.readUnsignedShort();
        final byte[] byteCodes = new byte[din.readInt()];
        din.readFully(byteCodes);
        int exceptionHandlerCount = din.readUnsignedShort();
        final ExceptionHandler[] handlers = new ExceptionHandler[exceptionHandlerCount];
        for (int i = 0; i < exceptionHandlerCount; ++i) {
            handlers[i] = ExceptionHandler.readFrom(cp, din);
        }
        this.mCodeBuffer = new CodeBuffer(){

            public int getMaxStackDepth() {
                return maxStackDepth;
            }

            public int getMaxLocals() {
                return maxLocals;
            }

            public byte[] getByteCodes() {
                return (byte[])byteCodes.clone();
            }

            public ExceptionHandler[] getExceptionHandlers() {
                return (ExceptionHandler[])handlers.clone();
            }
        };
        int attributeCount = din.readUnsignedShort();
        for (int i = 0; i < attributeCount; ++i) {
            this.addAttribute(Attribute.readFrom(cp, din, attrFactory));
        }
    }

    public CodeBuffer getCodeBuffer() {
        return this.mCodeBuffer;
    }

    public void setCodeBuffer(CodeBuffer code) {
        this.mCodeBuffer = code;
        this.mOldLineNumberTable = this.mLineNumberTable;
        this.mOldLocalVariableTable = this.mLocalVariableTable;
        this.mAttributes.remove(this.mLineNumberTable);
        this.mAttributes.remove(this.mLocalVariableTable);
        this.mLineNumberTable = null;
        this.mLocalVariableTable = null;
    }

    public int getLineNumber(Location start) {
        LineNumberTableAttr table = this.mOldLineNumberTable;
        if (table == null) {
            table = this.mLineNumberTable;
        }
        if (table == null || start.getLocation() < 0) {
            return -1;
        }
        return table.getLineNumber(start);
    }

    public void mapLineNumber(Location start, int line_number) {
        if (this.mLineNumberTable == null) {
            this.addAttribute(new LineNumberTableAttr(this.getConstantPool()));
        }
        this.mLineNumberTable.addEntry(start, line_number);
    }

    public void localVariableUse(LocalVariable localVar) {
        if (this.mLocalVariableTable == null) {
            this.addAttribute(new LocalVariableTableAttr(this.getConstantPool()));
        }
        this.mLocalVariableTable.addEntry(localVar);
    }

    public void addAttribute(Attribute attr) {
        if (attr instanceof LineNumberTableAttr) {
            if (this.mLineNumberTable != null) {
                this.mAttributes.remove(this.mLineNumberTable);
            }
            this.mLineNumberTable = (LineNumberTableAttr)attr;
        } else if (attr instanceof LocalVariableTableAttr) {
            if (this.mLocalVariableTable != null) {
                this.mAttributes.remove(this.mLocalVariableTable);
            }
            this.mLocalVariableTable = (LocalVariableTableAttr)attr;
        }
        this.mAttributes.add(attr);
    }

    public Attribute[] getAttributes() {
        Attribute[] attrs = new Attribute[this.mAttributes.size()];
        return this.mAttributes.toArray(attrs);
    }

    public int getLength() {
        int length = 12;
        if (this.mCodeBuffer != null) {
            length += this.mCodeBuffer.getByteCodes().length;
            ExceptionHandler[] handlers = this.mCodeBuffer.getExceptionHandlers();
            if (handlers != null) {
                length += 8 * handlers.length;
            }
        }
        int size = this.mAttributes.size();
        for (int i = 0; i < size; ++i) {
            length += ((Attribute)this.mAttributes.get(i)).getLength();
            length += 6;
        }
        return length;
    }

    public void writeDataTo(DataOutput dout) throws IOException {
        int i;
        if (this.mCodeBuffer == null) {
            throw new IllegalStateException("CodeAttr has no CodeBuffer set");
        }
        ExceptionHandler[] handlers = this.mCodeBuffer.getExceptionHandlers();
        dout.writeShort(this.mCodeBuffer.getMaxStackDepth());
        dout.writeShort(this.mCodeBuffer.getMaxLocals());
        byte[] byteCodes = this.mCodeBuffer.getByteCodes();
        dout.writeInt(byteCodes.length);
        dout.write(byteCodes);
        if (handlers != null) {
            int exceptionHandlerCount = handlers.length;
            dout.writeShort(exceptionHandlerCount);
            for (i = 0; i < exceptionHandlerCount; ++i) {
                handlers[i].writeTo(dout);
            }
        } else {
            dout.writeShort(0);
        }
        int size = this.mAttributes.size();
        dout.writeShort(size);
        for (i = 0; i < size; ++i) {
            Attribute attr = (Attribute)this.mAttributes.get(i);
            attr.writeTo(dout);
        }
        this.mOldLineNumberTable = null;
        this.mOldLocalVariableTable = null;
    }
}

