#ifndef swShader_PixelPipeline_hpp
#define swShader_PixelPipeline_hpp

#include "PixelShader.hpp"
#include "Context.hpp"

#include "Types.hpp"

namespace swShader
{
	class PixelPipeline : protected Context, public PixelShader
	{
	public:
		PixelPipeline();

		~PixelPipeline();

		void execute();
		void (*executable())();

		void loadConstants();

		void setConstant(int index, const float value[4]);

	private:
		void encode();

		void setupInterpolants();
		void pixel();
		void depthTest();
		void sampleTexture(int stage);
		void blendTexture(int stage);
		void alphaTest();
		void diffusePixel();
		void specularPixel();
		void alphaBlend();
		void writePixel();
		void interpolate();

		void (*code)();

		bool perspectiveCorrected;

		static int x;   // Pixel position

		// Interpolants
		static float4 RHW;
		static float4 Z;

		static word4 dc_dx;
		static word4 dl_dx;

		// Perspective correct w
		static float4 W;

		static float4 t[8];   // Texture coordinates
		static word4 v[2];   // Vertex colors (diffuse, specular)

		// 'Registers'
		static word4 result;   // Pixel color throughout pipeline
		static word4 current;   // Texel from current sampler stage
		static word4 temp;
	};
}

#endif   // swShader_PixelPipeline_hpp
