#ifndef Application_hpp
#define Application_hpp

#include "Window.hpp"

#include "Point.hpp"
#include "Camera.hpp"
#include "Monitor.hpp"

namespace swShader
{
	class Renderer;
	class Texture;
	class Model3DS;
	class FrameBuffer;
	class Keyboard;
	class Mouse;

	class Application : public Window
	{
	public:
		Application(HINSTANCE instance);

		~Application();

	protected:
		void eventDraw();
		void eventKeyDown(int key);
		
		void toggleFullscreen();

		void renderFrame();
		void handleInput();

	private:
		FrameBuffer *frameBuffer;
		Renderer *renderer;
		Keyboard *keyboard;
		Mouse *mouse;

		Texture *texture[3];
		Model3DS *teapot;
		Model3DS *torus;

		Camera camera;

		Monitor monitor;

		int frame;
		float elapsedTime;
		double totalTime;
		double previousTime;
	};
}

#endif   // Application_hpp