// MiMe Front End Implimentation for 2nd Order Musle Control based on
// Splines
// Steve Franks stevef@csl.sony.co.jp  December 1991

#include <gl/gl.h>
#include <gl/device.h>
#include <stdlib.h>
#include <unistd.h>
#include <stream.h>
#include <iostream.h>

#include "../inc/debug.h"
#include "graphics.h"
#include "spline_ed.h"
#include "muscles.h"

extern "C" {
#include <forms.h>
#include "spline_forms.h"
#include "IPC.h"

}

// Function Declerations
long init_graphics(void);


#include "../inc/colors.h"

void add_points(int,float[4][3],float[4][3],float[4][3]);
void print_geom(char *, float[4][3]);
void event_handler(void);
void init_splines(void);


/////////////// Global Variables ///////////////////////////
spline_editor *sp[20]; 
winman	*wman;				// the window manager
packet_format	data;
int	skt;
long 	root_gid;
main(int, char *)
{

   
    int		i;
    float g1[4][3], g2[4][3], g3[4][3];


    
    for (i=0; i<19; i++) 
      data.param[i] = 0.0;
    
    skt = setup_client_IPC();
    root_gid = init_graphics();
    winpush();

    create_the_forms();
    fl_set_form_position(spline_cntrl,10,100);
    fl_show_form(spline_cntrl,FL_PLACE_POSITION,FALSE,NULL);
    init_splines();

    fl_qdevice(LEFTMOUSE);
    fl_tie(LEFTMOUSE,MOUSEX,MOUSEY);
    fl_qdevice(REDRAW);
    fl_qdevice(INPUTCHANGE);
    status("Hitting the Event Handler...");
    event_handler();
}


/*** event_handler ****/
void event_handler()
{

    FL_OBJECT *obj;
    long dev;
    static short val,curr_win;
    spline_pntr	edtor;

    while(1) {
	obj = fl_do_forms();
	if (obj == FL_EVENT) {
	    dev = fl_qread(&val);
	    if ((dev==0) && (val==0) ) {  // Some error condition
		fl_qreset();
	    }
	    if (dev==REDRAW) {
		reshapeviewport();
		edtor= wman->lookup((long)val);
		if (edtor!= (spline_pntr) -1)
		  edtor->redraw();
		
	    }

	    if (dev==INPUTCHANGE) {
		curr_win = val;			// 0 if exits a window 
	    } 

	    else  if (dev == LEFTMOUSE) {
		//status("Leftmousr",val); 
		//status("Curr_win ",curr_win);

		edtor= wman->lookup((long)curr_win);
		if (edtor!= (spline_pntr) -1) {
		    winset(curr_win);
		    edtor->callback(dev,val); 
		}
	    }
	    else {
		status("Event Device: ",dev);
		status("Event Value : ",val);
	    }
	}	// if (FL_EVENT)
    }  // while(1)
    
}



/*** init_splines ***/
void	init_splines()
{
    int	i;
    char 	title[30];
    float	xpos,ypos;
    /* Now open all the Spline Windows! and window manager */
  
    wman = new winman(20);		// maximum number of windows
    for (i=0;i<12;i++) {
	sprintf(title,"Param %d",i);
	sp[i] = new spline_editor(i,5,1,200);  // id,#pnts, start & end frame
	xpos = 1000-(int) (i/9)*275;
	ypos = (i%9)*108;
	sp[i]->open(xpos,ypos,250,70);	// add location
	wman->inform(sp[i],sp[i]->winid());
    }
   
    sp[0]->set_title("Zygos");
    sp[1]->set_title("Anguli");
    sp[2]->set_title("In Front");
    sp[3]->set_title("Out Front");
    sp[4]->set_title("Labi");
    sp[5]->set_title("Corrug");
    sp[6]->set_title("Nasi (L)");
    sp[7]->set_title("Lat Corr");
    sp[8]->set_title("Maj. Front");
    sp[9]->set_title("Jaw Rot");
    sp[10]->set_title("Lip Z");
    sp[11]->set_title("Lip Y");

}

/*** init_graphics ***/
long init_graphics(void)
{
    long gid;

    status("Opening the root window"); 

    foreground();
    prefposition(0,200,0,100);
    gid = winopen("Splines");
   
    mmode(MVIEWING);	
    ortho(-900,900,-900,900,-900,900);
    RGBmode();
    linewidth(2);
    gconfig();
    
    cpack(c_black);   clear();    zclear();

    //  Change the cout formatting of floats.
    cout.precision(5);
    cout.fill(0);
    cout.width(6);
  

    return(gid);
}

























