/* 0959, Fri 9 Oct 92

   SNMPVARS.C:  AU Internet Accounting Meter snmp agent
		Based on the CMU snmpd version, snmpd.c

   Copyright (C) 1992 by Nevil Brownlee,
   Computer Centre,  University of Auckland */

#include "ausnmp.h"

#include <ctype.h>
#include <sys/types.h>

#include "pktsnap.h"
#include "flowtree.h"

#ifdef AU_MSDOS

#include "tcp.h"

#else

#include <sys/time.h>
#include <sys/socket.h>
#include <sys/param.h>
#include <sys/dir.h>
#include <sys/user.h>
#include <sys/proc.h>
#include <machine/pte.h>
#include <sys/vm.h>
#include <netinet/in.h>
#include <syslog.h>
#include <sys/ioctl.h>
#include <net/if.h>
#include <net/route.h>
#include <netinet/in_pcb.h>
#include <netinet/if_ether.h>
#include <netinet/in_systm.h>
#include <netinet/in_var.h>
#include <netinet/ip.h>
#include <netinet/ip_var.h>
#include <netinet/tcp.h>
#include <netinet/tcp_timer.h>
#include <netinet/tcp_var.h>
#include <netinet/tcp_fsm.h>
#include <netinet/udp.h>
#include <netinet/udp_var.h>
#include <netinet/ip_icmp.h>
#include <netinet/icmp_var.h>
#include <nlist.h>
#include <sys/protosw.h>

#endif  /* AU_MSDOS */

#ifndef NULL
#define NULL 0
#endif

#ifndef AU_MSDOS
#include "asn1.h"
#include "snmp.h"
#include "snmp_impl.h"
#include "mib.h"
#include "snmp_vars.h"

#else  /* AU_MSDOS */

#include "asn1.h"
#include "snmp.h"
#include "snmpimpl.h"
#include "mib.h"
#include "snmpvars.h"
#endif  /* AU_MSDOS */


long		long_return;
u_char		return_buf[256]; /* nee 64 */

void init_snmp()
{  }

#define INT_ACCT   1, 3, 6, 1, 3, 99
#define AUKUNI     1, 3, 6, 1, 4, 1, 411

struct variable     variables[] = {
    /* these must be lexicographly ordered by the name field */
    {{MIB, 1, 1, 0},		9, STRING,  VERSION_DESCR, RONLY, var_system},
    {{MIB, 1, 2, 0},		9, OBJID,   VERSION_ID, RONLY, var_system},
    {{MIB, 1, 3, 0},		9, TIMETICKS, UPTIME, RONLY, var_system},
    {{MIB, 2, 1, 0},		9, INTEGER, IFNUMBER, RONLY, var_system},

   {{INT_ACCT, 3, 1, 1, MAX_SUBID}, 10, INTEGER, FTFLOWNBR, RONLY, var_ft},
   {{INT_ACCT, 3, 1, 2, MAX_SUBID}, 10, INTEGER, FTFLOWSTATUS, RONLY, var_ft},
   {{INT_ACCT, 3, 1, 3, MAX_SUBID}, 10, INTEGER, FTNEXTACTIVEFLOW, RONLY, var_ft},
   {{INT_ACCT, 3, 1, 4, MAX_SUBID}, 10, INTEGER, FTADDRTYPE, RONLY, var_ft},
   {{INT_ACCT, 3, 1, 5, MAX_SUBID}, 10, STRING,  FTFROMADDR, RONLY, var_ft},
   {{INT_ACCT, 3, 1, 6, MAX_SUBID}, 10, STRING,  FTFROMMASK, RONLY, var_ft},
   {{INT_ACCT, 3, 1, 7, MAX_SUBID}, 10, STRING,  FTFROMTALLY, RONLY, var_ft},
   {{INT_ACCT, 3, 1, 8, MAX_SUBID}, 10, STRING,  FTTOADDR, RONLY, var_ft},
   {{INT_ACCT, 3, 1, 9, MAX_SUBID}, 10, STRING,  FTTOMASK, RONLY, var_ft},
   {{INT_ACCT, 3, 1,10, MAX_SUBID}, 10, STRING,  FTTOTALLY, RONLY, var_ft},
   {{INT_ACCT, 3, 1,11, MAX_SUBID}, 10, COUNTER, FTFWDPACKETS, RONLY, var_ft},
   {{INT_ACCT, 3, 1,12, MAX_SUBID}, 10, COUNTER, FTFWDBYTES, RONLY, var_ft},
   {{INT_ACCT, 3, 1,13, MAX_SUBID}, 10, COUNTER, FTBACKPACKETS, RONLY, var_ft},
   {{INT_ACCT, 3, 1,14, MAX_SUBID}, 10, COUNTER, FTBACKBYTES, RONLY, var_ft},
   {{INT_ACCT, 3, 1,15, MAX_SUBID}, 10, COUNTER, FTCHKFWDPKTS, RONLY, var_ft},
   {{INT_ACCT, 3, 1,16, MAX_SUBID}, 10, COUNTER, FTCHKFWDBYTES, RONLY, var_ft},
   {{INT_ACCT, 3, 1,17, MAX_SUBID}, 10, COUNTER, FTCHKBACKPKTS, RONLY, var_ft},
   {{INT_ACCT, 3, 1,18, MAX_SUBID}, 10, COUNTER, FTCHKBACKBYTES, RONLY, var_ft},
   {{INT_ACCT, 3, 1,19, MAX_SUBID}, 10, OPAQUE, FTFLOWBLOB, RONLY, var_ft},

   {{INT_ACCT, 3, 2, 0},           9, INTEGER, FTFLOWCOUNT, RONLY, var_system},
   {{INT_ACCT, 3, 3, 0},           9, TIMETICKS, FTCHKTIME, RONLY, var_system},
   {{INT_ACCT, 3, 4, 0},           9, INTEGER, FTCHKFLOWCOUNT, RONLY, var_system},
   {{INT_ACCT, 3, 5, 0},           9, TIMETICKS, FTPREVCHKTIME, RONLY, var_system},
   {{INT_ACCT, 3, 6, 0},           9, INTEGER, FTCHKACTFLOWS, RONLY, var_system},
   {{INT_ACCT, 3, 7, 0},           9, INTEGER, FTFIRSTACTFLOW, RONLY, var_system},
   {{INT_ACCT, 3, 8, 0},           9, INTEGER, FTCHECKPOINT, RWRITE, var_system},

   {{INT_ACCT, 4, 1, 1, MAX_SUBID}, 10, INTEGER, RTRULENBR, RONLY, var_rt},
   {{INT_ACCT, 4, 1, 2, MAX_SUBID}, 10, INTEGER, RTTREENBR, RONLY, var_rt},
   {{INT_ACCT, 4, 1, 3, MAX_SUBID}, 10, INTEGER, RTADDRTYPE, RONLY, var_rt},
   {{INT_ACCT, 4, 1, 4, MAX_SUBID}, 10, STRING,  RTFROMADDR, RONLY, var_rt},
   {{INT_ACCT, 4, 1, 5, MAX_SUBID}, 10, STRING,  RTFROMMASK, RONLY, var_rt},
   {{INT_ACCT, 4, 1, 6, MAX_SUBID}, 10, STRING,  RTFROMTALLY, RONLY, var_rt},
   {{INT_ACCT, 4, 1, 7, MAX_SUBID}, 10, STRING,  RTTOADDR, RONLY, var_rt},
   {{INT_ACCT, 4, 1, 8, MAX_SUBID}, 10, STRING,  RTTOMASK, RONLY, var_rt},
   {{INT_ACCT, 4, 1, 9, MAX_SUBID}, 10, STRING,  RTTOTALLY, RONLY, var_rt},

   {{INT_ACCT, 4, 2, 0},          9, INTEGER, CRRULECOUNT, RWRITE, var_system},
   {{INT_ACCT, 4, 3, 0},          9, INTEGER, CRTREENBR, RWRITE, var_system},
   {{INT_ACCT, 4, 4, 0},          9, INTEGER, CRADDRTYPE, RWRITE, var_system},
   {{INT_ACCT, 4, 5, 0},          9, STRING,  CRFROMADDR, RWRITE, var_system},
   {{INT_ACCT, 4, 6, 0},          9, STRING,  CRFROMMASK, RWRITE, var_system},
   {{INT_ACCT, 4, 7, 0},          9, STRING,  CRFROMTALLY, RWRITE, var_system},
   {{INT_ACCT, 4, 8, 0},          9, STRING,  CRTOADDR, RWRITE, var_system},
   {{INT_ACCT, 4, 9, 0},          9, STRING,  CRTOMASK, RWRITE, var_system},
   {{INT_ACCT, 4,10, 0},          9, STRING,  CRTOTALLY, RWRITE, var_system},

   {{AUKUNI, 1, 1, 0},           10, INTEGER, PTTYPES, RONLY, var_system},
   {{AUKUNI, 1, 2, 1, 1, 0xFF},  12, STRING, PTPACKETTYPE, RONLY, var_pt},
   {{AUKUNI, 1, 2, 1, 2, 0xFF},  12, COUNTER, PTPACKETCOUNT, RONLY, var_pt},
   {{AUKUNI, 1, 2, 1, 3, 0xFF},  12, COUNTER, PTBYTECOUNT, RONLY, var_pt},

   {{AUKUNI, 2, 1, 0},           10, INTEGER, PCNEARMEM, RONLY, var_system},
   {{AUKUNI, 2, 2, 0},           10, INTEGER, PCFARMEM, RONLY, var_system},
   {{AUKUNI, 2, 3, 0},           10, INTEGER, PCBADPKTS, RONLY, var_system},
   {{AUKUNI, 2, 4, 0},           10, INTEGER, PCNOBUFPKTS, RONLY, var_system},
   {{AUKUNI, 2, 5, 0},           10, INTEGER, PCLOSTPKTS, RONLY, var_system},
   {{AUKUNI, 2, 6, 0},           10, INTEGER, PCPKTBACKLOG, RONLY, var_system},
   {{AUKUNI, 2, 7, 0},           10, INTEGER, PCCHKSEARCHES, RONLY, var_system},
   {{AUKUNI, 2, 8, 0},           10, INTEGER, PCCHKCOMPARES, RONLY, var_system}
   };

long packet_types = 1;  /* Nbr of different packet types seen since startup */
			/* Starts at 1 for 802.3 packets */

/*
 * getStatPtr - return a pointer to the named variable, as well as it's
 * type, length, and access control list.
 *
 * If an exact match for the variable name exists, it is returned.  If not,
 * and exact is false, the next variable lexicographically after the
 * requested one is returned.
 *
 * If no appropriate variable can be found, NULL is returned.
 */
u_char	*
getStatPtr(name, namelen, type, len, acl, exact, access_method)
    oid		*name;	    /* IN - name of var, OUT - name matched */
    int		*namelen;   /* IN -number of sub-ids in name, OUT - subid-is in matched name */
    u_char	*type;	    /* OUT - type of matched variable */
    int		*len;	    /* OUT - length of matched variable */
    u_short	*acl;	    /* OUT - access control list */
    int		exact;	    /* IN - TRUE if exact match wanted */
    int		*access_method; /* OUT - 1 if function, 0 if char * */
{
    register struct variable	*vp;

    register int	x;
    register u_char	*access;
    int			result;
    register int	minlen;
    register oid	*name1, *name2;

    for(x = 0, vp = variables; x < sizeof(variables)/sizeof(struct variable); vp++, x++){
	if (*namelen < (int)vp->namelen)
	    minlen = *namelen;
	else
	    minlen = (int)vp->namelen;
	name1 = name; name2 = vp->name;
	result = 0;
	while(minlen-- > 0){
	    if (*name1 < *name2){
		result = -1;
		break;
	    }
	    if (*name2++ < *name1++){
		result = 1;
		break;
	    }
	}
	if (result == 0){
	    if (*namelen < (int)vp->namelen)
		result = -1;	/* name1 shorter so it is "less" */
	    else if ((int)vp->namelen < *namelen)
		result = 1;
	    else
		result = 0;
	}
/*	result = compare(name, *namelen, vp->name, (int)vp->namelen); */
	if ((result < 0) || (exact && (result == 0))){
	    access = (*(vp->findVar))(vp, name, namelen, exact, len, access_method);
	    if (access != NULL)
		break;
	}
    }
    if (x == sizeof(variables)/sizeof(struct variable))
	return NULL;

    /* vp now points to the approprate struct */
    *type = vp->type;
    *acl = vp->acl;
    return access;
}

int
compare(name1, len1, name2, len2)
    register oid	    *name1, *name2;
    register int	    len1, len2;
{
    register int    len;

    /* len = minimum of len1 and len2 */
    if (len1 < len2)
	len = len1;
    else
	len = len2;
    /* find first non-matching byte */
    while(len-- > 0){
	if (*name1 < *name2)
	    return -1;
	if (*name2++ < *name1++)
	    return 1;
    }
    /* bytes match up to length of shorter string */
    if (len1 < len2)
	return -1;  /* name1 shorter, so it is "less" */
    if (len2 < len1)
	return 1;
    return 0;	/* both strings are equal */
}

char version_descr[] = "AU Internet Accounting Meter V1.2";
oid version_id[] = {
     1,  3,  6,       1,      4,          1,   411,     1, 1};
/* iso.org.dod.internet.private.enterprises.aukuni.monitor.1 */

int checkpoint_value;

extern char snmp_peer[];  /* Declared in snmpd.c */
extern int pkt_backlog;

void show_peer()  /* Display time and peername in window */
{
   w_roll(0,7, 40,24, 1);
   printf("%02d%02d:%02d -- %s", tod_h,tod_m,tod_s, snmp_peer);
   }

void display_msg(msg)
char *msg;
{
   w_roll(0,7, 40,24, 1);
   printf(msg);
   }

u_char *
var_system(vp, name, length, exact, var_len, write_method)
    register struct variable *vp;   /* IN - pointer to variable entry that points here */
    register oid	*name;	    /* IN/OUT - input name requested, output name found */
    register int	*length;    /* IN/OUT - length of input and output oid's */
    int			exact;	    /* IN - TRUE if an exact match was requested. */
    int			*var_len;   /* OUT - length of variable or 0 if function returned. */
    int			(**write_method)(); /* OUT - 1 if function, 0 if char pointer. */
{
#ifndef AU_MSDOS
    struct timeval now, boottime;
#endif
   unsigned long dummy;
   extern int writeCheckPoint(), writeRuleCount(),
       writeAddress(), writeTreeNbr(), writeAddrType();

    if (exact && (compare(name, *length, vp->name, (int)vp->namelen) != 0))
	return NULL;
    bcopy((char *)vp->name, (char *)name, (int)vp->namelen * sizeof(oid));
    *length = vp->namelen;
    *write_method = 0;
    *var_len = sizeof(long);	/* default length */
    switch (vp->magic){
	case VERSION_DESCR:
	    *var_len = strlen(version_descr);
	    return (u_char *)version_descr;
	case VERSION_ID:
	    *var_len = sizeof(version_id);
	    return (u_char *)version_id;
	case UPTIME:
#ifdef AU_MSDOS
	    long_return = uptime();
#else
	    klseek(nl[N_BOOTTIME].n_value);
	    klread((char *)&boottime, sizeof(boottime));
	    gettimeofday(&now, (struct timezone *)0);
	    long_return = (now.tv_sec - boottime.tv_sec) * 100
		    + (now.tv_usec - boottime.tv_usec) / 10000;
#endif
	    return (u_char *) &long_return;
	case IFNUMBER:
	    long_return = 1;  /* 1 ethernet card to start with */
	    return (u_char *)&long_return;

   case PTTYPES:
      long_return = (long)packet_types;
      return (u_char *)&long_return;

   case FTFLOWCOUNT:
      long_return = (long)nflows;
      return (u_char *)&long_return;
   case FTCHKFLOWCOUNT:
      long_return = (long)s_nflows;
      return (u_char *)&long_return;
   case FTCHKACTFLOWS:
      long_return = (long)s_act_flows;
      return (u_char *)&long_return;
   case FTFIRSTACTFLOW:
      long_return = (long)s_first_flow+1;  /* 1-org */
      return (u_char *)&long_return;
   case FTCHKTIME:
      long_return = s_chktime;
      return (u_char *)&long_return;
   case FTPREVCHKTIME:
      long_return = p_s_chktime;
      return (u_char *)&long_return;

   case FTCHECKPOINT:
      *write_method = writeCheckPoint;
      long_return = (long)checkpoint_value;
      return (u_char *)&long_return;

   case CRRULECOUNT:
      *write_method = writeRuleCount;
      long_return = (long)nrules;
      return (u_char *)&long_return;

   case CRTREENBR:
      *write_method = writeTreeNbr;
      long_return = (long)crp->i.tree_nbr;
      return (u_char *)&long_return;
   case CRADDRTYPE:
      *write_method = writeAddrType;
      long_return = (long)crp->k.addr_type;
      return (u_char *)&long_return;
   case CRFROMADDR:
      *write_method = writeAddress;
      *var_len = ADDR_LEN;
      return (u_char *)crp->k.from_value;
   case CRFROMMASK:
      *write_method = writeAddress;
      *var_len = ADDR_LEN;
      return (u_char *)crp->k.from_mask;
   case CRFROMTALLY:
      *write_method = writeAddress;
      *var_len = ADDR_LEN;
      return (u_char *)crp->k.from_tally;
   case CRTOADDR:
      *write_method = writeAddress;
      *var_len = ADDR_LEN;
      return (u_char *)crp->k.to_value;
   case CRTOMASK:
      *write_method = writeAddress;
      *var_len = ADDR_LEN;
      return (u_char *)crp->k.to_mask;
   case CRTOTALLY:
      *write_method = writeAddress;
      *var_len = ADDR_LEN;
      return (u_char *)crp->k.to_tally;

   case PCNEARMEM:
      long_return = (long)coreleft();
      return (u_char *)&long_return;
   case PCFARMEM:
      long_return = (long)farcoreleft();
      return (u_char *)&long_return;
   case PCBADPKTS:
      return (u_char *)&badpackets;
   case PCNOBUFPKTS:
      return (u_char *)&nobufpackets;
   case PCLOSTPKTS:
      return (u_char *)&lostpackets;
   case PCPKTBACKLOG:
      long_return = (long)pkt_backlog;
      return (u_char *)&long_return;
   case PCCHKSEARCHES:
      tree_stats(&long_return, &dummy);
      return (u_char *)&long_return;
   case PCCHKCOMPARES:
      tree_stats(&dummy, &long_return);
      return (u_char *)&long_return;

   default:
      ERROR("");
      }
   return NULL;
   }

int string_OK(t)
int t;
{
   if (t != STRING){
      display_msg("not string");
      return FALSE;
      }
   return TRUE;
   }

int int_OK(t)
int t;
{
   if (t != INTEGER){
      display_msg("not integer");
      return FALSE;
      }
   return TRUE;
   }

int
writeCheckPoint(doSet, var_val, var_val_type, var_val_len, statP)
   int      doSet;
   u_char   *var_val;
   u_char   var_val_type;
   int      var_val_len;
   u_char   *statP;
{
   int bigsize = 1000;
   long intval = 0;
   char msg[20];

   if (!int_OK(var_val_type)) return FALSE;
   asn_parse_int(var_val, &bigsize, &var_val_type, &intval, sizeof(intval));

   if (doSet) {
      show_peer();
      checkpoint_value = intval;
      if (intval == 0) {  /* Checkpoint 0 re-initialises the forest */
	 clear_flows();
	 setup_flows();
	 display_msg("   Flow couting restarted");
	 }
      else {
	 save_counts();
	 sprintf(msg,"   Checkpoint %d", checkpoint_value);
	 display_msg(msg);
	 }
      }
   return TRUE;
   }

int
writeRuleCount(doSet, var_val, var_val_type, var_val_len, statP)
   int      doSet;
   u_char   *var_val;
   u_char   var_val_type;
   int      var_val_len;
   u_char   *statP;
{
   int bigsize = 1000;
   long intval = 0;
   unsigned char byte, msg[20];

   if (!int_OK(var_val_type)) return FALSE;
   asn_parse_int(var_val, &bigsize, &var_val_type, &intval, sizeof(intval));
   if (intval != nrules+1  /* Adding a rule to table */
	 && intval != 0) {  /* Clearing the rule table */
      display_msg("bad Rule nbr");
      return FALSE;
      }
   if (doSet) {
      if (intval == 0) {
	 clear_rule_table();
	 display_msg("   Rule table cleared");
	 }
      else {
	 add_rule();
	 sprintf(msg,"   Rule %d added", nrules);
	 display_msg(msg);
	 }
      }
   return TRUE;
  }

int
writeAddress(doSet, var_val, var_val_type, var_val_len, statP)
   int      doSet;
   u_char   *var_val;
   u_char   var_val_type;
   int      var_val_len;
   u_char   *statP;
{
   int size, bigsize = 1000;
   u_char buf[ADDR_LEN], *cp;

   if (!string_OK(var_val_type)) return FALSE;
   if (var_val_len != ADDR_LEN) {
      display_msg("bad Address");
      return FALSE;
      }
   size = sizeof(buf);
   asn_parse_string(var_val, &bigsize, &var_val_type, (long *)buf, &size);
   if (doSet) {
      addrcpy(statP, buf, ADDR_LEN);
      }
   return TRUE;
   }

int
writeTreeNbr(doSet, var_val, var_val_type, var_val_len, statP)
   int      doSet;
   u_char   *var_val;
   u_char   var_val_type;
   int      var_val_len;
   u_char   *statP;
{
   int bigsize = 1000;
   long intval = 0;

   if (!int_OK(var_val_type)) return FALSE;
   asn_parse_int(var_val, &bigsize, &var_val_type, &intval, sizeof(intval));
   if (intval < 0 || intval >=  FORESTSZ) {
      display_msg("bad TreeNbr");  return FALSE;
      }
   if (doSet) crp->i.tree_nbr = intval;
   return TRUE;
   }

int
writeAddrType(doSet, var_val, var_val_type, var_val_len, statP)
   int      doSet;
   u_char   *var_val;
   u_char   var_val_type;
   int      var_val_len;
   u_char   *statP;
{
   int bigsize = 1000;
   long intval = 0;

   if (!int_OK(var_val_type)) return FALSE;
   asn_parse_int(var_val, &bigsize, &var_val_type, &intval, sizeof(intval));
   if (intval < AT_IP || intval > AT_ETHERTALK) {
      display_msg("bad AddrType");  return FALSE;
      }
   if (doSet) crp->k.addr_type = intval;
   return TRUE;
   }

#define NPKTTYPES   300
#define MAXPKTLEN  1526

struct pt_entry {
   u_char type[2];  /* snmp variables */
   u_long packets;
   u_long bytes;

   int pkt_type;    /* for searching the table */
   };
struct pt_entry pt_table[NPKTTYPES+1] = {
    {{0x00,0x00}, 0,0, 1 },  /* 0-th entry for 802.3 packets */
    {{0x00,0x00}, 0,0, 0 }
};

#ifndef AU_MSDOS
unsigned char buf[CHUNKSIZE];

void nit_read(nit_fd)
int nit_fd;
{
   int cc;
   u_char *bp,*bufstop;
   int pkt_type;
   register struct pt_entry *ptep;

   cc = read(nit_fd, buf, CHUNKSIZE);
   bp = buf;
   bufstop = buf+cc;
   while (bp < bufstop) {
      register u_char *cp = bp;
      struct nit_bufhdr *hdrp;
      struct nit_iflen *nlp;

      hdrp = (struct nit_bufhdr *)cp;  cp += sizeof *hdrp;
      nlp = (struct nit_iflen *)cp;  cp += sizeof *nlp;
      bp += hdrp->nhb_totlen;

      pkt_type = cp[12]<<8 | cp[13];
      ptep = pt_table;
      if (pkt_type > MAXPKTLEN) {  /* Not an 802.3 packet */
	 for (++ptep; ptep->pkt_type != 0; ++ptep) {
	    if (ptep->pkt_type == pkt_type) break;
	    }
	 if (ptep->pkt_type == 0  /* Packet type not found */
	       && packet_types != NPKTTYPES) {
	    ptep->type[0] = cp[12];  ptep->type[1] = cp[13];
	    ptep->pkt_type = pkt_type;
	    ptep->packets = ptep->bytes = 0;
	    (ptep + 1)->pkt_type = 0;
	    packet_types += 1;
	    }
	 }
      ptep->packets += 1;
      ptep->bytes += nlp->nh_pktlen;
      }
   }
#endif

u_char *	/* Packet type table */
var_pt(vp, name, length, exact, var_len, write_method)
    register struct variable *vp;   /* IN - pointer to variable entry that points here */
    register oid	*name;	    /* IN/OUT - input name requested, output name found */
    register int	*length;    /* IN/OUT - length of input and output oid's */
    int			exact;	    /* IN - TRUE if an exact match was requested. */
    int			*var_len;   /* OUT - length of variable or 0 if function returned. */
    int			(**write_method)(); /* OUT - 1 if function, 0 if char pointer. */
{
   oid newname[MAX_NAME_LEN];
   register int	j;
   register struct pt_entry *ptep;
   int result;

   bcopy((char *)vp->name, (char *)newname, (int)vp->namelen * sizeof(oid));
   for(j = 1, ptep = pt_table;  ptep->pkt_type != 0;  ++j, ++ptep) {
      newname[11] = (oid)j;
      result = compare(name, *length, newname, (int)vp->namelen);
      if ((exact && (result == 0)) || (!exact && (result < 0))) break;
      }
   if (ptep->pkt_type == 0) return NULL;
   bcopy((char *)newname, (char *)name, (int)vp->namelen * sizeof(oid));
   *length = vp->namelen;

   *write_method = 0;
   *var_len = sizeof(long);
   switch (vp->magic) {
   case PTPACKETTYPE:
      *var_len = 2;
      return ptep->type;
      case PTPACKETCOUNT:
      return (u_char *)&ptep->packets;
   case PTBYTECOUNT:
      return (u_char *)&ptep->bytes;
   default:
      ERROR("");
      }
   return NULL;
   }

u_char string_return[ADDR_LEN];

#define string_value(str,strlen)  addrcpy(\
   (unsigned char far *)string_return,\
   (unsigned char far *)str, strlen)

void build_flow_blob(fx)
int fx;  /* First active flow (1-org) */
{
   struct active_flow_data *afdp;
   unsigned int x,n;
   node_p t;

   for (n = 0, afdp = flow_blob.afd, x = fx-1;
	 n != FLOWBLOBSZ;  ++n, ++afdp, ++x) {
      for ( ; x < s_nflows;  ++x) {  /* Find next active flow */
	 if ((t = find_flow(x)) != NULL && t->i.f.s_active) {
	    afdp->flow_nbr = htons(x+1);
	    afdp->fwd_bytes = htonl(t->i.f.s_fwd_bytes);
	    afdp->back_bytes = htonl(t->i.f.s_back_bytes);
	    break;
	    }
	 }
      if (x >= s_nflows) {
	 for ( ; n != FLOWBLOBSZ; ++n, ++afdp) {
	    afdp->flow_nbr = 0;
	    afdp->fwd_bytes = afdp->back_bytes = 0L;
	    }
	 return;
	 }
      }
   }

u_char *	/* Flow table */
var_ft(vp, name, length, exact, var_len, write_method)
    register struct variable *vp;   /* IN - pointer to variable entry that points here */
    register oid	*name;	    /* IN/OUT - input name requested, output name found */
    register int	*length;    /* IN/OUT - length of input and output oid's */
    int			exact;	    /* IN - TRUE if an exact match was requested. */
    int			*var_len;   /* OUT - length of variable or 0 if function returned. */
    int			(**write_method)(); /* OUT - 1 if function, 0 if char pointer. */
{
   oid newname[MAX_NAME_LEN];
   unsigned int x;
   node_p t;

   bcopy((char *)vp->name, (char *)newname, (int)vp->namelen * sizeof(oid));

   if (exact) {
      newname[9] = name[9];
      x = (unsigned int)newname[9];
      if (compare(name,*length, newname,(int)vp->namelen) != 0  /* No match */
	 || (t = find_flow(x-1)) == NULL)  /* Doesn't exist */
	 return NULL;
      }
   else {
      x = compare(name,9, newname,9) != 0  /* Not in this ptTable column */
	 ? 1  /* Have to search whole table */
	 : (unsigned int)name[9];  /* Only search from specified row */
      for ( ;  x <= nflows;  ++x) {
	 if ((t = find_flow(x-1)) == NULL)  /* Ignore deallocated flows */
	    continue;
	 newname[9] = (oid)x;
	 if (compare(name, *length, newname, (int)vp->namelen) < 0) break;
	 }
      if (x > nflows) return NULL;
      }

   bcopy((char *)newname, (char *)name, (int)vp->namelen * sizeof(oid));
   *length = (int)vp->namelen;

   *write_method = 0;
   *var_len = sizeof(long);
   switch (vp->magic) {
   case FTFLOWNBR:
      long_return = (long)t->i.f.flow_nbr+1;  /* 1-org */
      return (u_char *)&long_return;
   case FTFLOWSTATUS:
      long_return = t->i.f.s_active ? 1L : 0L;
      return (u_char *)&long_return;
   case FTNEXTACTIVEFLOW:
      for (x = t->i.f.flow_nbr+1;  x != s_nflows;  ++x) {
	 if ((t = find_flow(x)) != NULL && t->i.f.s_active) {
	    long_return = (long)(x+1);  /* 1-org */
	    return (u_char *)&long_return;
	    }
	 }
      long_return = (long)0;  /* No more active rows at last save */
      return (u_char *)&long_return;
   case FTADDRTYPE:
      long_return = (long)t->k.addr_type;
      return (u_char *)&long_return;
   case FTFROMADDR:
      string_value(t->k.from_value, *var_len = ADDR_LEN);
      return (u_char *)string_return;
   case FTFROMMASK:
      string_value(t->k.from_mask, *var_len = ADDR_LEN);
      return (u_char *)string_return;
   case FTFROMTALLY:
      string_value(t->k.from_tally, *var_len = ADDR_LEN);
      return (u_char *)string_return;
   case FTTOADDR:
      string_value(t->k.to_value, *var_len = ADDR_LEN);
      return (u_char *)string_return;
   case FTTOMASK:
      string_value(t->k.to_mask, *var_len = ADDR_LEN);
      return (u_char *)string_return;
   case FTTOTALLY:
      string_value(t->k.to_tally, *var_len = ADDR_LEN);
      return (u_char *)string_return;
   case FTFWDPACKETS:
      long_return = t->i.f.fwd_packets;
      return (u_char *)&long_return;
   case FTFWDBYTES:
      long_return = t->i.f.fwd_bytes;
      return (u_char *)&long_return;
   case FTBACKPACKETS:
      long_return = t->i.f.back_packets;
      return (u_char *)&long_return;
   case FTBACKBYTES:
      long_return = t->i.f.back_bytes;
      return (u_char *)&long_return;
   case FTCHKFWDPKTS:
      long_return = t->i.f.s_fwd_packets;
      return (u_char *)&long_return;
   case FTCHKFWDBYTES:
      long_return = t->i.f.s_fwd_bytes;
      return (u_char *)&long_return;
   case FTCHKBACKPKTS:
      long_return = t->i.f.s_back_packets;
      return (u_char *)&long_return;
   case FTCHKBACKBYTES:
      long_return = t->i.f.s_back_bytes;
      return (u_char *)&long_return;

   case FTFLOWBLOB:
      build_flow_blob(x);
      *var_len = sizeof(flow_blob);
      return (u_char *)&flow_blob;

   default:
      ERROR("");
      }
   return NULL;
   }

u_char *	/* Rule table */
var_rt(vp, name, length, exact, var_len, write_method)
    register struct variable *vp;   /* IN - pointer to variable entry that points here */
    register oid	*name;	    /* IN/OUT - input name requested, output name found */
    register int	*length;    /* IN/OUT - length of input and output oid's */
    int			exact;	    /* IN - TRUE if an exact match was requested. */
    int			*var_len;   /* OUT - length of variable or 0 if function returned. */
    int			(**write_method)(); /* OUT - 1 if function, 0 if char pointer. */
{
   oid newname[MAX_NAME_LEN];
   unsigned int x;
   node_p t;

   bcopy((char *)vp->name, (char *)newname, (int)vp->namelen * sizeof(oid));

   if (nrules == 0) return FALSE;
   if (exact) {
      newname[9] = name[9];
      x = (unsigned int)newname[9];
      if (compare(name,*length, newname,(int)vp->namelen) != 0  /* No match */
	 || (t = find_rule(x)) == NULL)  /* Doesn't exist */
	 return NULL;
      }
   else {
      x = compare(name,9, newname,9) != 0  /* Not in this rtTable column */
	 ? 1  /* Have to search whole table */
	 : (unsigned int)name[9];  /* Only search from specified row */
      for ( ;  x <= nrules;  ++x) {
	 newname[9] = (oid)x;
	 if (compare(name, *length, newname, (int)vp->namelen) < 0) break;
	 }
      if (x > nrules) return NULL;
      t = find_rule(x);
      }

   bcopy((char *)newname, (char *)name, (int)vp->namelen * sizeof(oid));
   *length = (int)vp->namelen;

   *write_method = 0;
   *var_len = ADDR_LEN;
   switch (vp->magic) {
   case RTRULENBR:
      *var_len = sizeof(long);
      long_return = (long)x;
      return (u_char *)&long_return;
   case RTTREENBR:
      *var_len = sizeof(long);
      long_return = (long)t->i.tree_nbr;
      return (u_char *)&long_return;
   case RTADDRTYPE:
      *var_len = sizeof(long);
      long_return = (long)t->k.addr_type;
      return (u_char *)&long_return;
   case RTFROMADDR:
      string_value(t->k.from_value, ADDR_LEN);
      return (u_char *)string_return;
   case RTFROMMASK:
      string_value(t->k.from_mask, ADDR_LEN);
      return (u_char *)string_return;
   case RTFROMTALLY:
      string_value(t->k.from_tally, ADDR_LEN);
      return (u_char *)string_return;
   case RTTOADDR:
      string_value(t->k.to_value, ADDR_LEN);
      return (u_char *)string_return;
   case RTTOMASK:
      string_value(t->k.to_mask, ADDR_LEN);
      return (u_char *)string_return;
   case RTTOTALLY:
      string_value(t->k.to_tally, ADDR_LEN);
      return (u_char *)string_return;
   default:
      ERROR("");
      }
   return NULL;
   }
