/* 1735, Tue 11 May 93

   CHART.C:  Strip chart in screen window for AU monitor

   Copyright (C) 1992,1993 by Nevil Brownlee,
   Computer Centre,  University of Auckland */

#include "pktsnap.h"

#include <mem.h>

#include <bios.h>
#include <dos.h>

#ifdef XXYYZZ
int kbstatus()  /* See if there's a kb character */
{
#ifdef INLINE
   _AH = 0x01;  geninterrupt(0x16);
   asm mov ax,0
   asm jz  kbsret
   asm mov al,1
kbsret:
   return _AX;
#else
   return bioskey(1);
#endif
#ifdef doitourselves
   union REGS call_regs, ret_regs;
   call_regs.h.ah = 0x01;  /* Test kb: Zero flag on => no char */
   int86(0x16,&call_regs,&ret_regs);
      /* Ecosoft C88 int86 returns flags as result instead of in REGS */
      /* Turbo C int86 puts flags in REGS and returns AX as result ! */
   return !(ret_regs.x.flags & 0x40);  /* Zero flag */
#endif
   }

unsigned char kbcode()  /* Read char from the keyboard */
{  _AH = 0x00;  geninterrupt(0x16);  return _AL;  }  /* AH = scan code */
#endif


#define UP     0x06  /* BIOS scroll parameters */
#define DOWN   0x07
#define CHATR  0x07  /* Screen attribute for chart */

void bios_scroll(way, tx,ty, bx,by, nrows, attr)
int way, tx,ty, bx,by, nrows, attr;
{
   _AH = (way == UP) ? UP : DOWN;  /* Scroll direction */
   _AL = nrows;  /* Rows to scroll */
   _BH = attr;  /* Screen attribute for blank fill */
   _CH = ty; _CL = tx;  /* Top left */
   _DH = by; _DL = bx;  /* Bottom right */
   geninterrupt(0x10);
   }

void scpos(x,y)  /* Set Cursor Position */
unsigned char x,y;
{
   _AH = 2;  _BH = 0;  _DH = y;  _DL = x;
   geninterrupt(0x10);
   }

void sputc(c)  /* Write char to screen, don't move cursor */
unsigned char c;
{
   _BH = 0;  _CX = 1;  _AH = 10;  _AL = c;
   geninterrupt(0x10);
   }

void swrite(c)  /* Write char to screen */
unsigned char c;
{
   _AH = 14;  _AL = c;
   geninterrupt(0x10);
   }

#define MTICKS     1092L  /* 18.20000 per second */
#define HTICKS    65543L  /* 18.20639 */
#define DTICKS  1573040L  /* 18.20648 */

#define DCSEC   8640000L  /* centiseconds per day */

long biosticks()
{
   long tt = biostime(0,0L);  /* Clock ticks */
   if (tt < l_tod) ++midnight_crossings;
   return l_tod = tt;
   }

long uptime()  /* Since startup, in centiseconds */
{
   return ((biosticks()-boot_time)*549L+275L)/100L  /* cs per clock tick */
      + (long)midnight_crossings*DCSEC;
   }

void set_tod()
{
   long tt = biosticks();
   tod_h = tt/HTICKS;  tt -= (long)tod_h*HTICKS;
   tod_m = tt/MTICKS;  tt -= (long)tod_m*MTICKS;
   tod_s = (tt*10+91l)/182l;
   if (tod_s == 60) {
      ++tod_m;  tod_s = 0;
      }
   if (tod_m == 60) {
      ++tod_h;  tod_m = 0;
      }
   if (tod_h == 24) tod_h = 0;
   }

void sclear()
{
   bios_scroll(UP, 0,0,  79,24, 0, CHATR);  /* Blank screen */
   }

void w_clear(tx,ty, bx,by)
int tx,ty, bx,by;
{
   bios_scroll(UP, tx,ty,  bx,by, 0, CHATR);  /* Blank window */
   }

void w_roll(tx,ty, bx,by, n)
int tx,ty, bx,by, n;
{
   bios_scroll(UP, tx,ty,  bx,by, n, CHATR);  /* Roll window up n lines */
   scpos(tx,by);  /* Leave cursor at start of bottom window line */
   }

#define DOT  0xFA  /* Small dot in centre of char rectangle */

void chart(tx,ty, bx,by, x1,x2,x3)
int tx,ty, bx,by, x1,x2,x3;
{
	   int w,k;
#define TIMEWIDTH  8
   char buf[TIMEWIDTH+102], *bar;
   bios_scroll(UP, tx,ty,  bx,by, 1, CHATR);
   w = bx+1-tx - TIMEWIDTH;  /* Plot chars from bar[0] to bar[w-1], 0-org */
   bar = &buf[TIMEWIDTH];
   if (tod_s%30 == 0) {
      sprintf(buf, "%02d%02d:%02d +", tod_h,tod_m,tod_s);
      memset(bar+1,DOT,w-1);
      }
   else {
      memset(buf, ' ',TIMEWIDTH+w);
      bar[0] = '|';
      }
   for (k = 10; k < w; k += 10) bar[k] = ':';
   if (x1 >= w) x1 = w;
   if (x2 >= w) x2 = w;
   if (x3 >= w) x3 = w;
   for (k = x1+1; k < x3; ++k) bar[k] = '-';
   for (k = 10; k < w; k += 10)
      if (bar[k] == '-') bar[k] = '+';
   bar[x1] = '<';
   bar[x3] = '>';
   bar[x2] = '*';
   k = bar[w-1];  bar[w-1] = '\0';
   scpos(tx,by);
   for (bar = buf; *bar; ) swrite(*bar++);
   sputc(k);  /* Leave cursor at (bx,by) */
   }
